/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.MtpException;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.redis.cache.store.NamespaceSerializedObjectCodec;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStore;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreBase;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisIndexedCacheStore
extends RedisCacheStoreBase {
    private static final Logger logger = LoggerFactory.getLogger(RedisIndexedCacheStore.class);
    private final int indexSize;
    private final RedisCacheStore wrapped;
    private StatefulRedisConnection<String, Object> redisIndexConn;
    private RedisCommands<String, Object> redisIndexCmds;

    public RedisIndexedCacheStore(RedisCacheStoreFactory factory, String namespace, int indexSize, boolean isSave, final RedisCacheStore wrapped) {
        super(factory, namespace, wrapped.getTimeToLive(), isSave);
        this.indexSize = indexSize;
        this.wrapped = wrapped;
        this.redisIndexConn = factory.getClient().connect((RedisCodec)new NamespaceSerializedObjectCodec(namespace));
        this.redisIndexCmds = this.redisIndexConn.sync();
        wrapped.addPubSubListener(new RedisPubSubListener<String, String>(){

            public void unsubscribed(String channel, long count) {
            }

            public void subscribed(String channel, long count) {
            }

            public void punsubscribed(String pattern, long count) {
            }

            public void psubscribed(String pattern, long count) {
            }

            public void message(String pattern, String channel, String message) {
            }

            public void message(String channel, String message) {
                String prefix = wrapped.getCodec().getNamespaceHandler().getPrefix();
                if (message.startsWith(prefix)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Occur expired event. channel:%s, message:%s", channel, message));
                    }
                    Object key = RedisIndexedCacheStore.this.decodeBase64(message.substring(prefix.length()));
                    RedisIndexedCacheStore.this.removeAllFromIndex(key);
                }
            }
        });
    }

    @Override
    public String getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public CacheStoreFactory getFactory() {
        return this.wrapped.getFactory();
    }

    public CacheEntry put(CacheEntry entry, boolean clean) {
        try {
            this.wrapped.multi();
            CacheEntry previous = this.wrapped.put(this.redisIndexCmds, entry, clean);
            if (previous != null) {
                this.removeFromIndex(previous);
            }
            this.addToIndex(entry);
            this.wrapped.exec();
            return previous;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public CacheEntry putIfAbsent(CacheEntry entry) {
        try {
            this.wrapped.multi();
            CacheEntry previous = this.wrapped.putIfAbsent(this.redisIndexCmds, entry);
            if (previous == null) {
                this.addToIndex(entry);
            }
            this.wrapped.exec();
            return previous;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public CacheEntry get(Object key) {
        return this.wrapped.get(key);
    }

    public CacheEntry remove(Object key) {
        try {
            this.wrapped.multi();
            CacheEntry previous = this.wrapped.remove(this.redisIndexCmds, key);
            if (previous != null) {
                this.removeFromIndex(previous);
            }
            this.wrapped.exec();
            return previous;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public boolean remove(CacheEntry entry) {
        try {
            this.wrapped.multi();
            boolean removed = this.wrapped.remove(this.redisIndexCmds, entry);
            if (removed) {
                this.removeFromIndex(entry);
            }
            this.wrapped.exec();
            return removed;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public CacheEntry replace(CacheEntry entry) {
        try {
            this.wrapped.multi();
            CacheEntry previous = this.wrapped.replace(this.redisIndexCmds, entry);
            if (previous != null) {
                this.removeFromIndex(previous);
                this.addToIndex(entry);
            }
            this.wrapped.exec();
            return previous;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        try {
            this.wrapped.multi();
            boolean replaced = this.wrapped.replace(this.redisIndexCmds, oldEntry, newEntry);
            if (replaced) {
                this.removeFromIndex(oldEntry);
                this.addToIndex(newEntry);
            }
            this.wrapped.exec();
            return replaced;
        }
        catch (Exception e) {
            this.wrapped.discard();
            throw new MtpException((Throwable)e);
        }
    }

    public void removeAll() {
        this.wrapped.removeAll();
    }

    public List<Object> keySet() {
        List keys = this.redisIndexCmds.keys((Object)"*");
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Object> keyList = new ArrayList<Object>();
            for (String key : keys) {
                Object keyObj = this.decodeBase64(key);
                if (keyObj instanceof IndexKey) continue;
                keyList.add(keyObj);
            }
            return keyList;
        }
        return Collections.emptyList();
    }

    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        List keyList = this.redisIndexCmds.lrange((Object)this.encodeBase64(new IndexKey(indexKey, indexValue)), 0L, -1L);
        for (Object key : keyList) {
            if (!this.isExpired(key)) {
                return this.wrapped.get(key);
            }
            this.removeFromIndex(indexKey, indexValue, key);
        }
        return null;
    }

    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        List keyList = this.redisIndexCmds.lrange((Object)this.encodeBase64(new IndexKey(indexKey, indexValue)), 0L, -1L);
        if (keyList != null && !keyList.isEmpty()) {
            ArrayList<CacheEntry> entryList = new ArrayList<CacheEntry>();
            for (Object key : keyList) {
                if (!this.isExpired(key)) {
                    entryList.add(this.wrapped.get(key));
                    continue;
                }
                this.removeFromIndex(indexKey, indexValue, key);
            }
            return entryList;
        }
        return Collections.emptyList();
    }

    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        List<CacheEntry> entryList = this.getListByIndex(indexKey, indexValue);
        for (CacheEntry entry : entryList) {
            this.remove(entry.getKey());
        }
        return entryList;
    }

    @Override
    public void addCacheEventListenner(CacheEventListener listener) {
        this.wrapped.addCacheEventListenner(listener);
    }

    @Override
    public void removeCacheEventListenner(CacheEventListener listener) {
        this.wrapped.removeCacheEventListenner(listener);
    }

    @Override
    public List<CacheEventListener> getListeners() {
        return this.wrapped.getListeners();
    }

    public String trace() {
        return this.wrapped.trace();
    }

    public void destroy() {
        this.wrapped.destroy();
        if (this.redisIndexCmds != null && this.redisIndexCmds.isOpen()) {
            this.redisIndexCmds.shutdown(this.isSave());
            this.redisIndexCmds = null;
        }
        if (this.redisIndexConn != null && this.redisIndexConn.isOpen()) {
            this.redisIndexConn.close();
            this.redisIndexConn = null;
        }
    }

    private void pushToIndex(int index, Object indexValue, Object key) {
        this.wrapped.rpush(this.encodeBase64(new IndexKey(index, indexValue)), key);
    }

    private void addToIndex(CacheEntry entry) {
        for (int i = 0; i < this.indexSize; ++i) {
            Object iKey = entry.getIndexValue(i);
            if (iKey instanceof Object[]) {
                Object[] iKeyArray = (Object[])iKey;
                for (int j = 0; j < iKeyArray.length; ++j) {
                    if (iKeyArray[j] == null) continue;
                    this.pushToIndex(i, iKeyArray[j], entry.getKey());
                }
                continue;
            }
            if (iKey == null) continue;
            this.pushToIndex(i, iKey, entry.getKey());
        }
    }

    private void removeFromIndex(int indexKey, Object indexValue, Object key) {
        this.wrapped.lrem(this.encodeBase64(new IndexKey(indexKey, indexValue)), 0L, key);
    }

    private void removeFromIndex(CacheEntry entry) {
        for (int i = 0; i < this.indexSize; ++i) {
            Object iKey = entry.getIndexValue(i);
            if (iKey instanceof Object[]) {
                Object[] iKeyArray = (Object[])iKey;
                for (int j = 0; j < iKeyArray.length; ++j) {
                    if (iKeyArray[j] == null) continue;
                    this.removeFromIndex(i, iKeyArray[j], entry.getKey());
                }
                continue;
            }
            if (iKey == null) continue;
            this.removeFromIndex(i, iKey, entry.getKey());
        }
    }

    private void removeAllFromIndex(Object key) {
        List iKeyList = this.redisIndexCmds.keys((Object)"*");
        try {
            this.redisIndexCmds.multi();
            for (String iKey : iKeyList) {
                this.redisIndexCmds.lrem((Object)iKey, 0L, key);
            }
            this.redisIndexCmds.exec();
        }
        catch (Exception e) {
            this.redisIndexCmds.discard();
            throw new MtpException((Throwable)e);
        }
    }

    private boolean isExpired(Object key) {
        return this.redisIndexCmds.ttl((Object)this.encodeBase64(key)) == -2L;
    }

    private static final class IndexKey
    implements Serializable {
        private static final long serialVersionUID = -2752341127081890863L;
        private int index;
        private Object value;

        public IndexKey(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "IndexKey [index=" + this.index + ", value=" + this.value + "]";
        }
    }
}

