/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.redis.cache.store.NamespaceSerializedObjectCodec;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreBase;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheStore
extends RedisCacheStoreBase {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheStore.class);
    private StatefulRedisConnection<String, Object> redisConn;
    private RedisCommands<String, Object> redisCmds;
    private StatefulRedisPubSubConnection<String, String> psConn;
    private RedisPubSubCommands<String, String> psCmds;
    private NamespaceSerializedObjectCodec codec;

    public RedisCacheStore(RedisCacheStoreFactory factory, String namespace, long timeToLive, boolean isSave) {
        super(factory, namespace, timeToLive, isSave);
        this.codec = new NamespaceSerializedObjectCodec(namespace);
        this.redisConn = factory.getClient().connect((RedisCodec)this.codec);
        this.redisCmds = this.redisConn.sync();
        this.psConn = factory.getClient().connectPubSub();
        this.psConn.addListener((RedisPubSubListener)new RedisPubSubListener<String, String>(){

            public void unsubscribed(String channel, long count) {
            }

            public void subscribed(String channel, long count) {
            }

            public void punsubscribed(String pattern, long count) {
            }

            public void psubscribed(String pattern, long count) {
            }

            public void message(String pattern, String channel, String message) {
            }

            public void message(String channel, String message) {
                String prefix = RedisCacheStore.this.codec.getNamespaceHandler().getPrefix();
                if (message.startsWith(prefix)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Occuer expired event. channel:%s, message:%s", channel, message));
                    }
                    Object key = RedisCacheStore.this.decodeBase64(message.substring(prefix.length()));
                    RedisCacheStore.this.notifyRemoved(new CacheEntry(key, null, new Object[0]));
                }
            }
        });
        this.psCmds = this.psConn.sync();
        this.psCmds.subscribe((Object[])new String[]{"__keyevent@0__:expired"});
    }

    boolean isExist(RedisCommands<String, Object> readCmds, String ... keys) {
        return readCmds.exists((Object[])keys).compareTo(0L) > 0;
    }

    CacheEntry put(RedisCommands<String, Object> readCmds, CacheEntry entry, boolean clean) {
        String strKey = this.encodeBase64(entry.getKey());
        CacheEntry previous = (CacheEntry)readCmds.get((Object)strKey);
        if (this.getTimeToLive() > 0L) {
            this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
        } else {
            this.redisCmds.set((Object)strKey, (Object)entry);
        }
        if (previous == null) {
            this.notifyPut(entry);
        } else {
            this.notifyUpdated(previous, entry);
        }
        return previous;
    }

    public CacheEntry put(CacheEntry entry, boolean clean) {
        return this.put(this.redisCmds, entry, clean);
    }

    CacheEntry putIfAbsent(RedisCommands<String, Object> readCmds, CacheEntry entry) {
        String strKey = this.encodeBase64(entry.getKey());
        CacheEntry previous = (CacheEntry)readCmds.get((Object)strKey);
        if (previous == null) {
            if (this.getTimeToLive() > 0L) {
                this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
            } else {
                this.redisCmds.set((Object)strKey, (Object)entry);
            }
            this.notifyPut(entry);
        }
        return previous;
    }

    public CacheEntry putIfAbsent(CacheEntry entry) {
        return this.putIfAbsent(this.redisCmds, entry);
    }

    public CacheEntry get(Object key) {
        if (key == null) {
            return null;
        }
        return (CacheEntry)this.redisCmds.get((Object)this.encodeBase64(key));
    }

    private CacheEntry remove(RedisCommands<String, Object> readCmds, String key) {
        if (this.isExist(readCmds, key)) {
            CacheEntry previous = (CacheEntry)readCmds.get((Object)key);
            this.redisCmds.del((Object[])new String[]{key});
            this.notifyRemoved(previous);
            return previous;
        }
        return null;
    }

    CacheEntry remove(RedisCommands<String, Object> readCmds, Object key) {
        if (key == null) {
            return null;
        }
        return this.remove(readCmds, this.encodeBase64(key));
    }

    public CacheEntry remove(Object key) {
        return this.remove(this.redisCmds, key);
    }

    boolean remove(RedisCommands<String, Object> readCmds, CacheEntry entry) {
        CacheEntry previous;
        String strKey = this.encodeBase64(entry.getKey());
        if (this.isExist(readCmds, strKey) && (previous = (CacheEntry)readCmds.get((Object)strKey)) != null && previous.equals((Object)entry)) {
            this.redisCmds.del((Object[])new String[]{strKey});
            this.notifyRemoved(previous);
            return true;
        }
        return false;
    }

    public boolean remove(CacheEntry entry) {
        return this.remove(this.redisCmds, entry);
    }

    CacheEntry replace(RedisCommands<String, Object> readCmds, CacheEntry entry) {
        String strKey = this.encodeBase64(entry.getKey());
        if (this.isExist(readCmds, strKey)) {
            CacheEntry preEntry = (CacheEntry)readCmds.get((Object)strKey);
            if (this.getTimeToLive() > 0L) {
                this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
            } else {
                this.redisCmds.set((Object)strKey, (Object)entry);
            }
            this.notifyUpdated(preEntry, entry);
            return preEntry;
        }
        return null;
    }

    public CacheEntry replace(CacheEntry entry) {
        return this.replace(this.redisCmds, entry);
    }

    boolean replace(RedisCommands<String, Object> readCmds, CacheEntry oldEntry, CacheEntry newEntry) {
        if (!oldEntry.getKey().equals(newEntry.getKey())) {
            throw new IllegalArgumentException("oldEntry key not equals newEntry key");
        }
        String strKey = this.encodeBase64(newEntry.getKey());
        if (this.isExist(readCmds, strKey) && oldEntry.equals(readCmds.get((Object)strKey))) {
            this.replace(readCmds, newEntry);
            return true;
        }
        return false;
    }

    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        return this.replace(this.redisCmds, oldEntry, newEntry);
    }

    public void removeAll() {
        List keys = this.redisCmds.keys((Object)"*");
        if (keys != null && !keys.isEmpty()) {
            if (this.hasListener()) {
                for (String key : keys) {
                    this.remove(key);
                }
            } else {
                this.redisCmds.del((Object[])keys.toArray(new String[keys.size()]));
            }
        }
    }

    public List<Object> keySet() {
        List keys = this.redisCmds.keys((Object)"*");
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Object> keyList = new ArrayList<Object>();
            for (String key : keys) {
                keyList.add(this.decodeBase64(key));
            }
            return keyList;
        }
        return Collections.emptyList();
    }

    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public String trace() {
        return this.redisCmds.info();
    }

    public void destroy() {
        if (this.psCmds != null && this.psCmds.isOpen()) {
            this.psCmds.unsubscribe((Object[])new String[]{"__keyevent@0__:expired"});
            this.psCmds.shutdown(false);
            this.psCmds = null;
        }
        if (this.psConn != null && this.psConn.isOpen()) {
            this.psConn.close();
            this.psConn = null;
        }
        if (this.redisCmds != null && this.redisCmds.isOpen()) {
            this.redisCmds.shutdown(this.isSave());
            this.redisCmds = null;
        }
        if (this.redisConn != null && this.redisConn.isOpen()) {
            this.redisConn.close();
            this.redisConn = null;
        }
    }

    NamespaceSerializedObjectCodec getCodec() {
        return this.codec;
    }

    void addPubSubListener(RedisPubSubListener<String, String> listener) {
        this.psConn.addListener(listener);
    }

    void multi() {
        this.redisCmds.multi();
    }

    void exec() {
        this.redisCmds.exec();
    }

    void discard() {
        this.redisCmds.discard();
    }

    Long lrem(String key, long count, Object value) {
        return this.redisCmds.lrem((Object)key, count, value);
    }

    Long rpush(String key, Object ... values) {
        return this.redisCmds.rpush((Object)key, values);
    }
}

