/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.time.Duration;
import org.iplass.mtp.MtpException;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.redis.RedisServer;
import org.iplass.mtp.impl.redis.RedisService;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheHandler;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStore;
import org.iplass.mtp.impl.redis.cache.store.RedisIndexedCacheStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;

public class RedisCacheStoreFactory
extends CacheStoreFactory
implements ServiceInitListener<CacheService> {
    private RedisServer server;
    private RedisClient client;
    private String serverName;
    private long timeToLive = 0L;

    public CacheStore createCacheStore(String namespace) {
        return this.createCacheStoreInternal(namespace);
    }

    public boolean canUseForLocalCache() {
        return false;
    }

    public boolean supportsIndex() {
        return true;
    }

    public CacheHandler createCacheHandler(CacheStore store) {
        return new RedisCacheHandler(store);
    }

    public CacheStoreFactory getLowerLevel() {
        return null;
    }

    public void inited(CacheService service, Config config) {
        RedisService rs = (RedisService)config.getDependentService(RedisService.class);
        this.server = rs.getRedisServer(this.serverName);
        if (this.server == null) {
            throw new MtpException("Unknown redis server name: " + this.serverName);
        }
        DefaultClientResources resouces = DefaultClientResources.builder().build();
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(this.server.getHost()).withPort(this.server.getPort());
        if (this.server.getTimeout() > 0L) {
            uriBuilder.withTimeout(Duration.ofSeconds(this.server.getTimeout()));
        }
        this.client = RedisClient.create((ClientResources)resouces, (RedisURI)uriBuilder.build());
    }

    public void destroyed() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    public RedisClient getClient() {
        return this.client;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    private CacheStore createCacheStoreInternal(String namespace) {
        RedisCacheStore store = new RedisCacheStore(this, namespace, this.timeToLive, false);
        return this.getIndexCount() > 0 ? new RedisIndexedCacheStore(this, namespace, this.getIndexCount(), false, store) : store;
    }
}

