/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.redis.RedisRuntimeException;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreBase;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStorePoolConfig;
import org.iplass.mtp.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedRedisCacheStore
extends RedisCacheStoreBase {
    private static final Logger logger = LoggerFactory.getLogger(IndexedRedisCacheStore.class);
    private final int indexSize;

    public IndexedRedisCacheStore(RedisCacheStoreFactory factory, String namespace, long timeToLive, int indexSize, RedisCacheStorePoolConfig redisCacheStorePoolConfig) {
        super(factory, namespace, timeToLive, redisCacheStorePoolConfig);
        this.indexSize = indexSize;
        this.pubSubConnection.addListener((RedisPubSubListener)new RedisPubSubListener<String, String>(){

            public void unsubscribed(String channel, long count) {
            }

            public void subscribed(String channel, long count) {
            }

            public void punsubscribed(String pattern, long count) {
            }

            public void psubscribed(String pattern, long count) {
            }

            public void message(String pattern, String channel, String message) {
            }

            public void message(String channel, String message) {
                String prefix = IndexedRedisCacheStore.this.codec.getPrefix();
                if (message.startsWith(prefix)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Occur expired event. channel:%s, message:%s", channel, message));
                    }
                    Object key = IndexedRedisCacheStore.this.codec.decodeKey(IndexedRedisCacheStore.this.codec.getCharset().encode(message));
                    IndexedRedisCacheStore.this.notifyRemoved(new CacheEntry(key, null, new Object[0]));
                    IndexedRedisCacheStore.this.removeAllIndexByEntryKey(key);
                }
            }
        });
        this.pubSubCommands = this.pubSubConnection.sync();
        this.pubSubCommands.subscribe((Object[])new String[]{"__keyevent@" + String.valueOf(factory.getServer().getDatabase()) + "__:expired"});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry get(Object key) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            CacheEntry cacheEntry = key != null ? (CacheEntry)commands.get(key) : null;
            return cacheEntry;
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not get CacheEntry. key:" + key, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry put(CacheEntry entry, boolean clean) {
        int count = 0;
        while (count <= this.retryCount) {
            try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                RedisCommands commands = connection.sync();
                commands.watch(new Object[]{entry.getKey()});
                CacheEntry previous = this.get(entry.getKey());
                List<IndexKey> previousIndexKeys = null;
                if (previous != null) {
                    previousIndexKeys = this.getIndexKeysFromEntry(previous);
                    commands.watch(new Object[]{previousIndexKeys});
                }
                commands.multi();
                if (this.timeToLive > 0L) {
                    commands.setex(entry.getKey(), this.timeToLive, (Object)entry);
                } else {
                    commands.set(entry.getKey(), (Object)entry);
                }
                if (previous != null && previousIndexKeys != null) {
                    this.removeIndexValues(previous, previousIndexKeys, (RedisCommands<Object, Object>)commands);
                }
                this.addIndexValues(entry, (RedisCommands<Object, Object>)commands);
                TransactionResult result = commands.exec();
                if (!result.wasDiscarded()) {
                    if (previous == null) {
                        this.notifyPut(entry);
                    } else {
                        this.notifyUpdated(previous, entry);
                    }
                    CacheEntry cacheEntry = previous;
                    return cacheEntry;
                }
            }
            catch (Exception e) {
                throw new RedisRuntimeException("can not put CacheEntry. entry:" + entry, e);
            }
            ++count;
        }
        throw new SystemException("can not put CacheEntry cause retry count over. entry:" + entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry putIfAbsent(CacheEntry entry) {
        int count = 0;
        while (count <= this.retryCount) {
            block25: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{entry.getKey()});
                    CacheEntry previous = this.get(entry.getKey());
                    if (previous == null) {
                        commands.multi();
                        if (this.timeToLive > 0L) {
                            commands.setex(entry.getKey(), this.timeToLive, (Object)entry);
                        } else {
                            commands.set(entry.getKey(), (Object)entry);
                        }
                        this.addIndexValues(entry, (RedisCommands<Object, Object>)commands);
                        TransactionResult result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyPut(entry);
                            CacheEntry cacheEntry = null;
                            return cacheEntry;
                        }
                        break block25;
                    }
                    commands.unwatch();
                    CacheEntry cacheEntry = previous;
                    return cacheEntry;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not putIfAbsent CacheEntry. entry:" + entry, e);
                }
            }
            ++count;
        }
        throw new SystemException("can not putIfAbsent CacheEntry cause retry count over:" + entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry compute(Object key, BiFunction<Object, CacheEntry, CacheEntry> remappingFunction) {
        int count = 0;
        while (count <= this.retryCount) {
            block46: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    CacheEntry cacheEntry;
                    TransactionResult result;
                    CacheEntry newEntry;
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{key});
                    CacheEntry oldEntry = this.get(key);
                    List<IndexKey> oldIndexKeys = null;
                    if (oldEntry != null) {
                        oldIndexKeys = this.getIndexKeysFromEntry(oldEntry);
                        commands.watch(new Object[]{oldIndexKeys});
                    }
                    if ((newEntry = remappingFunction.apply(key, oldEntry)) == null) {
                        if (oldEntry == null) {
                            commands.unwatch();
                            result = null;
                            return result;
                        }
                        commands.multi();
                        commands.del(new Object[]{key});
                        this.removeIndexValues(oldEntry, oldIndexKeys, (RedisCommands<Object, Object>)commands);
                        result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyRemoved(oldEntry);
                            cacheEntry = null;
                            return cacheEntry;
                        }
                        break block46;
                    }
                    if (oldEntry != null) {
                        if (!oldEntry.getKey().equals(newEntry.getKey())) {
                            throw new IllegalArgumentException("oldEntry key not equals newEntry key");
                        }
                        commands.multi();
                        if (this.timeToLive > 0L) {
                            commands.setex(newEntry.getKey(), this.timeToLive, (Object)newEntry);
                        } else {
                            commands.set(newEntry.getKey(), (Object)newEntry);
                        }
                        this.removeIndexValues(oldEntry, oldIndexKeys, (RedisCommands<Object, Object>)commands);
                        this.addIndexValues(newEntry, (RedisCommands<Object, Object>)commands);
                        result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyUpdated(oldEntry, newEntry);
                            cacheEntry = newEntry;
                            return cacheEntry;
                        }
                    } else {
                        commands.multi();
                        if (this.timeToLive > 0L) {
                            commands.setex(newEntry.getKey(), this.timeToLive, (Object)newEntry);
                        } else {
                            commands.set(newEntry.getKey(), (Object)newEntry);
                        }
                        this.addIndexValues(newEntry, (RedisCommands<Object, Object>)commands);
                        result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyPut(newEntry);
                            cacheEntry = newEntry;
                            return cacheEntry;
                        }
                    }
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not compute CacheEntry. key:" + key, e);
                }
            }
            ++count;
        }
        throw new SystemException("can not compute CacheEntry cause retry count over. key:" + key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry computeIfAbsent(Object key, Function<Object, CacheEntry> mappingFunction) {
        int count = 0;
        while (count <= this.retryCount) {
            try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                RedisCommands commands = connection.sync();
                commands.watch(new Object[]{key});
                CacheEntry oldEntry = this.get(key);
                if (oldEntry != null) {
                    commands.unwatch();
                    CacheEntry cacheEntry = oldEntry;
                    return cacheEntry;
                }
                commands.multi();
                CacheEntry newEntry = mappingFunction.apply(key);
                if (newEntry != null) {
                    if (this.timeToLive > 0L) {
                        commands.setex(newEntry.getKey(), this.timeToLive, (Object)newEntry);
                    } else {
                        commands.set(newEntry.getKey(), (Object)newEntry);
                    }
                    this.addIndexValues(newEntry, (RedisCommands<Object, Object>)commands);
                    TransactionResult result = commands.exec();
                    if (!result.wasDiscarded()) {
                        this.notifyPut(newEntry);
                        CacheEntry cacheEntry = newEntry;
                        return cacheEntry;
                    }
                }
            }
            catch (Exception e) {
                throw new RedisRuntimeException("can not computeIfAbsent CacheEntry. key:" + key, e);
            }
            ++count;
        }
        throw new SystemException("can not computeIfAbsent CacheEntry cause retry count over. key:" + key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry remove(Object key) {
        int count = 0;
        while (count <= this.retryCount) {
            block23: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{key});
                    CacheEntry previous = this.get(key);
                    if (previous != null) {
                        List<IndexKey> previousIndexKeys = this.getIndexKeysFromEntry(previous);
                        commands.watch(new Object[]{previousIndexKeys});
                        commands.multi();
                        commands.del(new Object[]{key});
                        this.removeIndexValues(previous, previousIndexKeys, (RedisCommands<Object, Object>)commands);
                        TransactionResult result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyRemoved(previous);
                            CacheEntry cacheEntry = previous;
                            return cacheEntry;
                        }
                        break block23;
                    }
                    commands.unwatch();
                    CacheEntry cacheEntry = null;
                    return cacheEntry;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not remove CacheEntry. key:" + key, e);
                }
            }
            ++count;
        }
        throw new SystemException("can not remove CacheEntry cause retry count over. key:" + key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(CacheEntry entry) {
        int count = 0;
        while (count <= this.retryCount) {
            block23: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{entry.getKey()});
                    CacheEntry previous = this.get(entry.getKey());
                    if (previous != null && previous.equals((Object)entry)) {
                        List<IndexKey> previousIndexKeys = this.getIndexKeysFromEntry(previous);
                        commands.watch(new Object[]{previousIndexKeys});
                        commands.multi();
                        commands.del(new Object[]{entry.getKey()});
                        this.removeIndexValues(previous, previousIndexKeys, (RedisCommands<Object, Object>)commands);
                        TransactionResult result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyRemoved(previous);
                            boolean bl = true;
                            return bl;
                        }
                        break block23;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not remove CacheEntry. entry:" + entry, e);
                }
            }
            ++count;
        }
        throw new SystemException("can not remove CacheEntry cause retry count over. key:" + entry.getKey());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry replace(CacheEntry entry) {
        int count = 0;
        while (count <= this.retryCount) {
            block25: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{entry.getKey()});
                    CacheEntry previous = this.get(entry.getKey());
                    if (previous != null) {
                        List<IndexKey> previousIndexKeys = this.getIndexKeysFromEntry(previous);
                        commands.watch(new Object[]{previousIndexKeys});
                        commands.multi();
                        if (this.timeToLive > 0L) {
                            commands.setex(entry.getKey(), this.timeToLive, (Object)entry);
                        } else {
                            commands.set(entry.getKey(), (Object)entry);
                        }
                        this.removeIndexValues(previous, previousIndexKeys, (RedisCommands<Object, Object>)commands);
                        this.addIndexValues(entry, (RedisCommands<Object, Object>)commands);
                        TransactionResult result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyUpdated(previous, entry);
                            CacheEntry cacheEntry = previous;
                            return cacheEntry;
                        }
                        break block25;
                    }
                    commands.unwatch();
                    CacheEntry cacheEntry = null;
                    return cacheEntry;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not replace CacheEntry. key:" + entry.getKey(), e);
                }
            }
            ++count;
        }
        throw new SystemException("can not replace CacheEntry. key:" + entry.getKey());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        if (!oldEntry.getKey().equals(newEntry.getKey())) {
            throw new IllegalArgumentException("oldEntry key not equals newEntry key");
        }
        int count = 0;
        while (count <= this.retryCount) {
            block26: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{oldEntry.getKey()});
                    CacheEntry previous = this.get(oldEntry.getKey());
                    if (previous != null && previous.equals((Object)oldEntry)) {
                        List<IndexKey> previousIndexKeys = this.getIndexKeysFromEntry(previous);
                        commands.watch(new Object[]{previousIndexKeys});
                        commands.multi();
                        if (this.timeToLive > 0L) {
                            commands.setex(newEntry.getKey(), this.timeToLive, (Object)newEntry);
                        } else {
                            commands.set(newEntry.getKey(), (Object)newEntry);
                        }
                        this.removeIndexValues(oldEntry, previousIndexKeys, (RedisCommands<Object, Object>)commands);
                        this.addIndexValues(newEntry, (RedisCommands<Object, Object>)commands);
                        TransactionResult result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyUpdated(previous, newEntry);
                            boolean bl = true;
                            return bl;
                        }
                        break block26;
                    }
                    commands.unwatch();
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not replace CacheEntry. key:" + newEntry.getKey(), e);
                }
            }
            ++count;
        }
        throw new SystemException("can not replace CacheEntry. key:" + newEntry.getKey());
    }

    public void removeAll() {
        this.keySet().forEach(key -> this.remove(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> keySet() {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            List keys = commands.keys((Object)"*");
            if (CollectionUtil.isNotEmpty((Collection)keys)) {
                ArrayList<Object> keyList = new ArrayList<Object>();
                keys.forEach(key -> {
                    if (!(key instanceof IndexKey)) {
                        keyList.add(key);
                    }
                });
                ArrayList<Object> arrayList = keyList;
                return arrayList;
            }
            List<Object> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not get keySet", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry getByIndex(int index, Object indexValue) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            IndexKey indexKey = new IndexKey(index, indexValue);
            List entryKeyList = commands.lrange((Object)indexKey, 0L, -1L);
            for (Object entryKey : entryKeyList) {
                CacheEntry entry = this.get(entryKey);
                if (entry != null) {
                    CacheEntry cacheEntry = entry;
                    return cacheEntry;
                }
                this.removeIndex(new IndexKey(index, indexValue), entryKey, (RedisCommands<Object, Object>)commands);
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not getByIndex CacheEntry. index:" + index + ", indexValue:" + indexValue, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CacheEntry> getListByIndex(int index, Object indexValue) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            IndexKey indexKey = new IndexKey(index, indexValue);
            List entryKeyList = commands.lrange((Object)indexKey, 0L, -1L);
            if (CollectionUtil.isNotEmpty((Collection)entryKeyList)) {
                ArrayList<CacheEntry> entryList = new ArrayList<CacheEntry>();
                entryKeyList.forEach(entryKey -> {
                    CacheEntry entry = this.get(entryKey);
                    if (entry != null) {
                        entryList.add(entry);
                    } else {
                        this.removeIndex(new IndexKey(index, indexValue), entryKey, (RedisCommands<Object, Object>)commands);
                    }
                });
                ArrayList<CacheEntry> arrayList = entryList;
                return arrayList;
            }
            List<CacheEntry> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not getListByIndex CacheEntry. index:" + index + ", indexValue:" + indexValue, e);
        }
    }

    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        List<CacheEntry> entryList = this.getListByIndex(indexKey, indexValue);
        entryList.forEach(entry -> this.remove(entry.getKey()));
        return entryList;
    }

    private List<IndexKey> getIndexKeysFromEntry(CacheEntry entry) {
        ArrayList<IndexKey> indexKeys = new ArrayList<IndexKey>();
        for (int i = 0; i < this.indexSize; ++i) {
            Object indexValue = entry.getIndexValue(i);
            if (indexValue instanceof Object[]) {
                Object[] indexValueArray = (Object[])indexValue;
                for (int j = 0; j < indexValueArray.length; ++j) {
                    if (indexValueArray[j] == null) continue;
                    indexKeys.add(new IndexKey(i, indexValueArray[j]));
                }
                continue;
            }
            if (indexValue == null) continue;
            indexKeys.add(new IndexKey(i, indexValue));
        }
        return indexKeys;
    }

    private void addIndexValues(CacheEntry entry, RedisCommands<Object, Object> commands) {
        List<IndexKey> indexKeys = this.getIndexKeysFromEntry(entry);
        for (IndexKey indexKey : indexKeys) {
            commands.rpush((Object)indexKey, new Object[]{entry.getKey()});
        }
    }

    private void removeIndexValues(CacheEntry entry, List<IndexKey> indexKeys, RedisCommands<Object, Object> commands) {
        for (IndexKey indexKey : indexKeys) {
            this.removeIndex(indexKey, entry.getKey(), commands);
        }
    }

    private void removeIndex(IndexKey indexKey, Object entryKey, RedisCommands<Object, Object> commands) {
        commands.lrem((Object)indexKey, 0L, entryKey);
    }

    private void removeAllIndexByEntryKey(Object entryKey) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            List keyList = commands.keys((Object)"*");
            commands.multi();
            keyList.forEach(key -> {
                if (key instanceof IndexKey) {
                    commands.lrem(key, 0L, entryKey);
                }
            });
            commands.exec();
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not removeAllIndexByEntryKey. key:" + entryKey, e);
        }
    }

    private static final class IndexKey
    implements Serializable {
        private static final long serialVersionUID = -2752341127081890863L;
        private int index;
        private Object value;

        public IndexKey(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "IndexKey [index=" + this.index + ", value=" + this.value + "]";
        }
    }
}

