/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.event.CacheCreateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheRemoveEvent;
import org.iplass.mtp.impl.cache.store.event.CacheUpdateEvent;
import org.iplass.mtp.impl.redis.RedisRuntimeException;
import org.iplass.mtp.impl.redis.cache.store.NamespaceSerializedObjectCodec;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStorePoolConfig;

public abstract class RedisCacheStoreBase
implements CacheStore {
    protected final StatefulRedisPubSubConnection<String, String> pubSubConnection;
    protected RedisPubSubCommands<String, String> pubSubCommands;
    private final RedisCacheStoreFactory factory;
    private final String namespace;
    protected final long timeToLive;
    protected final int retryCount;
    protected final NamespaceSerializedObjectCodec codec;
    protected final GenericObjectPool<StatefulRedisConnection<Object, Object>> pool;
    private final List<CacheEventListener> listeners;

    public RedisCacheStoreBase(RedisCacheStoreFactory factory, String namespace, long timeToLive, RedisCacheStorePoolConfig redisCacheStorePoolConfig) {
        this.pubSubConnection = factory.getClient().connectPubSub();
        this.factory = factory;
        this.namespace = namespace;
        this.timeToLive = timeToLive;
        this.retryCount = factory.getRetryCount();
        this.codec = new NamespaceSerializedObjectCodec(namespace);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        if (redisCacheStorePoolConfig != null) {
            redisCacheStorePoolConfig.apply((GenericObjectPoolConfig<StatefulRedisConnection<Object, Object>>)poolConfig);
        }
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> factory.getClient().connect((RedisCodec)this.codec), (GenericObjectPoolConfig)poolConfig);
        this.listeners = new CopyOnWriteArrayList<CacheEventListener>();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CacheStoreFactory getFactory() {
        return this.factory;
    }

    public List<CacheEventListener> getListeners() {
        return this.listeners;
    }

    public void addCacheEventListenner(CacheEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeCacheEventListenner(CacheEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSize() {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            List keys = commands.keys((Object)"*");
            int n = keys == null ? 0 : keys.size();
            return n;
        }
        catch (Exception e) {
            throw new RedisRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String trace() {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            String string = commands.info();
            return string;
        }
        catch (Exception e) {
            throw new RedisRuntimeException(e);
        }
    }

    public void destroy() {
        this.pool.close();
        this.factory.getClient().shutdown();
    }

    protected void notifyRemoved(CacheEntry entry) {
        if (this.hasListener()) {
            CacheRemoveEvent e = new CacheRemoveEvent(entry);
            this.listeners.forEach(listener -> listener.removed(e));
        }
    }

    protected void notifyPut(CacheEntry entry) {
        if (this.hasListener()) {
            CacheCreateEvent e = new CacheCreateEvent(entry);
            this.listeners.forEach(listener -> listener.created(e));
        }
    }

    protected void notifyUpdated(CacheEntry preEntry, CacheEntry entry) {
        if (this.hasListener()) {
            CacheUpdateEvent e = new CacheUpdateEvent(preEntry, entry);
            this.listeners.forEach(listener -> listener.updated(e));
        }
    }

    protected void notifyInvalidated(CacheEntry entry) {
        if (this.hasListener()) {
            CacheInvalidateEvent e = new CacheInvalidateEvent(entry);
            this.listeners.forEach(listener -> listener.invalidated(e));
        }
    }

    protected boolean hasListener() {
        return this.listeners != null ? this.listeners.size() > 0 : false;
    }
}

