/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

public class RedisCacheStoreLuaScript {
    public static final String PUT = "local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous";
    public static final String PUT_IF_ABSENT = "local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous";
    public static final String REMOVE_BY_KEY = "local cacheKey = KEYS[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous";
    public static final String REMOVE_BY_ENTRY = "local cacheKey = KEYS[1]\nlocal cacheEntry = ARGV[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= cacheEntry then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous";
    public static final String REMOVE_ALL = "local key = KEYS[1]\nlocal keys = redis.call('KEYS', key)\nif keys ~= nil then\n\tredis.call('DEL', unpack(keys))\nend";
    public static final String REPLACE = "local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous";
    public static final String REPLACE_NEW = "local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal oldEntry = ARGV[2]\nlocal cacheEntry = ARGV[3]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= oldEntry then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous";
}

