/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.api.StatefulRedisConnection;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisCacheStorePoolConfig {
    private int maxTotal;
    private int minIdle;
    private int maxIdle;
    private Boolean blockWhenExhausted;
    private long maxWaitMillis = 0L;
    private Boolean testOnBorrow;
    private Boolean testOnReturn;
    private Boolean testWhileIdle;
    private long timeBetweenEvictionRunsMillis = 0L;
    private long minEvictableIdleTimeMillis = 0L;
    private int numTestsPerEvictionRun;

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public Boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public void setBlockWhenExhausted(Boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void apply(GenericObjectPoolConfig<StatefulRedisConnection<Object, Object>> poolConfig) {
        if (this.maxTotal > 0) {
            poolConfig.setMaxTotal(this.maxTotal);
        }
        if (this.maxIdle > 0) {
            poolConfig.setMaxIdle(this.maxIdle);
        }
        if (this.minIdle > 0) {
            poolConfig.setMinIdle(this.minIdle);
        }
        if (this.blockWhenExhausted != null) {
            poolConfig.setBlockWhenExhausted(this.blockWhenExhausted.booleanValue());
        }
        if (this.maxWaitMillis > 0L) {
            poolConfig.setMaxWait(Duration.ofMillis(this.maxWaitMillis));
        }
        if (this.testOnBorrow != null) {
            poolConfig.setTestOnBorrow(this.testOnBorrow.booleanValue());
        }
        if (this.testOnReturn != null) {
            poolConfig.setTestOnReturn(this.testOnReturn.booleanValue());
        }
        if (this.testWhileIdle != null) {
            poolConfig.setTestWhileIdle(this.testWhileIdle.booleanValue());
        }
        if (this.timeBetweenEvictionRunsMillis > 0L) {
            poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(this.timeBetweenEvictionRunsMillis));
        }
        if (this.minEvictableIdleTimeMillis > 0L) {
            poolConfig.setMinEvictableIdleTime(Duration.ofMillis(this.minEvictableIdleTimeMillis));
        }
        if (this.numTestsPerEvictionRun > 0) {
            poolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        }
    }
}

