/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.RedisNoScriptException;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.TimeToLiveCalculator;
import org.iplass.mtp.impl.redis.RedisRuntimeException;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreBase;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStorePoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheStore
extends RedisCacheStoreBase {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheStore.class);

    public RedisCacheStore(RedisCacheStoreFactory factory, String namespace, TimeToLiveCalculator timeToLiveCalculator, RedisCacheStorePoolConfig redisCacheStorePoolConfig) {
        super(factory, namespace, timeToLiveCalculator, redisCacheStorePoolConfig);
        this.pubSubConnection.addListener((RedisPubSubListener)new RedisPubSubListener<String, String>(){

            public void unsubscribed(String channel, long count) {
            }

            public void subscribed(String channel, long count) {
            }

            public void punsubscribed(String pattern, long count) {
            }

            public void psubscribed(String pattern, long count) {
            }

            public void message(String pattern, String channel, String message) {
            }

            public void message(String channel, String message) {
                String prefix = RedisCacheStore.this.codec.getPrefix();
                if (message.startsWith(prefix)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Occur expired event. channel:%s, message:%s", channel, message));
                    }
                    Object key = RedisCacheStore.this.codec.decodeKey(RedisCacheStore.this.codec.getCharset().encode(message));
                    RedisCacheStore.this.notifyRemoved(new CacheEntry(key, null, new Object[0]));
                }
            }
        });
        this.pubSubCommands = this.pubSubConnection.sync();
        this.pubSubCommands.subscribe((Object[])new String[]{"__keyevent@" + String.valueOf(factory.getServer().getDatabase()) + "__:expired"});
    }

    public CacheEntry get(Object key) {
        CacheEntry cacheEntry;
        block8: {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                RedisCommands commands = connection.sync();
                CacheEntry cacheEntry2 = cacheEntry = key != null ? (CacheEntry)commands.get(key) : null;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not get CacheEntry. key:" + String.valueOf(key), e);
                }
            }
            connection.close();
        }
        return cacheEntry;
    }

    public CacheEntry put(CacheEntry entry, boolean clean) {
        CacheEntry cacheEntry;
        block12: {
            this.setTtl(entry);
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                CacheEntry previous;
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous");
                try {
                    previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                catch (RedisNoScriptException e) {
                    previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                if (previous == null) {
                    this.notifyPut(entry);
                } else {
                    this.notifyUpdated(previous, entry);
                }
                cacheEntry = previous;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not put CacheEntry. entry:" + String.valueOf(entry), e);
                }
            }
            connection.close();
        }
        return cacheEntry;
    }

    public CacheEntry putIfAbsent(CacheEntry entry) {
        CacheEntry cacheEntry;
        block11: {
            this.setTtl(entry);
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                CacheEntry previous;
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous");
                try {
                    previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                catch (RedisNoScriptException e) {
                    previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                if (previous == null) {
                    this.notifyPut(entry);
                }
                cacheEntry = previous;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not putIfAbsent CacheEntry. entry:" + String.valueOf(entry), e);
                }
            }
            connection.close();
        }
        return cacheEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry compute(Object key, BiFunction<Object, CacheEntry, CacheEntry> remappingFunction) {
        int count = 0;
        while (count <= this.retryCount) {
            block28: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    TransactionResult result;
                    String sha;
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{key});
                    CacheEntry oldEntry = this.get(key);
                    CacheEntry newEntry = remappingFunction.apply(key, oldEntry);
                    if (newEntry == null) {
                        if (oldEntry == null) {
                            commands.unwatch();
                            sha = null;
                            return sha;
                        }
                        commands.multi();
                        sha = commands.digest("local cacheKey = KEYS[1]\nlocal cacheEntry = ARGV[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= cacheEntry then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous");
                        try {
                            commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{key}, new Object[]{oldEntry});
                        }
                        catch (RedisNoScriptException e) {
                            commands.eval("local cacheKey = KEYS[1]\nlocal cacheEntry = ARGV[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= cacheEntry then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous", ScriptOutputType.VALUE, new Object[]{key}, new Object[]{oldEntry});
                        }
                        result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyRemoved(oldEntry);
                            CacheEntry cacheEntry = null;
                            return cacheEntry;
                        }
                        break block28;
                    }
                    this.setTtl(newEntry);
                    if (oldEntry != null) {
                        commands.multi();
                        if (!oldEntry.getKey().equals(newEntry.getKey())) {
                            throw new IllegalArgumentException("oldEntry key not equals newEntry key");
                        }
                        sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal oldEntry = ARGV[2]\nlocal cacheEntry = ARGV[3]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= oldEntry then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous");
                        try {
                            commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{newEntry.getKey()}, new Object[]{this.getTtlSeconds(newEntry), oldEntry, newEntry});
                        }
                        catch (RedisNoScriptException e) {
                            commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal oldEntry = ARGV[2]\nlocal cacheEntry = ARGV[3]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= oldEntry then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{newEntry.getKey()}, new Object[]{this.getTtlSeconds(newEntry), oldEntry, newEntry});
                        }
                        result = commands.exec();
                        if (!result.wasDiscarded()) {
                            this.notifyUpdated(oldEntry, newEntry);
                            CacheEntry cacheEntry = newEntry;
                            return cacheEntry;
                        }
                        break block28;
                    }
                    commands.multi();
                    sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous");
                    try {
                        commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{key}, new Object[]{this.getTtlSeconds(newEntry), newEntry});
                    }
                    catch (RedisNoScriptException e) {
                        commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{key}, new Object[]{this.getTtlSeconds(newEntry), newEntry});
                    }
                    result = commands.exec();
                    if (!result.wasDiscarded()) {
                        this.notifyPut(newEntry);
                        CacheEntry cacheEntry = newEntry;
                        return cacheEntry;
                    }
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not compute CacheEntry. key:" + String.valueOf(key), e);
                }
            }
            ++count;
        }
        throw new SystemException("can not compute CacheEntry cause retry count over. key:" + String.valueOf(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheEntry computeIfAbsent(Object key, Function<Object, CacheEntry> mappingFunction) {
        int count = 0;
        while (count <= this.retryCount) {
            block15: {
                try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                    RedisCommands commands = connection.sync();
                    commands.watch(new Object[]{key});
                    CacheEntry oldEntry = this.get(key);
                    if (oldEntry != null) {
                        commands.unwatch();
                        CacheEntry cacheEntry = oldEntry;
                        return cacheEntry;
                    }
                    commands.multi();
                    CacheEntry newEntry = mappingFunction.apply(key);
                    if (newEntry == null) break block15;
                    this.setTtl(newEntry);
                    String sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous");
                    try {
                        commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{key}, new Object[]{this.getTtlSeconds(newEntry), newEntry});
                    }
                    catch (RedisNoScriptException e) {
                        commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\tif timeToLive > 0 then\n\t\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\n\telse\n\t\tredis.call('SET', cacheKey, cacheEntry)\n\tend\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{key}, new Object[]{this.getTtlSeconds(newEntry), newEntry});
                    }
                    TransactionResult result = commands.exec();
                    if (!result.wasDiscarded()) {
                        this.notifyPut(newEntry);
                        CacheEntry cacheEntry = newEntry;
                        return cacheEntry;
                    }
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not computeIfAbsent CacheEntry. key:" + String.valueOf(key), e);
                }
            }
            ++count;
        }
        throw new SystemException("can not computeIfAbsent CacheEntry cause retry count over. key:" + String.valueOf(key));
    }

    public CacheEntry remove(Object key) {
        CacheEntry cacheEntry;
        block11: {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                CacheEntry previous;
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local cacheKey = KEYS[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous");
                try {
                    previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{key});
                }
                catch (RedisNoScriptException e) {
                    previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous", ScriptOutputType.VALUE, new Object[]{key});
                }
                if (previous != null) {
                    this.notifyRemoved(previous);
                }
                cacheEntry = previous;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not remove CacheEntry. key:" + String.valueOf(key), e);
                }
            }
            connection.close();
        }
        return cacheEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(CacheEntry entry) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            CacheEntry previous;
            RedisCommands commands = connection.sync();
            String sha = commands.digest("local cacheKey = KEYS[1]\nlocal cacheEntry = ARGV[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= cacheEntry then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous");
            try {
                previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{entry});
            }
            catch (RedisNoScriptException e) {
                previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal cacheEntry = ARGV[1]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= cacheEntry then\n\treturn nil\nelse\n\tredis.call('DEL', cacheKey)end\nreturn previous", ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{entry});
            }
            if (previous != null) {
                this.notifyRemoved(previous);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new RedisRuntimeException("can not remove CacheEntry. entry:" + String.valueOf(entry), e);
        }
    }

    public CacheEntry replace(CacheEntry entry) {
        CacheEntry cacheEntry;
        block11: {
            this.setTtl(entry);
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                CacheEntry previous;
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous");
                try {
                    previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                catch (RedisNoScriptException e) {
                    previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal cacheEntry = ARGV[2]\nlocal previous = redis.call('GET', cacheKey)\nif not previous then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{entry.getKey()}, new Object[]{this.getTtlSeconds(entry), entry});
                }
                if (previous != null) {
                    this.notifyUpdated(previous, entry);
                }
                cacheEntry = previous;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not replace CacheEntry. entry:" + String.valueOf(entry), e);
                }
            }
            connection.close();
        }
        return cacheEntry;
    }

    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        boolean bl;
        block12: {
            if (!oldEntry.getKey().equals(newEntry.getKey())) {
                throw new IllegalArgumentException("oldEntry key not equals newEntry key");
            }
            this.setTtl(newEntry);
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                CacheEntry previous;
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal oldEntry = ARGV[2]\nlocal cacheEntry = ARGV[3]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= oldEntry then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous");
                try {
                    previous = (CacheEntry)commands.evalsha(sha, ScriptOutputType.VALUE, new Object[]{newEntry.getKey()}, new Object[]{this.getTtlSeconds(newEntry), oldEntry, newEntry});
                }
                catch (RedisNoScriptException e) {
                    previous = (CacheEntry)commands.eval("local cacheKey = KEYS[1]\nlocal timeToLive = tonumber(ARGV[1])\nlocal oldEntry = ARGV[2]\nlocal cacheEntry = ARGV[3]\nlocal previous = redis.call('GET', cacheKey)\nif not previous or previous ~= oldEntry then\n\treturn nil\nend\nif timeToLive > 0 then\n\tredis.call('SETEX', cacheKey, timeToLive, cacheEntry)\nelse\n\tredis.call('SET', cacheKey, cacheEntry)\nend\nreturn previous", ScriptOutputType.VALUE, new Object[]{newEntry.getKey()}, new Object[]{this.getTtlSeconds(newEntry), oldEntry, newEntry});
                }
                if (previous != null) {
                    this.notifyUpdated(oldEntry, newEntry);
                }
                boolean bl2 = bl = previous != null;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not replace CacheEntry. entry:" + String.valueOf(newEntry), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public List<Object> keySet() {
        List list;
        block8: {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();
            try {
                List keys;
                RedisCommands commands = connection.sync();
                list = keys = commands.keys((Object)"*");
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RedisRuntimeException("can not get cache keySet", e);
                }
            }
            connection.close();
        }
        return list;
    }

    public void removeAll() {
        if (this.hasListener()) {
            this.keySet().forEach(key -> this.remove(key));
        } else {
            try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
                RedisCommands commands = connection.sync();
                String sha = commands.digest("local key = KEYS[1]\nlocal keys = redis.call('KEYS', key)\nif keys ~= nil then\n\tredis.call('DEL', unpack(keys))\nend");
                try {
                    commands.evalsha(sha, ScriptOutputType.MULTI, new Object[]{"*"});
                }
                catch (RedisNoScriptException e) {
                    commands.eval("local key = KEYS[1]\nlocal keys = redis.call('KEYS', key)\nif keys ~= nil then\n\tredis.call('DEL', unpack(keys))\nend", ScriptOutputType.MULTI, new Object[]{"*"});
                }
            }
            catch (Exception e) {
                throw new RedisRuntimeException("can not remove all CacheEntry", e);
            }
        }
    }

    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        return null;
    }
}

