/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.codec.RedisCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import org.iplass.mtp.SystemException;

public class NamespaceSerializedObjectCodec
implements RedisCodec<Object, Object> {
    private final Charset charset = Charset.forName("UTF-8");
    private final String prefix;

    public NamespaceSerializedObjectCodec(String namespace) {
        this.prefix = namespace + ":";
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Object decodeKey(ByteBuffer bytes) {
        try {
            String strKey = this.removePrefix(this.charset.decode(bytes).toString());
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(strKey)));
            return is.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Object decodeValue(ByteBuffer bytes) {
        try {
            byte[] array = new byte[bytes.remaining()];
            bytes.get(array);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(array));
            return is.readObject();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public ByteBuffer encodeKey(Object key) {
        if (key.equals("*")) {
            return ByteBuffer.wrap(this.addPrefix("*").getBytes());
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bytes);
            os.writeObject(key);
            String strKey = Base64.getEncoder().encodeToString(bytes.toByteArray());
            return this.charset.encode(this.addPrefix(strKey));
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public ByteBuffer encodeValue(Object value) {
        if (value instanceof Long) {
            return ByteBuffer.wrap(String.valueOf(value).getBytes());
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bytes);
            os.writeObject(value);
            return ByteBuffer.wrap(bytes.toByteArray());
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    private String addPrefix(String key) {
        return key == null ? null : this.prefix + key;
    }

    private String removePrefix(String key) {
        if (key != null && key.startsWith(this.prefix)) {
            key = key.substring(this.prefix.length());
        }
        return key;
    }
}

