/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.crypt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.iplass.mtp.impl.core.config.PropertyValueCoder;
import org.iplass.mtp.impl.core.config.ServiceRegistryInitializer;

public class Encoder {
    private static Properties getProperties() throws IOException {
        String fileName = ServiceRegistryInitializer.getCryptoConfigFileName();
        if (fileName != null) {
            Properties prop = new Properties();
            Path path = Paths.get(fileName, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                System.out.println("load CryptConfigFile from file path:" + fileName);
                try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), "utf-8");){
                    prop.load(is);
                }
            }
            System.out.println("load CryptConfigFile from classpath:" + fileName);
            try (InputStream is = PropertyValueCoder.class.getResourceAsStream(fileName);){
                if (is == null) {
                    System.err.println("CryptConfigFile:" + fileName + " not found.");
                }
                InputStreamReader isr = new InputStreamReader(is, "utf-8");
                prop.load(isr);
            }
            return prop;
        }
        return System.getProperties();
    }

    public static void main(String[] args) throws Exception {
        Properties prop = Encoder.getProperties();
        String keyAlg = prop.getProperty("keyFactoryAlgorithm", "PBKDF2WithHmacSHA256");
        int keyLength = 128;
        if (prop.getProperty("keyLength") != null) {
            keyLength = Integer.parseInt(prop.getProperty("keyLength"));
        }
        String cipherAlg = prop.getProperty("cipherAlgorithm", "AES");
        byte[] keySalt = null;
        if (prop.getProperty("keySalt") != null) {
            keySalt = prop.getProperty("keySalt").getBytes("utf-8");
        }
        int keyStretch = 2048;
        if (prop.getProperty("keyStretch") != null) {
            keyStretch = Integer.parseInt(prop.getProperty("keyStretch"));
        }
        PropertyValueCoder coder = new PropertyValueCoder(keyAlg, keyLength, cipherAlg, keySalt, keyStretch, () -> {
            System.out.println("enter passphrase:");
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            try {
                String passphrase1 = console.readLine();
                System.out.println("enter same passphrase again:");
                String passphrase2 = console.readLine();
                if (!passphrase1.equals(passphrase2)) {
                    throw new RuntimeException("passphrase unmatch");
                }
                return passphrase1.toCharArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        do {
            String plain;
            if (args.length > 0) {
                if (args[0].equals("-file")) {
                    String filePath;
                    if (args.length > 1) {
                        filePath = args[1];
                    } else {
                        System.out.println("enter file path of plain text:");
                        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                        filePath = console.readLine();
                    }
                    plain = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), "utf-8");
                } else {
                    plain = args[0];
                }
            } else {
                System.out.println("enter plain text:");
                BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                plain = console.readLine();
            }
            if (plain.equals("")) {
                return;
            }
            System.out.println("encrypted text:");
            System.out.println(coder.encode(plain));
            System.out.println();
        } while (args.length <= 1 || !args[0].equals("-file"));
    }
}

