/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch;

import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.rdb.oracle.OracleRdbAdapter;
import org.iplass.mtp.impl.rdb.postgresql.PostgreSQLRdbAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.SqlServerRdbAdapter;

public class ConfigSetting {
    private final String configFileName;
    private final RdbAdapter adapter;
    private final String conenctUrl;

    public ConfigSetting(String configFileName, RdbAdapter adapter, String conenctUrl) {
        this.configFileName = configFileName;
        this.adapter = adapter;
        this.conenctUrl = conenctUrl;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getRdbAdapterName() {
        return this.adapter != null ? this.adapter.getClass().getSimpleName() : "";
    }

    public String getConenctUrl() {
        return this.conenctUrl;
    }

    public boolean isOracle() {
        return this.adapter != null && this.adapter instanceof OracleRdbAdapter;
    }

    public boolean isMySQL() {
        return this.adapter != null && this.adapter instanceof MysqlRdbAdaptor;
    }

    public boolean isPostgreSQL() {
        return this.adapter != null && this.adapter instanceof PostgreSQLRdbAdapter;
    }

    public boolean isSQLServer() {
        return this.adapter != null && this.adapter instanceof SqlServerRdbAdapter;
    }
}

