/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Function;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportResult;
import org.iplass.mtp.impl.tools.pack.PackageInfo;
import org.iplass.mtp.impl.tools.pack.PackageRuntimeException;
import org.iplass.mtp.impl.tools.pack.PackageService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.pack.PackageExport;
import org.iplass.mtp.tools.batch.pack.PackageImportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;

public class PackageImport
extends MtpCuiBase {
    public static final String KEY_CONFIG_FILE = "pack.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String importFile;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private PackageService ps = (PackageService)ServiceRegistry.getRegistry().getService(PackageService.class);

    public static void main(String[] args) {
        PackageImport instance = null;
        try {
            instance = new PackageImport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public PackageImport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && args[2] != null && !"empty".equals(args[2].toLowerCase())) {
                this.importFile = args[2];
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PackageImport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public PackageImport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public PackageImport importFile(String importFile) {
        this.importFile = importFile;
        return this;
    }

    public boolean importPack(final PackageImportParameter param) {
        this.setSuccess(false);
        try {
            boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){
                String oid = null;

                @Override
                public Boolean apply(Transaction t) {
                    ArrayList messageSummary = new ArrayList();
                    boolean ret = (Boolean)Transaction.requiresNew(tt -> {
                        TenantContext tc = PackageImport.this.tcs.getTenantContext(param.getTenantId());
                        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
                            ExecuteContext.getCurrentContext().setLanguage(PackageImport.this.getLanguage());
                            String logMessage = null;
                            this.oid = PackageImport.this.ps.uploadPackage(param.getPackageName(), null, param.getImportFile(), "30");
                            logMessage = PackageImport.this.rs("PackageImport.createdPackageInfoLog", new Object[]{this.oid});
                            PackageImport.this.logInfo(logMessage);
                            PackageImport.this.logInfo("");
                            messageSummary.add(logMessage);
                            if (CollectionUtil.isNotEmpty((Collection)param.getPackInfo().getMetaDataPaths())) {
                                PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportMetaLog", new Object[0]));
                                MetaDataImportResult metaResult = PackageImport.this.ps.importPackageMetaData(this.oid, param.getImportTenant());
                                if (metaResult.isError()) {
                                    if (metaResult.getMessages() != null) {
                                        for (String message : metaResult.getMessages()) {
                                            PackageImport.this.logError(message);
                                        }
                                        PackageImport.this.logInfo("");
                                    }
                                    PackageImport.this.logError(PackageImport.this.rs("Common.errorMsg", new Object[]{""}));
                                    return false;
                                }
                                if (metaResult.getMessages() != null) {
                                    for (String message : metaResult.getMessages()) {
                                        PackageImport.this.logInfo(message);
                                        messageSummary.add(message);
                                    }
                                    PackageImport.this.logInfo("");
                                }
                                logMessage = PackageImport.this.rs("PackageImport.completedImportMetaLog", new Object[0]);
                                PackageImport.this.logInfo(logMessage);
                                PackageImport.this.logInfo("");
                                messageSummary.add(logMessage);
                            } else {
                                logMessage = PackageImport.this.rs("PackageImport.notIncludeMetaLog", new Object[0]);
                                PackageImport.this.logInfo(logMessage);
                                PackageImport.this.logInfo("");
                                messageSummary.add(logMessage);
                            }
                            return true;
                        });
                    });
                    if (!ret) {
                        return false;
                    }
                    ret = (Boolean)Transaction.requiresNew(tt -> {
                        TenantContext reloadTc = PackageImport.this.tcs.getTenantContext(param.getTenantId());
                        return (Boolean)ExecuteContext.executeAs((TenantContext)reloadTc, () -> {
                            ExecuteContext.getCurrentContext().setLanguage(PackageImport.this.getLanguage());
                            String logMessage = null;
                            if (CollectionUtil.isNotEmpty((Collection)param.getPackInfo().getEntityPaths())) {
                                PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportEntityLog", new Object[0]));
                                for (String path : param.getPackInfo().getEntityPaths()) {
                                    String entityPath = "/entity/" + path.substring(0, path.length() - 4).replace(".", "/");
                                    PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportEntityDataLog", new Object[]{entityPath}));
                                    EntityDataImportResult entityResult = PackageImport.this.ps.importPackageEntityData(this.oid, entityPath, param.getEntityImportCondition());
                                    if (entityResult.isError()) {
                                        if (entityResult.getMessages() != null) {
                                            for (String message : entityResult.getMessages()) {
                                                PackageImport.this.logError(message);
                                            }
                                            PackageImport.this.logInfo("");
                                        }
                                        logMessage = PackageImport.this.rs("PackageImport.errorImportEntityDataLog", new Object[]{entityPath});
                                        PackageImport.this.logError(logMessage);
                                        messageSummary.add("[ERROR]" + logMessage);
                                        if (!param.getEntityImportCondition().isErrorSkip()) {
                                            PackageImport.this.logError(PackageImport.this.rs("Common.errorMsg", new Object[]{""}));
                                            return false;
                                        }
                                        PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.continueLog", new Object[0]));
                                        continue;
                                    }
                                    if (entityResult.getMessages() != null) {
                                        for (String message : entityResult.getMessages()) {
                                            PackageImport.this.logInfo(message);
                                        }
                                        PackageImport.this.logInfo("");
                                    }
                                    logMessage = PackageImport.this.rs("PackageImport.completedImportEntityDataLog", new Object[]{entityPath, entityResult.getInsertCount(), entityResult.getUpdateCount(), entityResult.getErrorCount()});
                                    PackageImport.this.logInfo(logMessage);
                                    PackageImport.this.logInfo("");
                                    messageSummary.add(logMessage);
                                }
                                logMessage = PackageImport.this.rs("PackageImport.completedImportEntityLog", new Object[0]);
                                PackageImport.this.logInfo(logMessage);
                                PackageImport.this.logInfo("");
                                messageSummary.add(logMessage);
                            } else {
                                logMessage = PackageImport.this.rs("PackageImport.notIncludeEntityLog", new Object[0]);
                                PackageImport.this.logInfo(logMessage);
                                PackageImport.this.logInfo("");
                                messageSummary.add(logMessage);
                            }
                            return true;
                        });
                    });
                    PackageImport.this.logInfo("-----------------------------------------------------------");
                    PackageImport.this.logInfo("\u25a0Execute Result Summary");
                    for (String message : messageSummary) {
                        PackageImport.this.logInfo(message);
                    }
                    PackageImport.this.logInfo("-----------------------------------------------------------");
                    PackageImport.this.logInfo("");
                    PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.completedImportPackageLog", new Object[]{param.getImportFilePath()}));
                    return true;
                }
            });
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            this.logError(this.rs("Common.errorMsg", e.getMessage()));
        }
        return this.isSuccess();
    }

    public void logArguments(PackageImportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\timport file :" + param.getImportFilePath());
        this.logInfo("\timport file locale :" + param.getLocale());
        this.logInfo("\timport file timezone :" + param.getTimezone());
        PackageInfo packInfo = param.getPackInfo();
        if (CollectionUtil.isNotEmpty((Collection)packInfo.getMetaDataPaths())) {
            this.logInfo("\tmetadata count :" + packInfo.getMetaDataPaths().size());
        } else {
            this.logInfo("\tmetadata count :0");
        }
        if (CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths())) {
            this.logInfo("\tentity count :" + packInfo.getEntityPaths().size());
            EntityDataImportCondition condition = param.getEntityImportCondition();
            this.logInfo("\tentity data truncate :" + condition.isTruncate());
            this.logInfo("\tentity data force update :" + condition.isFourceUpdate());
            this.logInfo("\tentity data error skip :" + condition.isErrorSkip());
            this.logInfo("\tentity ignore not exists property :" + condition.isIgnoreNotExistsProperty());
            this.logInfo("\tentity execute listner :" + condition.isNotifyListeners());
            this.logInfo("\tentity update disupdatable property :" + condition.isUpdateDisupdatableProperty());
            this.logInfo("\tentity execute validation :" + condition.isWithValidation());
            this.logInfo("\tentity commit limit :" + condition.getCommitLimit());
            this.logInfo("\tentity oid prefix :" + condition.getPrefixOid());
        } else {
            this.logInfo("\tentity count :0");
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private void showMetaDataPathList(PackageInfo packInfo) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0MetaData List");
        for (String path : packInfo.getMetaDataPaths()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    private void showEntityDataPathList(PackageInfo packInfo) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0EntityData List");
        for (String path : packInfo.getEntityPaths()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wizard() {
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                this.tenantId = null;
                return this.wizard();
            }
        } else {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            String url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            tenant = this.ts.getTenant(url);
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        PackageImportParameter param = new PackageImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            PackageInfo packInfo = null;
            boolean validFile = false;
            do {
                String importFileName = this.importFile;
                this.importFile = null;
                if (StringUtil.isEmpty((String)importFileName)) {
                    importFileName = this.readConsole(this.rs("PackageImport.Wizard.inputImportFileMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)importFileName)) {
                    param.setImportFilePath(importFileName);
                    File file = new File(param.getImportFilePath());
                    if (!file.exists()) {
                        this.logWarn(this.rs("PackageImport.notExistsImportFileMsg", new Object[0]));
                        continue;
                    }
                    try {
                        int entityCount;
                        int metaCount;
                        packInfo = this.ps.getPackageInfo(file);
                        int n = metaCount = CollectionUtil.isNotEmpty((Collection)packInfo.getMetaDataPaths()) ? packInfo.getMetaDataPaths().size() : 0;
                        if (metaCount == 0) {
                            this.logInfo(this.rs("PackageImport.Wizard.notIncludeMetaMsg", new Object[0]));
                        } else {
                            if (packInfo.isWarningTenant()) {
                                this.logWarn(this.rs("PackageImport.includeWarnTenantMetaMsg", new Object[0]));
                            } else {
                                param.setImportTenant(packInfo.getTenant());
                            }
                            boolean isShow = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmShowMetaListMsg", metaCount), false);
                            if (isShow) {
                                this.showMetaDataPathList(packInfo);
                            }
                        }
                        boolean isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true);
                        if (!isContinue) continue;
                        int n2 = entityCount = CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths()) ? packInfo.getEntityPaths().size() : 0;
                        if (entityCount == 0) {
                            this.logInfo(this.rs("PackageImport.Wizard.notIncludeEntityMsg", new Object[0]));
                        } else {
                            boolean isShow = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmShowEntityListMsg", entityCount), false);
                            if (isShow) {
                                this.showEntityDataPathList(packInfo);
                            }
                        }
                        isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true);
                        if (!isContinue) continue;
                        param.setImportFile(file);
                        param.setPackInfo(packInfo);
                        validFile = true;
                    }
                    catch (PackageRuntimeException e) {
                        this.logWarn(this.rs("PackageImport.errorAnalysisFileMsg", e.getMessage()));
                    }
                    continue;
                }
                this.logWarn(this.rs("PackageImport.Wizard.requiredImportFilePathMsg", new Object[0]));
            } while (!validFile);
            if (CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths())) {
                String timezone;
                EntityDataImportCondition condition = new EntityDataImportCondition();
                boolean isTruncate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmTrancateDataMsg", new Object[0]), condition.isTruncate());
                condition.setTruncate(isTruncate);
                boolean isForceUpdate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmForceUpdateMsg", new Object[0]), condition.isFourceUpdate());
                condition.setFourceUpdate(isForceUpdate);
                boolean isErrorSkip = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmSkipErrorDataMsg", new Object[0]), condition.isErrorSkip());
                condition.setErrorSkip(isErrorSkip);
                boolean isIgnoreNotExistsProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmIgnoreNotExistsPropertyMsg", new Object[0]), condition.isIgnoreNotExistsProperty());
                condition.setIgnoreNotExistsProperty(isIgnoreNotExistsProperty);
                boolean isNotifyListner = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmNotifyListenerMsg", new Object[0]), condition.isNotifyListeners());
                condition.setNotifyListeners(isNotifyListner);
                boolean isUpdateDisupdatableProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmUpdateDisupdatablePropertyMsg", new Object[0]), condition.isUpdateDisupdatableProperty());
                condition.setUpdateDisupdatableProperty(isUpdateDisupdatableProperty);
                if (isUpdateDisupdatableProperty) {
                    condition.setWithValidation(false);
                } else {
                    boolean isWithValidation = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmWithValidationMsg", new Object[0]), condition.isWithValidation());
                    condition.setWithValidation(isWithValidation);
                }
                int commitLimit = this.readConsoleInteger(this.rs("PackageImport.Wizard.inputCommitUnitMsg", new Object[0]), 100);
                condition.setCommitLimit(Integer.valueOf(commitLimit));
                boolean validOidPrefix = false;
                do {
                    String oidPrefix;
                    if (StringUtil.isEmpty((String)(oidPrefix = this.readConsole(this.rs("PackageImport.Wizard.inputOIDPrefixMsg", new Object[0]) + "(" + condition.getPrefixOid() + ")")))) {
                        validOidPrefix = true;
                        continue;
                    }
                    if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                        condition.setPrefixOid(oidPrefix);
                        validOidPrefix = true;
                        continue;
                    }
                    this.logWarn(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
                } while (!validOidPrefix);
                String locale = this.readConsole(this.rs("PackageImport.Wizard.inputLocaleMsg", new Object[0]) + "(" + (condition.getLocale() != null ? condition.getLocale() : "") + ")");
                if (StringUtil.isNotBlank((String)locale)) {
                    condition.setLocale(locale);
                }
                if (StringUtil.isNotBlank((String)(timezone = this.readConsole(this.rs("PackageImport.Wizard.inputTimezoneMsg", new Object[0]) + "(" + (condition.getTimezone() != null ? condition.getTimezone() : "") + ")")))) {
                    condition.setTimezone(timezone);
                }
                param.setEntityImportCondition(condition);
            } else {
                param.setEntityImportCondition(null);
            }
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmImportPackageMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            return null;
        });
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.removeLogListner(consoleLogListner);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
        try {
            this.importPack(param);
            boolean bl = this.isSuccess();
            return bl;
        }
        finally {
            this.removeLogListner(loggingListner);
            this.addLogListner(consoleLogListner);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean silent() {
        Properties prop;
        block64: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                this.logError(this.rs("PackageImport.Silent.requiredConfigFileMsg", KEY_CONFIG_FILE));
                return false;
            }
            prop = new Properties();
            try {
                Throwable throwable;
                InputStream is;
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    is = new FileInputStream(path.toFile());
                    throwable = null;
                    try (InputStreamReader reader2 = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader2);
                        break block64;
                    }
                    catch (Throwable reader2) {
                        throwable = reader2;
                        throw reader2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable reader2) {
                                    throwable.addSuppressed(reader2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                is = PackageExport.class.getResourceAsStream(configFileName);
                throwable = null;
                try {
                    if (is == null) {
                        this.logError(this.rs("PackageImport.Silent.notExistsConfigFileMsg", configFileName));
                        boolean reader2 = false;
                        return reader2;
                    }
                    try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
        } else {
            String propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", propTenantId));
                return false;
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!propTenantUrl.startsWith("/")) {
                    propTenantUrl = "/" + propTenantUrl;
                }
                if ((tenant = this.ts.getTenant(propTenantUrl)) == null) {
                    this.logError(this.rs("Common.notExistsTenantUrlMsg", propTenantUrl));
                    return false;
                }
            }
            if (tenant == null) {
                this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
                return false;
            }
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        PackageImportParameter param = new PackageImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            String importFilePath = this.importFile;
            if (StringUtil.isEmpty((String)importFilePath)) {
                importFilePath = prop.getProperty("importFile");
            }
            if (StringUtil.isEmpty((String)importFilePath)) {
                this.logError(this.rs("Common.requiredMsg", "importFile"));
                return false;
            }
            File file = new File(importFilePath);
            if (!file.exists()) {
                this.logError(this.rs("PackageImport.notExistsImportFileMsg", new Object[0]));
                return false;
            }
            param.setImportFilePath(importFilePath);
            try {
                PackageInfo packInfo = this.ps.getPackageInfo(file);
                if (packInfo.isWarningTenant()) {
                    this.logWarn(this.rs("PackageImport.includeWarnTenantMetaMsg", new Object[0]));
                } else {
                    param.setImportTenant(packInfo.getTenant());
                }
                param.setImportFile(file);
                param.setPackInfo(packInfo);
            }
            catch (PackageRuntimeException e) {
                this.logError(this.rs("PackageImport.errorAnalysisFileMsg", e.getMessage()));
                return false;
            }
            if (CollectionUtil.isNotEmpty((Collection)param.getPackInfo().getEntityPaths())) {
                String oidPrefix;
                String updateDisupdatableProperty;
                String notifyListener;
                String ignoreInvalidProperty;
                String errorSkip;
                String forceUpdate;
                EntityDataImportCondition condition = new EntityDataImportCondition();
                String truncate = prop.getProperty("entity.truncate");
                if (StringUtil.isNotEmpty((String)truncate)) {
                    condition.setTruncate(Boolean.valueOf(truncate).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(forceUpdate = prop.getProperty("entity.forceUpdate")))) {
                    condition.setFourceUpdate(Boolean.valueOf(forceUpdate).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(errorSkip = prop.getProperty("entity.errorSkip")))) {
                    condition.setErrorSkip(Boolean.valueOf(errorSkip).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(ignoreInvalidProperty = prop.getProperty("entity.ignoreInvalidProperty")))) {
                    condition.setIgnoreNotExistsProperty(Boolean.valueOf(ignoreInvalidProperty).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(notifyListener = prop.getProperty("entity.notifyListener")))) {
                    condition.setNotifyListeners(Boolean.valueOf(notifyListener).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(updateDisupdatableProperty = prop.getProperty("entity.updateDisupdatableProperty")))) {
                    condition.setUpdateDisupdatableProperty(Boolean.valueOf(updateDisupdatableProperty).booleanValue());
                }
                if (condition.isUpdateDisupdatableProperty()) {
                    condition.setWithValidation(false);
                } else {
                    String withValidation = prop.getProperty("entity.withValidation");
                    if (StringUtil.isNotEmpty((String)withValidation)) {
                        condition.setWithValidation(Boolean.valueOf(withValidation).booleanValue());
                    }
                }
                String commitLimit = prop.getProperty("entity.commitLimit");
                if (StringUtil.isNotEmpty((String)commitLimit)) {
                    condition.setCommitLimit(Integer.valueOf(commitLimit));
                }
                if (StringUtil.isNotEmpty((String)(oidPrefix = prop.getProperty("entity.prefixOid")))) {
                    if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                        condition.setPrefixOid(oidPrefix);
                    } else {
                        this.logError(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
                        return false;
                    }
                }
                param.setEntityImportCondition(condition);
            }
            this.logArguments(param);
            return this.importPack(param);
        });
    }
}

