/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.tenant;

import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.TenantDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.gui.tenant.TenantManagerApp;
import org.iplass.mtp.util.StringUtil;

public class TenantBatch
extends MtpCuiBase {
    private TenantBatchExecMode execMode = TenantBatchExecMode.GUI;
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);

    public static void main(String[] args) {
        TenantBatch instance = null;
        try {
            instance = new TenantBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public TenantBatch(String ... args) {
        if (args != null && args.length > 0 && args[0] != null) {
            this.setExecMode(TenantBatchExecMode.valueOf(args[0].toUpperCase()));
        }
    }

    public boolean execute() {
        this.clearLog();
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.addLogListner(consoleLogListner);
        this.logEnvironment();
        switch (this.getExecMode()) {
            case GUI: {
                this.logInfo("\u25a0Start App");
                this.logInfo("");
                this.removeLogListner(consoleLogListner);
                TenantManagerApp.main(new String[]{this.getLanguage()});
                return true;
            }
            case CREATE: {
                this.logInfo("\u25a0Start Create Wizard");
                this.logInfo("");
                return this.startCreateWizard();
            }
            case DELETE: {
                this.logInfo("\u25a0Start Delete Wizard");
                this.logInfo("");
                return this.startDeleteWizard();
            }
            case SHOW: {
                this.showAllTenantList();
                this.logInfo("");
                return true;
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.getExecMode()));
        return false;
    }

    public TenantBatchExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(TenantBatchExecMode execMode) {
        this.execMode = execMode;
    }

    public boolean executeCreate(TenantCreateParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        try {
            boolean isSuccess = this.toolService.create(param, (LogHandler)new TenantBatchLogListener());
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            try {
                this.logError(this.rs("Common.errorMsg", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    public void logArguments(TenantCreateParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant url :" + param.getTenantUrl());
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\ttenant display name :" + param.getTenantDisplayName());
        this.logInfo("\tadmin accunt id :" + param.getAdminUserId());
        this.logInfo("\ttopUrl :" + param.getTopUrl());
        this.logInfo("\tuseLanguages :" + param.getUseLanguages());
        this.logInfo("\tcreateBlankTenant :" + param.isCreateBlankTenant());
        if (this.getConfigSetting().isMySQL()) {
            this.logInfo("\tmysql use subpartition :" + param.isMySqlUseSubPartition());
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean startCreateWizard() {
        String tenantName = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantNameMsg", new Object[0]));
        if (StringUtil.isEmpty((String)tenantName)) {
            this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredTenantNameMsg", new Object[0]));
            return this.startCreateWizard();
        }
        if (tenantName.equalsIgnoreCase("-show")) {
            this.showAllTenantList();
            return this.startCreateWizard();
        }
        if (tenantName.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startCreateWizard();
        }
        String tenantUrl = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantUrlMsg", new Object[0]) + "(/" + tenantName + ")");
        if (StringUtil.isEmpty((String)tenantUrl)) {
            tenantUrl = "/" + tenantName;
        }
        if (this.toolService.existsURL(tenantUrl)) {
            this.logWarn(this.rs("TenantBatch.Create.Wizard.existsTenantMsg", tenantUrl));
            return this.startCreateWizard();
        }
        String adminUserId = null;
        do {
            if (!StringUtil.isEmpty((String)(adminUserId = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputAdminIdMsg", new Object[0]))))) continue;
            this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminIdMsg", new Object[0]));
            adminUserId = null;
        } while (adminUserId == null);
        String adminPW = null;
        boolean invalidateAdminPW = true;
        while (true) {
            if (StringUtil.isEmpty((String)(adminPW = this.readConsolePassword(this.rs("TenantBatch.Create.Wizard.inputAdminPWMsg", new Object[0]))))) {
                this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminPWMsg", new Object[0]));
                adminPW = null;
            }
            if (adminPW == null) continue;
            String confirmAdminPW = null;
            do {
                if (!StringUtil.isEmpty((String)(confirmAdminPW = this.readConsolePassword(this.rs("TenantBatch.Create.Wizard.inputReTypeAdminPWMsg", new Object[0]))))) continue;
                this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminPWMsg", new Object[0]));
                confirmAdminPW = null;
            } while (confirmAdminPW == null);
            if (!adminPW.equals(confirmAdminPW)) {
                this.logWarn(this.rs("TenantBatch.Create.Wizard.unmatchAdminPWMsg", new Object[0]));
                adminPW = null;
                confirmAdminPW = null;
            } else {
                invalidateAdminPW = false;
            }
            if (!invalidateAdminPW) break;
        }
        TenantCreateParameter param = new TenantCreateParameter(tenantName, adminUserId, adminPW);
        param.setTenantUrl(tenantUrl);
        param.setUseLanguages(this.getLanguage());
        boolean isDefault = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.confirmDefaultMsg", new Object[0]), false);
        if (!isDefault) {
            String lang;
            String topURL;
            String tenantDisplayName = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantDispNameMsg", new Object[0]) + "(" + param.getTenantDisplayName() + ")");
            if (StringUtil.isNotBlank((String)tenantDisplayName)) {
                param.setTenantDisplayName(tenantDisplayName);
            }
            if (StringUtil.isNotBlank((String)(topURL = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTopUrlMsg", new Object[0]) + "(" + param.getTopUrl() + ")")))) {
                param.setTopUrl(topURL);
            }
            if (StringUtil.isNotBlank((String)(lang = this.readConsole(this.rs("TenantBatch.Create.Wizard.useMultiLangMsg", new Object[0]))))) {
                param.setUseLanguages(lang);
            }
            boolean isBlank = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.createBlankTenantMsg", new Object[0]), false);
            param.setCreateBlankTenant(isBlank);
            if (this.getConfigSetting().isMySQL()) {
                boolean isSubPartition = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.useSubPartitionMsg", new Object[0]), false);
                param.setMySqlUseSubPartition(isSubPartition);
            }
        }
        this.logArguments(param);
        boolean isExecute = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.confirmCreateTenantMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startCreateWizard();
        }
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.removeLogListner(consoleLogListner);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
        boolean ret = this.executeCreate(param);
        this.removeLogListner(loggingListner);
        return ret;
    }

    public boolean executeDelete(TenantDeleteParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        try {
            boolean isSuccess = this.toolService.remove(param, (LogHandler)new TenantBatchLogListener());
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            try {
                this.logError(this.rs("Common.errorMsg", e.getMessage()));
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    public void logArguments(TenantDeleteParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\ttenant id :" + param.getTenantId());
        if (this.getConfigSetting().isMySQL()) {
            this.logInfo("\tmysql drop partition :" + param.isMySqlDropPartition());
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean startDeleteWizard() {
        String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
        if (StringUtil.isEmpty((String)tenantUrl) || tenantUrl.equalsIgnoreCase("-show")) {
            this.showAllTenantList();
            return this.startDeleteWizard();
        }
        if (tenantUrl.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startDeleteWizard();
        }
        TenantInfo tenant = this.toolService.getTenantInfo(tenantUrl);
        if (tenant == null) {
            this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
            return this.startDeleteWizard();
        }
        TenantDeleteParameter param = new TenantDeleteParameter();
        param.setTenantId(tenant.getId());
        param.setTenantName(tenant.getName());
        if (this.getConfigSetting().isMySQL()) {
            boolean isPartitionDelete = this.readConsoleBoolean(this.rs("TenantBatch.Delete.Wizard.confirmDropPartitionMsg", new Object[0]), true);
            param.setMySqlDropPartition(isPartitionDelete);
        }
        this.logArguments(param);
        boolean isExecute = this.readConsoleBoolean(this.rs("TenantBatch.Delete.Wizard.confirmRemoveTenantMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startDeleteWizard();
        }
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.removeLogListner(consoleLogListner);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
        boolean ret = this.executeDelete(param);
        this.removeLogListner(loggingListner);
        return ret;
    }

    private class TenantBatchLogListener
    implements LogHandler {
        private TenantBatchLogListener() {
        }

        public void info(String message) {
            TenantBatch.this.logInfo(message);
        }

        public void info(String message, Throwable e) {
            TenantBatch.this.logInfo(message, e);
        }

        public void warn(String message) {
            TenantBatch.this.logWarn(message);
        }

        public void warn(String message, Throwable e) {
            TenantBatch.this.logWarn(message, e);
        }

        public void error(String message) {
            TenantBatch.this.logError(message);
        }

        public void error(String message, Throwable e) {
            TenantBatch.this.logError(message, e);
        }
    }

    public static enum TenantBatchExecMode {
        GUI,
        CREATE,
        DELETE,
        SHOW;

    }
}

