/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.tenant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.tenant.TenantBatch;
import org.iplass.mtp.tools.gui.MtpJDialogBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCreateDialog
extends MtpJDialogBase {
    private static final long serialVersionUID = -8293278349056121678L;
    private static Logger logger = LoggerFactory.getLogger(TenantCreateDialog.class);
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);
    private I18nService i18nService = (I18nService)ServiceRegistry.getRegistry().getService(I18nService.class);
    private String defaultEnableLanguages = "";
    protected JTextField txtName;
    protected JTextField txtUrl;
    protected JCheckBox chkUrl;
    protected JTextField txtDisplayName;
    protected JCheckBox chkDisplayName;
    protected JTextField txtAdminUserId;
    protected JPasswordField txtAdminUserPass;
    protected JPasswordField txtConfirmAdminUserPass;
    protected JTextField txtTopUrl;
    protected JCheckBox chkTopUrl;
    protected JTextField txtUseLanguages;
    protected JCheckBox chkUseLanguages;
    protected JCheckBox chkBlankTenant;
    protected JCheckBox chkMySQLSubPartition;
    protected JButton btnCreate;
    protected JButton btnCancel;
    protected JTextArea txtMessageArea;
    protected List<ChangeListener> dataChangeListners = new ArrayList<ChangeListener>();

    public TenantCreateDialog(Frame owner) {
        super(owner);
        if (this.i18nService.getEnableLanguagesMap() != null) {
            for (String languageKey : this.i18nService.getEnableLanguagesMap().keySet()) {
                this.defaultEnableLanguages = this.defaultEnableLanguages + languageKey + ",";
            }
            if (this.defaultEnableLanguages.length() > 1) {
                this.defaultEnableLanguages = this.defaultEnableLanguages.substring(0, this.defaultEnableLanguages.length() - 1);
            }
        }
        this.createDialog();
    }

    public void addTenantDataChangeListner(ChangeListener listner) {
        this.dataChangeListners.add(listner);
    }

    protected void createDialog() {
        this.setTitle("Create Tenant");
        this.setBounds(64, 64, 300, 530);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        JPanel mainPane = new JPanel();
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.createInfoPane(), "North");
        mainPane.add((Component)this.createInputPane(), "Center");
        mainPane.add((Component)this.createFooterPane(), "South");
        this.getContentPane().add((Component)mainPane, "North");
        this.getContentPane().add((Component)this.createMessagePane(), "Center");
        this.pack();
        this.setDefaultValues();
    }

    private JPanel createInfoPane() {
        JPanel infoPane = new JPanel();
        infoPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        infoPane.setLayout(new BorderLayout(5, 5));
        JPanel messagePane = new JPanel();
        messagePane.setLayout(new BoxLayout(messagePane, 1));
        JLabel lblInfo1 = new JLabel(this.rs("TenantManagerApp.TenantCreateDialog.createTenantLabel", new Object[0]));
        messagePane.add(lblInfo1);
        RdbAdapterService adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
        RdbAdapter adapter = adapterService.getRdbAdapter();
        if (adapter instanceof MysqlRdbAdaptor) {
            JLabel lblInfo2 = new JLabel(this.rs("TenantManagerApp.TenantCreateDialog.warnAlterTablePermissionLabel", new Object[0]));
            lblInfo2.setForeground(Color.RED);
            messagePane.add(lblInfo2);
        }
        JLabel lblDummy = new JLabel();
        messagePane.add(lblDummy);
        infoPane.add((Component)new JLabel(UIManager.getIcon("OptionPane.informationIcon")), "West");
        infoPane.add((Component)messagePane, "Center");
        return infoPane;
    }

    protected JPanel createInputPane() {
        JPanel inputPane = new JPanel();
        inputPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        inputPane.setLayout(gridbag);
        constraints.gridx = 1;
        constraints.gridheight = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 3;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 5;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        int rowIndex = 0;
        JLabel lblName = new JLabel("*name");
        this.txtName = new JTextField();
        this.txtName.setPreferredSize(new Dimension(200, 25));
        this.createLableText(lblName, this.txtName, null, rowIndex++, gridbag, constraints, inputPane);
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                TenantCreateDialog.this.setDefaultValues();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        JLabel lblAdminUserId = new JLabel("*Admin User Id");
        this.txtAdminUserId = new JTextField();
        this.txtAdminUserId.setPreferredSize(new Dimension(200, 25));
        this.createLableText(lblAdminUserId, this.txtAdminUserId, null, rowIndex++, gridbag, constraints, inputPane);
        JLabel lblAdminUserPass = new JLabel("*Admin User Password");
        this.txtAdminUserPass = new JPasswordField();
        this.txtAdminUserPass.setPreferredSize(new Dimension(200, 25));
        this.createLableText(lblAdminUserPass, this.txtAdminUserPass, null, rowIndex++, gridbag, constraints, inputPane);
        JLabel lblConfirmAdminUserPass = new JLabel("*Confirm Password");
        this.txtConfirmAdminUserPass = new JPasswordField();
        this.txtConfirmAdminUserPass.setPreferredSize(new Dimension(200, 25));
        this.createLableText(lblConfirmAdminUserPass, this.txtConfirmAdminUserPass, null, rowIndex++, gridbag, constraints, inputPane);
        JLabel lblUrl = new JLabel("*url");
        this.txtUrl = new JTextField();
        this.txtUrl.setPreferredSize(new Dimension(200, 25));
        this.txtUrl.setEditable(false);
        this.chkUrl = new JCheckBox("default");
        this.chkUrl.setSelected(true);
        this.createLableText(lblUrl, this.txtUrl, this.chkUrl, rowIndex++, gridbag, constraints, inputPane);
        this.chkUrl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TenantCreateDialog.this.chkUrl.isSelected()) {
                    TenantCreateDialog.this.txtUrl.setEditable(false);
                    TenantCreateDialog.this.setDefaultValues();
                } else {
                    TenantCreateDialog.this.txtUrl.setEditable(true);
                }
            }
        });
        JLabel lblDisplayName = new JLabel("*displayName");
        this.txtDisplayName = new JTextField();
        this.txtDisplayName.setPreferredSize(new Dimension(200, 25));
        this.txtDisplayName.setEditable(false);
        this.chkDisplayName = new JCheckBox("default");
        this.chkDisplayName.setSelected(true);
        this.createLableText(lblDisplayName, this.txtDisplayName, this.chkDisplayName, rowIndex++, gridbag, constraints, inputPane);
        this.chkDisplayName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TenantCreateDialog.this.chkDisplayName.isSelected()) {
                    TenantCreateDialog.this.txtDisplayName.setEditable(false);
                    TenantCreateDialog.this.setDefaultValues();
                } else {
                    TenantCreateDialog.this.txtDisplayName.setEditable(true);
                }
            }
        });
        JLabel lblTopUrl = new JLabel("TopUrl");
        this.txtTopUrl = new JTextField();
        this.txtTopUrl.setPreferredSize(new Dimension(200, 25));
        this.txtTopUrl.setEditable(false);
        this.chkTopUrl = new JCheckBox("default");
        this.chkTopUrl.setSelected(true);
        this.createLableText(lblTopUrl, this.txtTopUrl, this.chkTopUrl, rowIndex++, gridbag, constraints, inputPane);
        this.chkTopUrl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TenantCreateDialog.this.chkTopUrl.isSelected()) {
                    TenantCreateDialog.this.txtTopUrl.setEditable(false);
                    TenantCreateDialog.this.setDefaultValues();
                } else {
                    TenantCreateDialog.this.txtTopUrl.setEditable(true);
                }
            }
        });
        JLabel lblUseLanguages = new JLabel("UseLanguages");
        this.txtUseLanguages = new JTextField();
        this.txtUseLanguages.setPreferredSize(new Dimension(200, 25));
        this.txtUseLanguages.setEditable(false);
        this.chkUseLanguages = new JCheckBox("default");
        this.chkUseLanguages.setSelected(true);
        this.createLableText(lblUseLanguages, this.txtUseLanguages, this.chkUseLanguages, rowIndex++, gridbag, constraints, inputPane);
        this.chkUseLanguages.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TenantCreateDialog.this.chkUseLanguages.isSelected()) {
                    TenantCreateDialog.this.txtUseLanguages.setEditable(false);
                    TenantCreateDialog.this.setDefaultValues();
                } else {
                    TenantCreateDialog.this.txtUseLanguages.setEditable(true);
                    TenantCreateDialog.this.txtUseLanguages.setText(TenantCreateDialog.this.defaultEnableLanguages);
                }
            }
        });
        this.chkBlankTenant = new JCheckBox("create blank Tenant");
        this.chkBlankTenant.setSelected(false);
        this.createCheckBoxRow(this.chkBlankTenant, rowIndex++, gridbag, constraints, inputPane);
        RdbAdapterService adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
        RdbAdapter adapter = adapterService.getRdbAdapter();
        if (adapter instanceof MysqlRdbAdaptor) {
            this.chkMySQLSubPartition = new JCheckBox("MySQL SubPartition Use");
            this.chkMySQLSubPartition.setSelected(true);
            this.createCheckBoxRow(this.chkMySQLSubPartition, rowIndex++, gridbag, constraints, inputPane);
        }
        return inputPane;
    }

    protected void createLableText(JComponent label, JComponent text, JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        gridbag.setConstraints(label, constraints);
        pane.add(label);
        constraints.gridx = 2;
        constraints.gridheight = 1;
        gridbag.setConstraints(text, constraints);
        pane.add(text);
        if (check != null) {
            constraints.gridx = 4;
            constraints.gridheight = 1;
            gridbag.setConstraints(check, constraints);
            pane.add(check);
        }
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    protected void createCheckBoxRow(JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        gridbag.setConstraints(check, constraints);
        pane.add(check);
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    protected JPanel createFooterPane() {
        JPanel footerPane = new JPanel();
        footerPane.setLayout(new FlowLayout(1));
        this.btnCreate = new JButton("Create");
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TenantCreateDialog.this.inputValidate()) {
                    return;
                }
                if (!TenantCreateDialog.this.dataValidate()) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(TenantCreateDialog.this, TenantCreateDialog.this.rs("TenantManagerApp.TenantCreateDialog.confirmCreateTenantMsg", new Object[0]), "CONFIRM", 0, 3) != 0) {
                    return;
                }
                TenantCreateDialog.this.createTenant();
            }
        });
        footerPane.add(this.btnCreate);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setDefaultCapable(true);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TenantCreateDialog.this.setVisible(false);
                TenantCreateDialog.this.dispose();
            }
        });
        footerPane.add(this.btnCancel);
        return footerPane;
    }

    protected JTabbedPane createMessagePane() {
        JTabbedPane tabMessagePane = new JTabbedPane(1);
        tabMessagePane.setTabLayoutPolicy(1);
        JScrollPane sclMessagePane = new JScrollPane();
        this.txtMessageArea = new JTextArea();
        this.txtMessageArea.setEditable(false);
        this.txtMessageArea.setFont(new Font(this.rs("TenantManagerApp.TenantCreateDialog.messageFont", new Object[0]), 0, 10));
        this.txtMessageArea.setRows(10);
        sclMessagePane.setViewportView(this.txtMessageArea);
        tabMessagePane.addTab("Log", sclMessagePane);
        return tabMessagePane;
    }

    protected void setDefaultValues() {
        if (this.chkUrl.isSelected()) {
            this.txtUrl.setText("/" + this.txtName.getText());
        }
        if (this.chkDisplayName.isSelected()) {
            this.txtDisplayName.setText(this.txtName.getText());
        }
        if (this.chkTopUrl.isSelected()) {
            this.txtTopUrl.setText("/gem/");
        }
        if (this.chkUseLanguages.isSelected()) {
            this.txtUseLanguages.setText(this.getLanguage());
        }
    }

    protected boolean inputValidate() {
        StringBuilder messages = new StringBuilder();
        if (this.txtName.getText().trim().isEmpty()) {
            messages.append(this.rs("Common.requiredMsg", "name") + "\n");
        }
        if (this.txtAdminUserId.getText().trim().isEmpty()) {
            messages.append(this.rs("Common.requiredMsg", "AdminUserId") + "\n");
        }
        if (this.txtAdminUserPass.getPassword().length == 0) {
            messages.append(this.rs("Common.requiredMsg", "AdminUserPassword") + "\n");
        }
        if (this.txtConfirmAdminUserPass.getPassword().length == 0) {
            messages.append(this.rs("TenantManagerApp.TenantCreateDialog.unmatchAdminPWMsg", new Object[0]) + "\n");
        } else {
            String confirmPW;
            String checkPW = new String(this.txtAdminUserPass.getPassword());
            if (!checkPW.equals(confirmPW = new String(this.txtConfirmAdminUserPass.getPassword()))) {
                messages.append(this.rs("TenantManagerApp.TenantCreateDialog.unmatchAdminPWMsg", new Object[0]) + "\n");
            }
        }
        if (this.txtUrl.getText().trim().isEmpty()) {
            messages.append(this.rs("Common.requiredMsg", "url") + "\n");
        }
        if (this.txtDisplayName.getText().trim().isEmpty()) {
            messages.append(this.rs("Common.requiredMsg", "displayName") + "\n");
        }
        if (messages.length() > 0) {
            JOptionPane.showMessageDialog(this, messages.toString(), "WARN", 2);
            return false;
        }
        return true;
    }

    protected boolean dataValidate() {
        String tenantUrl = this.txtUrl.getText().trim();
        if (this.toolService.existsURL(tenantUrl)) {
            JOptionPane.showMessageDialog(this, this.rs("TenantManagerApp.TenantCreateDialog.existsTenantMsg", new Object[0]), "WARN", 2);
            return false;
        }
        return true;
    }

    protected void createTenant() {
        this.btnCreate.setText("create...");
        this.btnCreate.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.txtMessageArea.setText("");
        CreateTenantWorker worker = new CreateTenantWorker();
        worker.execute();
    }

    private TenantCreateParameter createParameter() {
        String name = this.txtName.getText().trim();
        String adminId = this.txtAdminUserId.getText().trim();
        String adminPW = new String(this.txtAdminUserPass.getPassword());
        TenantCreateParameter param = new TenantCreateParameter(name, adminId, adminPW);
        if (StringUtil.isNotEmpty((String)this.txtUrl.getText().trim())) {
            param.setTenantUrl(this.txtUrl.getText().trim());
        }
        if (StringUtil.isNotEmpty((String)this.txtDisplayName.getText().trim())) {
            param.setTenantDisplayName(this.txtDisplayName.getText().trim());
        }
        if (StringUtil.isNotEmpty((String)this.txtTopUrl.getText().trim())) {
            param.setTopUrl(this.txtTopUrl.getText().trim());
        }
        if (StringUtil.isNotEmpty((String)this.txtUseLanguages.getText().trim())) {
            param.setUseLanguages(this.txtUseLanguages.getText().trim());
        }
        param.setCreateBlankTenant(this.chkBlankTenant.isSelected());
        if (this.chkMySQLSubPartition != null) {
            param.setMySqlUseSubPartition(this.chkMySQLSubPartition.isSelected());
        }
        return param;
    }

    protected void addLog(String log) {
        this.txtMessageArea.append(log + "\n");
    }

    protected void fireTenantDataChanged() {
        ChangeEvent e = new ChangeEvent(this.txtName.getText().trim());
        for (ChangeListener listner : this.dataChangeListners) {
            listner.stateChanged(e);
        }
    }

    private class CreateTenantWorker
    extends SwingWorker<TenantBatch, String> {
        private CreateTenantWorker() {
        }

        @Override
        protected TenantBatch doInBackground() throws Exception {
            TenantBatch manager = null;
            try {
                manager = new TenantBatch(TenantBatch.TenantBatchExecMode.CREATE.name());
                manager.addLogListner(new MtpCuiBase.LogListner(){

                    @Override
                    public void info(String message) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.info(message);
                    }

                    @Override
                    public void warn(String message) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.warn(message);
                    }

                    @Override
                    public void error(String message) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.error(message);
                    }

                    @Override
                    public void info(String message, Throwable e) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.info(message, e);
                    }

                    @Override
                    public void warn(String message, Throwable e) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.warn(message, e);
                    }

                    @Override
                    public void error(String message, Throwable e) {
                        CreateTenantWorker.this.publish(new String[]{message});
                        logger.error(message, e);
                    }
                });
                manager.executeCreate(TenantCreateDialog.this.createParameter());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            return manager;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String message : chunks) {
                TenantCreateDialog.this.addLog(message);
            }
        }

        @Override
        protected void done() {
            try {
                TenantBatch manager = (TenantBatch)this.get();
                if (manager.isSuccess()) {
                    JOptionPane.showMessageDialog(TenantCreateDialog.this, TenantCreateDialog.this.rs("TenantManagerApp.TenantCreateDialog.createCompleteMsg", new Object[0]), "INFO", 1);
                    TenantCreateDialog.this.fireTenantDataChanged();
                } else {
                    JOptionPane.showMessageDialog(TenantCreateDialog.this, TenantCreateDialog.this.rs("Common.errorMsg", new Object[]{""}), "ERROR", 0);
                }
            }
            catch (Exception e) {
                TenantCreateDialog.this.addLog(TenantCreateDialog.this.rs("Common.errorMsg", new Object[]{""}));
                TenantCreateDialog.this.addLog(e.getMessage());
                JOptionPane.showMessageDialog(TenantCreateDialog.this, TenantCreateDialog.this.rs("Common.errorMsg", new Object[]{""}), "ERROR", 0);
            }
            TenantCreateDialog.this.btnCreate.setText("Create");
            TenantCreateDialog.this.btnCreate.setEnabled(true);
            TenantCreateDialog.this.btnCancel.setEnabled(true);
        }
    }
}

