/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.widget.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.core.config.ServiceRegistryInitializer;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.DriverManagerConnectionFactory;
import org.iplass.mtp.spi.ServiceRegistry;

public class DBConfigMenu
extends JMenu {
    private static final long serialVersionUID = 493704852361376167L;

    public DBConfigMenu(final Frame owner) {
        super("Config");
        JMenuItem item = new JMenuItem("DB Config Settings");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigSettingDialog dialog = new ConfigSettingDialog(owner);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        });
        this.add(item);
    }

    public static class ConfigSettingDialog
    extends JDialog {
        private static final long serialVersionUID = 8378724754491492214L;
        private JTextField txtConfigFileName;
        private JTextField txtRdbAdapter;
        private JTextField txtConenctUrl;
        private JTextField txtConenctUser;
        private JTextField txtConenctDriver;
        private ConfigSetting initConfig;
        private RdbAdapterService adapterService;
        private DriverManagerConnectionFactory dmFactory;

        public ConfigSettingDialog(Frame owner) {
            super(owner);
            this.setTitle("Config Settings");
            this.setBounds(64, 64, 300, 530);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(null);
            JPanel headerPane = new JPanel();
            headerPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            headerPane.setLayout(gridbag);
            constraints.gridx = 1;
            constraints.gridheight = 0;
            Box dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            constraints.gridx = 3;
            constraints.gridheight = 0;
            dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            constraints.gridx = 5;
            constraints.gridwidth = 0;
            constraints.gridheight = 0;
            dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            JLabel lblConfigFileName = new JLabel("Service Config File");
            this.txtConfigFileName = new JTextField();
            this.txtConfigFileName.setPreferredSize(new Dimension(300, 25));
            this.txtConfigFileName.setEditable(false);
            this.createLableText(lblConfigFileName, this.txtConfigFileName, null, 0, gridbag, constraints, headerPane);
            JLabel lblRdbAdapter = new JLabel("Rdb Adapter");
            this.txtRdbAdapter = new JTextField();
            this.txtRdbAdapter.setPreferredSize(new Dimension(300, 25));
            this.txtRdbAdapter.setEditable(false);
            this.createLableText(lblRdbAdapter, this.txtRdbAdapter, null, 1, gridbag, constraints, headerPane);
            JLabel lblConenctUrl = new JLabel("Conenct Url");
            this.txtConenctUrl = new JTextField();
            this.txtConenctUrl.setPreferredSize(new Dimension(300, 25));
            this.txtConenctUrl.setEditable(false);
            this.createLableText(lblConenctUrl, this.txtConenctUrl, null, 2, gridbag, constraints, headerPane);
            JLabel lblConenctUser = new JLabel("Conenct User");
            this.txtConenctUser = new JTextField();
            this.txtConenctUser.setPreferredSize(new Dimension(300, 25));
            this.txtConenctUser.setEditable(false);
            this.createLableText(lblConenctUser, this.txtConenctUser, null, 3, gridbag, constraints, headerPane);
            JLabel lblConenctDriver = new JLabel("Conenct Driver");
            this.txtConenctDriver = new JTextField();
            this.txtConenctDriver.setPreferredSize(new Dimension(300, 25));
            this.txtConenctDriver.setEditable(false);
            this.createLableText(lblConenctDriver, this.txtConenctDriver, null, 5, gridbag, constraints, headerPane);
            JPanel mainPane = new JPanel();
            mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            mainPane.setLayout(new BorderLayout());
            mainPane.add((Component)headerPane, "Center");
            mainPane.add((Component)this.createFooterPane(), "South");
            this.getContentPane().add((Component)mainPane, "North");
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    super.windowActivated(e);
                    try {
                        this.searchConfig();
                    }
                    catch (Throwable err) {
                        JOptionPane.showMessageDialog(this, err.toString(), "\u30a8\u30e9\u30fc", 2);
                    }
                }
            });
        }

        private void createLableText(JComponent label, JComponent text, JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
            constraints.gridx = 0;
            constraints.gridy = row * 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            gridbag.setConstraints(label, constraints);
            pane.add(label);
            constraints.gridx = 2;
            constraints.gridheight = 1;
            gridbag.setConstraints(text, constraints);
            pane.add(text);
            if (check != null) {
                constraints.gridx = 4;
                constraints.gridheight = 1;
                gridbag.setConstraints(check, constraints);
                pane.add(check);
            }
            constraints.gridx = 0;
            constraints.gridy = row * 2 + 1;
            constraints.gridwidth = 0;
            Box dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            pane.add(dummy);
        }

        private JPanel createFooterPane() {
            JPanel footerPane = new JPanel();
            footerPane.setLayout(new FlowLayout(1));
            JButton btnCancel = new JButton("Cancel");
            btnCancel.setDefaultCapable(true);
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
            footerPane.add(btnCancel);
            return footerPane;
        }

        private void searchConfig() throws Exception {
            this.initConfig = new ConfigSetting();
            this.initConfig.configFileName = ServiceRegistryInitializer.getConfigFileName();
            this.txtConfigFileName.setText(this.initConfig.configFileName);
            RdbAdapter adapter = this.getRdbAdapter();
            this.initConfig.rdbAdapterName = adapter.getClass().getSimpleName();
            ConnectionFactory factory = (ConnectionFactory)ServiceRegistry.getRegistry().getService(ConnectionFactory.class);
            if (factory instanceof DriverManagerConnectionFactory) {
                this.dmFactory = (DriverManagerConnectionFactory)factory;
                this.initConfig.conenctUrl = this.getUrl();
                Properties properties = this.getInfo();
                this.initConfig.conenctUser = properties.keySet().contains("user") ? properties.getProperty("user") : "not found";
                this.initConfig.conenctDriver = properties.keySet().contains("driver") ? properties.getProperty("driver") : "not found";
            } else {
                throw new ApplicationException("unsupport ConnectionFactory class : " + factory.getClass().getName());
            }
            this.setConfigSetting(this.initConfig);
        }

        private void setConfigSetting(ConfigSetting config) {
            this.txtRdbAdapter.setText(this.initConfig.rdbAdapterName);
            this.txtConenctUrl.setText(this.initConfig.conenctUrl);
            this.txtConenctUser.setText(this.initConfig.conenctUser);
            this.txtConenctDriver.setText(this.initConfig.conenctDriver);
        }

        private RdbAdapter getRdbAdapter() {
            this.adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
            return this.adapterService.getRdbAdapter();
        }

        private String getUrl() throws Exception {
            Field urlField = this.dmFactory.getClass().getDeclaredField("url");
            urlField.setAccessible(true);
            return (String)urlField.get(this.dmFactory);
        }

        private Properties getInfo() throws Exception {
            Field infoField = this.dmFactory.getClass().getDeclaredField("info");
            infoField.setAccessible(true);
            return (Properties)infoField.get(this.dmFactory);
        }

        private static class ConfigSetting {
            String configFileName;
            String rdbAdapterName;
            String conenctUrl;
            String conenctUser;
            String conenctDriver;

            private ConfigSetting() {
            }
        }
    }
}

