/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.cleaner;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.tools.clean.RecycleBinCleanService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;

public class RbCleaner
extends MtpCuiBase {
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityService entityHandlerService = (EntityService)ServiceRegistry.getRegistry().getService(EntityService.class);
    private RecycleBinCleanService recycleBinCleanService = (RecycleBinCleanService)ServiceRegistry.getRegistry().getService(RecycleBinCleanService.class);
    private int tenantId;

    public static void main(String[] args) throws Exception {
        int tenantId = -1;
        Calendar cal = Calendar.getInstance();
        cal.add(5, -entityHandlerService.getPurgeTargetDate());
        Timestamp purgeTargetDate = new Timestamp(cal.getTimeInMillis());
        if (args != null && args.length > 0 && StringUtil.isNotEmpty((String)args[0])) {
            tenantId = Integer.parseInt(args[0]);
        }
        if (tenantId >= 0) {
            new RbCleaner(tenantId).clean(purgeTargetDate);
        } else {
            List<TenantInfo> tenants = RbCleaner.getValidTenantInfoList();
            if (tenants != null) {
                for (TenantInfo t : tenants) {
                    new RbCleaner(t.getId()).clean(purgeTargetDate);
                }
            }
        }
    }

    public RbCleaner(int tenantId) {
        this.setTenantId(tenantId);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
    }

    public boolean clean(Timestamp purgeTargetDate) throws Exception {
        this.setSuccess(false);
        this.clearLog();
        try {
            ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tenantContextService.getTenantContext(this.tenantId)));
            this.logArguments();
            this.recycleBinCleanService.clean(purgeTargetDate, null);
            this.setSuccess(true);
        }
        catch (Throwable e) {
            try {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.getTenantId());
        this.logInfo("");
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }
}

