/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.OutputStream;
import java.util.Scanner;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;

public class EQLExecutor
extends MtpCuiBase {
    private static final String SET_EQL_EXEC_MODE = "EQL_EXEC_MODE=";
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityToolService entityToolService = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private int tenantId = -1;
    private String eql;
    private boolean isSearchAllVersion = false;
    private ExecMode execMode = ExecMode.BATCH;
    private EQLExecMode eqlExecMode = EQLExecMode.ONLY_EXEC;
    private String userId;
    private String password;

    public EQLExecutor(String ... args) {
        if (args == null || args.length < 2) {
            return;
        }
        if (args.length > 0) {
            this.eql = args[0];
        }
        if (args.length > 1) {
            this.tenantId = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            this.isSearchAllVersion = Boolean.parseBoolean(args[2]);
        }
        if (args.length > 3) {
            this.execMode = ExecMode.valueOf(args[3]);
        }
        if (args.length > 4) {
            this.eqlExecMode = EQLExecMode.valueOf(args[4]);
        }
        if (args.length > 5) {
            this.userId = args[5];
        }
        if (args.length > 6) {
            this.password = args[6];
        }
    }

    public static void main(String ... args) {
        try {
            new EQLExecutor(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean execute() {
        this.clearLog();
        this.addLogListner(this.getLoggingLogListner());
        this.logEnvironment();
        return this.proceed();
    }

    /*
     * Exception decompiling
     */
    private boolean proceed() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void proceedBatch(String eql) {
        int count = -1;
        switch (this.eqlExecMode) {
            case ONLY_EXEC: {
                if (StringUtil.isBlank((String)this.userId)) {
                    entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, false);
                    break;
                }
                entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, false, this.userId, this.password);
                break;
            }
            case ONLY_COUNT: {
                if (StringUtil.isBlank((String)this.userId)) {
                    count = entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, true);
                    break;
                }
                count = entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, true, this.userId, this.password);
                break;
            }
            case SHOW_SEARCH_RESULT: {
                CloseShieldOutputStream out = new CloseShieldOutputStream((OutputStream)System.out);
                count = StringUtil.isBlank((String)this.userId) ? entityToolService.executeEQLWithAuth((OutputStream)out, System.getProperty("file.encoding"), eql, this.isSearchAllVersion) : entityToolService.executeEQLWithAuth((OutputStream)out, System.getProperty("file.encoding"), eql, this.isSearchAllVersion, this.userId, this.password);
            }
        }
        if (count < 0) {
            System.out.println("\nexecuted.");
        } else {
            String format = count > 1 ? "\n%d rows selected." : "\n%d row selected.";
            System.out.println(String.format(format, count));
        }
    }

    private void proceedInteract() {
        try (Scanner sc = new Scanner(System.in);){
            boolean isMultiLine = false;
            StringBuilder sb = new StringBuilder();
            while (true) {
                System.out.print(isMultiLine ? "  -> " : "EQL> ");
                String cmd = sc.nextLine().trim();
                if (StringUtil.isBlank((String)cmd)) continue;
                if (!isMultiLine) {
                    if ("exit".equals(cmd.toLowerCase()) || "quit".equals(cmd.toLowerCase())) {
                        System.out.println("Bye");
                        break;
                    }
                    if (cmd.startsWith(SET_EQL_EXEC_MODE)) {
                        if (cmd.length() > SET_EQL_EXEC_MODE.length()) {
                            String mode = cmd.substring(SET_EQL_EXEC_MODE.length());
                            try {
                                this.eqlExecMode = EQLExecMode.valueOf(mode);
                            }
                            catch (Exception e) {
                                StringBuilder sbMode = new StringBuilder();
                                for (EQLExecMode eqlExecMode : EQLExecMode.values()) {
                                    if (sbMode.length() > 0) {
                                        sbMode.append("|");
                                    }
                                    sbMode.append(eqlExecMode.toString());
                                }
                                System.out.println("Usage: EQL_EXEC_MODE=[" + sbMode.toString() + "]");
                            }
                            continue;
                        }
                        System.out.println(this.eqlExecMode.toString());
                        continue;
                    }
                }
                if (cmd.endsWith(";")) {
                    sb.append(cmd.substring(0, cmd.length() - 1));
                    if (sb.length() > 0) {
                        try {
                            this.proceedBatch(sb.toString());
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                        sb.setLength(0);
                    } else {
                        System.out.println("No query specified");
                    }
                    isMultiLine = false;
                    continue;
                }
                sb.append(cmd).append(' ');
                isMultiLine = true;
            }
        }
    }

    private static enum EQLExecMode {
        ONLY_EXEC,
        ONLY_COUNT,
        SHOW_SEARCH_RESULT;

    }

    private static enum ExecMode {
        BATCH,
        INTERACT;

    }
}

