/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.widget.menu;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeelMenu
extends JMenu {
    private static final long serialVersionUID = 2636738214546769106L;
    private static Logger logger = LoggerFactory.getLogger(LookAndFeelMenu.class);

    public LookAndFeelMenu(Frame owner) {
        super("LookAndFeel");
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        if (infos != null && infos.length > 0) {
            ButtonGroup group = new ButtonGroup();
            for (final UIManager.LookAndFeelInfo info : infos) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(info.getName());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        logger.debug("set LookAndFeel :" + info.getName());
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                            for (Window window : Frame.getWindows()) {
                                SwingUtilities.updateComponentTreeUI(window);
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                group.add(item);
                this.add(item);
                if (!UIManager.getSystemLookAndFeelClassName().equals(info.getClassName())) continue;
                item.setSelected(true);
            }
        }
    }
}

