/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.tenant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.rdb.postgresql.PostgreSQLRdbAdapter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.gui.MtpJFrameBase;
import org.iplass.mtp.tools.gui.partition.MySQLPartitionManagerApp;
import org.iplass.mtp.tools.gui.partition.PostgreSQLPartitionManagerApp;
import org.iplass.mtp.tools.gui.tenant.TenantCreateDialog;
import org.iplass.mtp.tools.gui.tenant.TenantDeleteDialog;
import org.iplass.mtp.tools.gui.widget.menu.BasicMenuBar;

public class TenantManagerApp
extends MtpJFrameBase {
    private static final long serialVersionUID = -8414236309660247814L;
    private TenantToolService tenantToolService;
    private JButton btnRefresh;
    private TenantTableModel model;
    private JTextField txtCount;
    private List<TenantTableColumnInfo> COLUMNS = new ArrayList<TenantTableColumnInfo>();
    private String[] COLUMN_NAMES;
    private static final int CHECKED_COL_NUM = 0;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TenantManagerApp frame = new TenantManagerApp();
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public TenantManagerApp() {
        this.setTitle("Tenant Manager");
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)new BasicMenuBar(this), "North");
        JPanel mainPane = new JPanel();
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.setLayout(new BorderLayout(0, 0));
        mainPane.setPreferredSize(new Dimension(830, 600));
        this.getContentPane().add((Component)mainPane, "Center");
        mainPane.add((Component)this.createHeaderPane(), "North");
        mainPane.add((Component)this.createTenantList(), "Center");
        this.pack();
        this.tenantToolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowActivated(e);
                TenantManagerApp.this.searchTenantList();
            }
        });
    }

    private JPanel createHeaderPane() {
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BorderLayout());
        JPanel headerMainPane = new JPanel();
        headerMainPane.setLayout(new FlowLayout(0));
        JButton btnAdd = new JButton("Create Default Tenant");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TenantCreateDialog dialog = new TenantCreateDialog(TenantManagerApp.this);
                dialog.setModal(true);
                dialog.addTenantDataChangeListner(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        TenantManagerApp.this.searchTenantList();
                    }
                });
                dialog.setVisible(true);
            }
        });
        headerMainPane.add(btnAdd);
        JButton btnDelete = new JButton("Remove Tenant");
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<TenantInfo> selected = TenantManagerApp.this.model.getSelectedTenantInfo();
                if (selected.size() == 0) {
                    JOptionPane.showMessageDialog(TenantManagerApp.this, TenantManagerApp.this.rs("TenantManagerApp.requiredSelectTenantMsg", new Object[0]), "WARN", 2);
                    return;
                }
                TenantDeleteDialog dialog = new TenantDeleteDialog(TenantManagerApp.this);
                dialog.setTenantInfo(selected);
                dialog.setModal(true);
                dialog.addTenantDataChangeListner(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        TenantManagerApp.this.searchTenantList();
                    }
                });
                dialog.setVisible(true);
            }
        });
        headerMainPane.add(btnDelete);
        RdbAdapterService adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
        final RdbAdapter adapter = adapterService.getRdbAdapter();
        if (adapter instanceof MysqlRdbAdaptor || adapter instanceof PostgreSQLRdbAdapter) {
            JButton btnPartitionList = new JButton("Partition List");
            btnPartitionList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (adapter instanceof MysqlRdbAdaptor) {
                        MySQLPartitionManagerApp.main(new String[0]);
                    } else if (adapter instanceof PostgreSQLRdbAdapter) {
                        PostgreSQLPartitionManagerApp.main(new String[0]);
                    }
                    TenantManagerApp.this.dispose();
                }
            });
            headerMainPane.add(btnPartitionList);
        }
        JPanel headerSubPane = new JPanel();
        headerSubPane.setLayout(new FlowLayout(0));
        this.btnRefresh = new JButton("Refresh List");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TenantManagerApp.this.searchTenantList();
            }
        });
        JLabel lblCount = new JLabel("Count");
        lblCount.setHorizontalAlignment(4);
        this.txtCount = new JTextField();
        this.txtCount.setPreferredSize(new Dimension(30, 25));
        this.txtCount.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.txtCount.setHorizontalAlignment(4);
        this.txtCount.setEditable(false);
        headerSubPane.add(this.btnRefresh);
        headerSubPane.add(lblCount);
        headerSubPane.add(this.txtCount);
        headerPane.add((Component)headerMainPane, "Center");
        headerPane.add((Component)headerSubPane, "East");
        return headerPane;
    }

    private JScrollPane createTenantList() {
        JScrollPane scrlTenantList = new JScrollPane();
        this.initColumnInfo();
        this.model = new TenantTableModel();
        JTable tblTenantList = new JTable(this.model);
        tblTenantList.setAutoCreateRowSorter(true);
        tblTenantList.setAutoResizeMode(0);
        int i = 0;
        for (TenantTableColumnInfo columnInfo : this.COLUMNS) {
            tblTenantList.getColumnModel().getColumn(i++).setPreferredWidth(columnInfo.getColSize());
        }
        scrlTenantList.setViewportView(tblTenantList);
        return scrlTenantList;
    }

    private void initColumnInfo() {
        this.COLUMNS.add(new TenantTableColumnInfo("*", 40));
        this.COLUMNS.add(new TenantTableColumnInfo("id", 60));
        this.COLUMNS.add(new TenantTableColumnInfo("name", 150));
        this.COLUMNS.add(new TenantTableColumnInfo("url", 150));
        this.COLUMNS.add(new TenantTableColumnInfo("yukoDateFrom", 100));
        this.COLUMNS.add(new TenantTableColumnInfo("yukoDateTo", 100));
        this.COLUMNS.add(new TenantTableColumnInfo("createDate", 100));
        this.COLUMNS.add(new TenantTableColumnInfo("updateDate", 100));
        this.COLUMN_NAMES = new String[this.COLUMNS.size()];
        int i = 0;
        for (TenantTableColumnInfo columnInfo : this.COLUMNS) {
            this.COLUMN_NAMES[i++] = columnInfo.getName();
        }
    }

    private void searchTenantList() {
        this.model.setTenantData(Collections.emptyList());
        this.model.fireTableDataChanged();
        this.btnRefresh.setText("search...");
        this.txtCount.setText("");
        this.btnRefresh.setEnabled(false);
        SearchTenantWorker worker = new SearchTenantWorker();
        worker.execute();
    }

    private class SearchTenantWorker
    extends SwingWorker<List<TenantInfo>, Object> {
        private SearchTenantWorker() {
        }

        @Override
        protected List<TenantInfo> doInBackground() throws Exception {
            return TenantManagerApp.this.tenantToolService.getAllTenantInfoList();
        }

        @Override
        protected void done() {
            try {
                List result = (List)this.get();
                TenantManagerApp.this.model.setTenantData(result);
                TenantManagerApp.this.model.fireTableDataChanged();
                TenantManagerApp.this.txtCount.setText(String.valueOf(result.size()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(TenantManagerApp.this, TenantManagerApp.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(TenantManagerApp.this, TenantManagerApp.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
            }
            TenantManagerApp.this.btnRefresh.setText("Refresh List");
            TenantManagerApp.this.btnRefresh.setEnabled(true);
        }
    }

    private class TenantTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 3473483302496226680L;
        private List<TenantInfo> data;
        private List<Boolean> isSelects;

        public TenantTableModel() {
            super(TenantManagerApp.this.COLUMN_NAMES, 0);
        }

        public void setTenantData(List<TenantInfo> data) {
            this.data = data;
            if (data == null) {
                this.isSelects = null;
            } else {
                this.isSelects = new ArrayList<Boolean>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    this.isSelects.add(Boolean.FALSE);
                }
            }
        }

        public TenantInfo getTenantInfo(int row) {
            if (row >= this.getRowCount()) {
                return null;
            }
            return this.data.get(row);
        }

        public List<TenantInfo> getSelectedTenantInfo() {
            ArrayList<TenantInfo> selected = new ArrayList<TenantInfo>();
            if (this.isSelects != null) {
                for (int i = 0; i < this.isSelects.size(); ++i) {
                    if (!this.isSelects.get(i).booleanValue()) continue;
                    selected.add(this.getTenantInfo(i));
                }
            }
            return selected;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            TenantInfo tenant = this.getTenantInfo(row);
            if (tenant == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    return this.isSelects.get(row);
                }
                case 1: {
                    return tenant.getId();
                }
                case 2: {
                    return tenant.getName();
                }
                case 3: {
                    return tenant.getUrl();
                }
                case 4: {
                    return tenant.getYukoDateFrom();
                }
                case 5: {
                    return tenant.getYukoDateTo();
                }
                case 6: {
                    return tenant.getCreateDate();
                }
                case 7: {
                    return tenant.getUpdateDate();
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            TenantInfo tenant = this.getTenantInfo(row);
            if (tenant == null) {
                return;
            }
            switch (column) {
                case 0: {
                    this.isSelects.set(row, (Boolean)aValue);
                    return;
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (this.getRowCount() == 0) {
                return String.class;
            }
            Object value = this.getValueAt(0, column);
            if (value == null) {
                return String.class;
            }
            return value.getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    public class TenantTableColumnInfo {
        String name;
        int colSize;

        public TenantTableColumnInfo(String name, int colSize) {
            this.name = name;
            this.colSize = colSize;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getColSize() {
            return this.colSize;
        }

        public void setColSize(int colSize) {
            this.colSize = colSize;
        }
    }
}

