/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.partition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.tools.batch.partition.MySQLPartitionBatch;
import org.iplass.mtp.tools.batch.tenant.TenantBatch;
import org.iplass.mtp.tools.gui.MtpJFrameBase;
import org.iplass.mtp.tools.gui.partition.PartitionCreateDialog;
import org.iplass.mtp.tools.gui.partition.PartitionTable;
import org.iplass.mtp.tools.gui.tenant.TenantManagerApp;
import org.iplass.mtp.tools.gui.widget.menu.BasicMenuBar;

public class MySQLPartitionManagerApp
extends MtpJFrameBase {
    private static final long serialVersionUID = 5705897124813193817L;
    private JButton btnRefresh;
    private JTextField txtCount;
    private PartitionTable.PartitionTableModel model;
    private MySQLPartitionBatch manager = new MySQLPartitionBatch(TenantBatch.TenantBatchExecMode.GUI.name());

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MySQLPartitionManagerApp frame = new MySQLPartitionManagerApp();
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MySQLPartitionManagerApp() {
        this.setTitle("MySQL Partition Manager");
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)new BasicMenuBar(this), "North");
        JPanel mainPane = new JPanel();
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.setLayout(new BorderLayout(0, 0));
        mainPane.setPreferredSize(new Dimension(500, 600));
        this.getContentPane().add((Component)mainPane, "Center");
        mainPane.add((Component)this.createHeaderPane(), "North");
        mainPane.add((Component)this.createPartitionTableList(), "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowActivated(e);
                MySQLPartitionManagerApp.this.searchPartitionList();
            }
        });
    }

    private JPanel createHeaderPane() {
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BorderLayout());
        JPanel headerMainPane = new JPanel();
        headerMainPane.setLayout(new FlowLayout(0));
        JButton btnCreate = new JButton("Create Partition");
        btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCreateDialog dialog = new PartitionCreateDialog(MySQLPartitionManagerApp.this);
                dialog.setModal(true);
                dialog.addPartitionDataChangeListner(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        MySQLPartitionManagerApp.this.searchPartitionList();
                    }
                });
                dialog.setVisible(true);
            }
        });
        headerMainPane.add(btnCreate);
        JButton btnTenantList = new JButton("Tenant List");
        btnTenantList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TenantManagerApp.main(new String[0]);
                MySQLPartitionManagerApp.this.dispose();
            }
        });
        headerMainPane.add(btnTenantList);
        JPanel headerSubPane = new JPanel();
        headerSubPane.setLayout(new FlowLayout(0));
        this.btnRefresh = new JButton("Refresh List");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MySQLPartitionManagerApp.this.searchPartitionList();
            }
        });
        JLabel lblCount = new JLabel("Count");
        lblCount.setHorizontalAlignment(4);
        this.txtCount = new JTextField();
        this.txtCount.setPreferredSize(new Dimension(30, 25));
        this.txtCount.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.txtCount.setHorizontalAlignment(4);
        this.txtCount.setEditable(false);
        headerSubPane.add(this.btnRefresh);
        headerSubPane.add(lblCount);
        headerSubPane.add(this.txtCount);
        headerPane.add((Component)headerMainPane, "Center");
        headerPane.add((Component)headerSubPane, "East");
        return headerPane;
    }

    private JScrollPane createPartitionTableList() {
        PartitionTable table = new PartitionTable();
        this.model = table.getModel();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(table);
        return scroll;
    }

    private void searchPartitionList() {
        this.model.setPartitionData(Collections.emptyList());
        this.model.fireTableDataChanged();
        this.btnRefresh.setText("search...");
        this.txtCount.setText("");
        this.btnRefresh.setEnabled(false);
        SearchPartitionWorker worker = new SearchPartitionWorker();
        worker.execute();
    }

    private class SearchPartitionWorker
    extends SwingWorker<List<PartitionInfo>, Object> {
        private SearchPartitionWorker() {
        }

        @Override
        protected List<PartitionInfo> doInBackground() throws Exception {
            return MySQLPartitionManagerApp.this.manager.getPartitionInfo();
        }

        @Override
        protected void done() {
            try {
                List result = (List)this.get();
                MySQLPartitionManagerApp.this.model.setPartitionData(result);
                MySQLPartitionManagerApp.this.model.fireTableDataChanged();
                MySQLPartitionManagerApp.this.txtCount.setText(String.valueOf(result.size()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(MySQLPartitionManagerApp.this, MySQLPartitionManagerApp.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(MySQLPartitionManagerApp.this, MySQLPartitionManagerApp.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
            }
            MySQLPartitionManagerApp.this.btnRefresh.setText("Refresh List");
            MySQLPartitionManagerApp.this.btnRefresh.setEnabled(true);
        }
    }
}

