/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.cleaner;

import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.lob.LobHandler;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;

public class TempLobCleaner
extends MtpCuiBase {
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private int tenantId;

    public static void main(String[] args) throws Exception {
        int tenantId = -1;
        if (args != null && args.length > 0 && StringUtil.isNotEmpty((String)args[0])) {
            tenantId = Integer.parseInt(args[0]);
        }
        if (tenantId >= 0) {
            new TempLobCleaner(tenantId).clean();
        } else {
            List<TenantInfo> tenants = TempLobCleaner.getValidTenantInfoList();
            if (tenants != null) {
                for (TenantInfo t : tenants) {
                    new TempLobCleaner(t.getId()).clean();
                }
            }
        }
    }

    public TempLobCleaner(int tenantId) {
        this.setTenantId(tenantId);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
    }

    public boolean clean() throws Exception {
        this.setSuccess(false);
        this.clearLog();
        try {
            ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tenantContextService.getTenantContext(this.tenantId)));
            this.logArguments();
            Transaction.required(t -> LobHandler.cleanTemporaryBinaryData());
            Transaction.required(t -> LobHandler.cleanLobData());
            this.setSuccess(true);
        }
        catch (Throwable e) {
            try {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.getTenantId());
        this.logInfo("");
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }
}

