/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.fulltextsearch;

import java.util.Date;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchManager;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDataCrawler
extends MtpCuiBase {
    private static final Logger logger = LoggerFactory.getLogger(EntityDataCrawler.class);
    private TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private FulltextSearchManager fsm = (FulltextSearchManager)ManagerLocator.getInstance().getManager(FulltextSearchManager.class);
    private Mode mode;
    private int tenantId;

    public static void main(String[] args) throws Exception {
        Date sysDate = new Date();
        logger.debug("### Started Crawling [" + sysDate + "] ###");
        if (args != null && args.length > 0) {
            Mode mode = null;
            if (Mode.CRAWL.name().equalsIgnoreCase(args[0])) {
                mode = Mode.CRAWL;
            } else if (Mode.RECRAWL.name().equalsIgnoreCase(args[0])) {
                mode = Mode.RECRAWL;
            }
            if (mode != null) {
                int tenantId = -1;
                if (args.length > 1) {
                    tenantId = Integer.parseInt(args[1]);
                }
                if (tenantId >= 0) {
                    new EntityDataCrawler(mode, tenantId).execute();
                } else {
                    List<TenantInfo> tenants = EntityDataCrawler.getValidTenantInfoList();
                    if (tenants != null) {
                        for (TenantInfo t : tenants) {
                            new EntityDataCrawler(mode, t.getId()).execute();
                        }
                    }
                }
            }
        }
        sysDate = new Date();
        logger.debug("### Finished Crawling [" + sysDate + "] ###");
    }

    public EntityDataCrawler(Mode mode, int tenantId) {
        this.mode = mode;
        this.tenantId = tenantId;
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
    }

    public boolean execute() throws Exception {
        this.setSuccess(false);
        this.clearLog();
        try {
            ExecuteContext.executeAs((TenantContext)this.tenantContextService.getTenantContext(this.tenantId), (Executable)new Executable<Void>(){

                public Void execute() {
                    EntityDataCrawler.this.logArguments();
                    switch (EntityDataCrawler.this.mode) {
                        case CRAWL: {
                            EntityDataCrawler.this.crawl();
                            break;
                        }
                        case RECRAWL: {
                            EntityDataCrawler.this.recrawl();
                            break;
                        }
                    }
                    return null;
                }
            });
            this.setSuccess(true);
        }
        catch (Throwable e) {
            try {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        return this.isSuccess();
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.tenantId);
        this.logInfo("\tmode :" + this.mode.name());
        this.logInfo("");
    }

    private void crawl() {
        logger.debug("### CRAWL Target TenantId :" + this.tenantId + " ###");
        this.fsm.crawlAllEntity();
    }

    private void recrawl() {
        logger.debug("### RECRAWL Target TenantId :" + this.tenantId + " ###");
        this.fsm.recrawlAllEntity();
    }

    static enum Mode {
        RECRAWL,
        CRAWL;

    }
}

