/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.core.config.ConfigImpl;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.impl.datastore.DataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.strategy.ApplyMetaDataStrategy;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataJAXBService;
import org.iplass.mtp.impl.metadata.xmlresource.XmlResourceMetaDataStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;

public class MetaDataPatch {
    private static int tenantId;
    private static String newDefaultMetaData;
    private static String oldDefaultMetaData;
    private static boolean silent;
    static MetaDataJAXBService jaxb;
    static ApplyMetaDataStrategy applyMetaStrategy;

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            tenantId = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            newDefaultMetaData = args[1];
        }
        if (args.length > 2) {
            oldDefaultMetaData = args[2];
        }
        if (args.length > 3 && args[3].equalsIgnoreCase("silent")) {
            silent = true;
        }
        MetaDataPatch.patchData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchData() throws Exception {
        TenantContext tContext = ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).getTenantContext(tenantId);
        if (!silent) {
            System.out.println("tenantId: " + tContext.getTenantId() + " (" + tContext.loadTenantInfo().getName() + ")\u306e\u30c7\u30fc\u30bf\u3092" + oldDefaultMetaData + "\u304b\u3089\u3001" + newDefaultMetaData + "\u3078\u30c7\u30fc\u30bf\u3092\u30d1\u30c3\u30c1\u3057\u307e\u3059\u3002(YES/NO)");
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            String str = console.readLine();
            if (!str.equals("YES")) {
                System.out.println("abort!");
                return;
            }
        }
        ConfigImpl newConfig = new ConfigImpl("forPatchNew", new NameValue[]{new NameValue("filePath", newDefaultMetaData)});
        newConfig.addDependentService(MetaDataJAXBService.class.getName(), (Service)jaxb);
        XmlResourceMetaDataStore newRepo = new XmlResourceMetaDataStore();
        newRepo.inited(null, (Config)newConfig);
        ConfigImpl oldConfig = new ConfigImpl("forPatchOld", new NameValue[]{new NameValue("filePath", oldDefaultMetaData)});
        oldConfig.addDependentService(MetaDataJAXBService.class.getName(), (Service)jaxb);
        XmlResourceMetaDataStore oldRepo = new XmlResourceMetaDataStore();
        oldRepo.inited(null, (Config)oldConfig);
        ExecuteContext econtext = new ExecuteContext(tContext);
        econtext.setClientId("0000");
        ExecuteContext.initContext((ExecuteContext)econtext);
        Transaction t = ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).newTransaction();
        try {
            List entityList = newRepo.definitionList(tContext.getTenantId(), "/entity");
            if (entityList != null) {
                for (MetaDataEntryInfo entry : entityList) {
                    MetaEntity newMetaEntity = (MetaEntity)newRepo.load(tContext.getTenantId(), entry.getPath()).getMetaData();
                    MetaEntity oldMetaEntity = (MetaEntity)oldRepo.load(tContext.getTenantId(), entry.getPath()).getMetaData();
                    if (oldMetaEntity == null) continue;
                    StoreService storeService = (StoreService)ServiceRegistry.getRegistry().getService(StoreService.class);
                    DataStore srds = storeService.getDataStore();
                    EntityContext ec = EntityContext.getCurrentContext();
                    srds.getApplyMetaDataStrategy().patchData(newMetaEntity, oldMetaEntity, ec, EntityContext.getCurrentContext().getLocalTenantId());
                }
            }
        }
        catch (Exception e) {
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.rollback();
                throw e;
            }
        }
        finally {
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.commit();
            }
        }
        System.out.println("done!");
    }

    static {
        silent = false;
        jaxb = (MetaDataJAXBService)ServiceRegistry.getRegistry().getService(MetaDataJAXBService.class);
        applyMetaStrategy = ((StoreService)ServiceRegistry.getRegistry().getService(StoreService.class)).getDataStore().getApplyMetaDataStrategy();
    }
}

