/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.partition;

import java.util.List;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.gui.partition.MySQLPartitionManagerApp;
import org.iplass.mtp.util.StringUtil;

public class MySQLPartitionBatch
extends MtpCuiBase {
    private MySQLPartitionBatchExecMode execMode = MySQLPartitionBatchExecMode.GUI;
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);

    public static void main(String[] args) {
        MySQLPartitionBatch instance = null;
        try {
            instance = new MySQLPartitionBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public MySQLPartitionBatch(String ... args) {
        if (args != null && args.length > 0) {
            this.setExecMode(MySQLPartitionBatchExecMode.valueOf(args[0]));
        }
    }

    public boolean execute() {
        this.clearLog();
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.addLogListner(consoleLogListner);
        this.logEnvironment();
        switch (this.getExecMode()) {
            case GUI: {
                this.logInfo("\u25a0Start App");
                this.logInfo("");
                this.removeLogListner(consoleLogListner);
                MySQLPartitionManagerApp.main(new String[]{this.getLanguage()});
                return true;
            }
            case CREATE: {
                this.logInfo("\u25a0Start Create Wizard");
                this.logInfo("");
                return this.startCreateWizard();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.getExecMode()));
        return false;
    }

    public MySQLPartitionBatchExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(MySQLPartitionBatchExecMode execMode) {
        this.execMode = execMode;
    }

    public List<PartitionInfo> getPartitionInfo() {
        return this.toolService.getPartitionInfo();
    }

    public boolean createPartition(PartitionCreateParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        try {
            boolean isSuccess = this.toolService.createPartition(param, new LogHandler(){

                public void info(String message) {
                    MySQLPartitionBatch.this.logInfo(message);
                }

                public void info(String message, Throwable e) {
                    MySQLPartitionBatch.this.logInfo(message, e);
                }

                public void warn(String message) {
                    MySQLPartitionBatch.this.logWarn(message);
                }

                public void warn(String message, Throwable e) {
                    MySQLPartitionBatch.this.logWarn(message, e);
                }

                public void error(String message) {
                    MySQLPartitionBatch.this.logError(message);
                }

                public void error(String message, Throwable e) {
                    MySQLPartitionBatch.this.logError(message, e);
                }
            });
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            try {
                this.logError(this.rs("Common.errorMsg", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        return this.isSuccess();
    }

    private boolean startCreateWizard() {
        String strMaxTenantId = this.readConsole(this.rs("MySQLPartitionManager.Create.inputMaxTenantIdMsg", new Object[0]));
        if (StringUtil.isEmpty((String)strMaxTenantId)) {
            this.logWarn(this.rs("MySQLPartitionManager.Create.requiredMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-show")) {
            this.showAllPartitionList();
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startCreateWizard();
        }
        PartitionCreateParameter param = new PartitionCreateParameter();
        try {
            int maxTenantId = Integer.parseInt(strMaxTenantId);
            param.setTenantId(maxTenantId);
        }
        catch (Exception e) {
            this.logWarn(this.rs("MySQLPartitionManager.Create.warnMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        boolean isUseSubPartition = this.readConsoleBoolean(this.rs("MySQLPartitionManager.Create.useSubPartitionMsg", new Object[0]), param.isMySqlUseSubPartition());
        param.setMySqlUseSubPartition(isUseSubPartition);
        this.logArguments(param);
        boolean isExecute = this.readConsoleBoolean(this.rs("MySQLPartitionManager.Create.confirmCreatePartitionMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startCreateWizard();
        }
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.removeLogListner(consoleLogListner);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
        boolean ret = this.createPartition(param);
        this.removeLogListner(loggingListner);
        return ret;
    }

    private void showAllPartitionList() {
        try {
            List<PartitionInfo> partitionList = this.getPartitionInfo();
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Partition List(Max Tenant ID)");
            for (PartitionInfo partition : partitionList) {
                this.logInfo("[" + partition.getTableName() + "] " + partition.getMaxTenantId());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private void logArguments(PartitionCreateParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\tmax tenant id :" + param.getTenantId());
        this.logInfo("\tuse sub partition :" + param.isMySqlUseSubPartition());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    public static enum MySQLPartitionBatchExecMode {
        GUI,
        CREATE;

    }
}

