/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.storagespace;

import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.tools.storagespace.StorageSpaceService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;

public class StorageSpaceCleaner
extends MtpCuiBase {
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static StorageSpaceService storageSpaceService = (StorageSpaceService)ServiceRegistry.getRegistry().getService(StorageSpaceService.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private String entityName;
    private String storageSpaceName;

    public StorageSpaceCleaner(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(Integer.parseInt(args[1]));
            }
            if (args.length > 2) {
                this.setEntityName(args[2]);
            }
            if (args.length > 3) {
                this.setStorageSpaceName(args[3]);
            }
        }
    }

    public static void main(String[] args) {
        try {
            new StorageSpaceCleaner(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setStorageSpaceName(String storageSpaceName) {
        this.storageSpaceName = storageSpaceName;
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.addLogListner(this.getConsoleLogListner());
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                return this.proceed();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.setTenantId(Integer.parseInt(tenantId));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("StorageSpaceCleaner.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        boolean validEntityName = false;
        do {
            String entityName;
            if (!StringUtil.isNotBlank((String)(entityName = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.entityNameMsg", new Object[0]))))) continue;
            this.setEntityName(entityName);
            validEntityName = true;
        } while (!validEntityName);
        boolean validStorageSpaceName = false;
        do {
            String storageSpaceName;
            if (!StringUtil.isNotBlank((String)(storageSpaceName = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.storageSpaceNameMsg", new Object[0]))))) continue;
            this.setStorageSpaceName(storageSpaceName);
            validStorageSpaceName = true;
        } while (!validStorageSpaceName);
        this.removeLogListner(this.getConsoleLogListner());
        this.addLogListner(this.getLoggingLogListner());
        boolean ret = this.proceed();
        this.removeLogListner(this.getLoggingLogListner());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proceed() {
        EntityHandler entityHandler;
        block8: {
            TenantContext tCtx;
            block7: {
                boolean bl;
                this.setSuccess(false);
                try {
                    tCtx = tenantContextService.getTenantContext(this.tenantId);
                    if (tCtx != null) break block7;
                    this.logError(this.rs("StorageSpaceCleaner.notFoundTenant", this.tenantId));
                    bl = this.isSuccess();
                }
                catch (Throwable throwable) {
                    this.logInfo("");
                    this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                    this.logInfo("");
                    ExecuteContext.initContext(null);
                    throw throwable;
                }
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                ExecuteContext.initContext(null);
                return bl;
            }
            ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tCtx));
            entityHandler = (EntityHandler)MetaDataContext.getContext().getMetaDataHandler(EntityHandler.class, "/entity/" + this.entityName.replace(".", "/"));
            if (entityHandler != null) break block8;
            this.logError(this.rs("StorageSpaceCleaner.notFoundEntity", this.entityName));
            boolean bl = this.isSuccess();
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
            ExecuteContext.initContext(null);
            return bl;
        }
        try {
            storageSpaceService.cleanup(this.tenantId, this.storageSpaceName, entityHandler.getMetaData());
        }
        catch (Exception e) {
            this.logError(this.rs("StorageSpaceCleaner.failedCleanup", new Object[0]), e);
            boolean bl = this.isSuccess();
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
            ExecuteContext.initContext(null);
            return bl;
        }
        this.setSuccess(true);
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }
}

