/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.DefinitionSummary;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;

public class EntityJavaMappingClassCreator
extends MtpCuiBase {
    private static final String ROOT_ENTITY = "/entity/Entity";
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityToolService entityToolService = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private boolean isRecursive = true;
    private boolean isForce = false;
    private String outDir = ".";
    private String entityPath;
    private String basePackage;

    public EntityJavaMappingClassCreator(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(Integer.parseInt(args[1]));
            }
            if (args.length > 2) {
                this.setRecursive(args[2]);
            }
            if (args.length > 3) {
                this.setForce(args[3]);
            }
            if (args.length > 4) {
                this.setOutDir(args[4]);
            }
            if (args.length > 5) {
                this.setEntityPath(args[5]);
            }
            if (args.length > 6) {
                this.setBasePackage(args[6]);
            }
        }
    }

    public static void main(String ... args) {
        try {
            new EntityJavaMappingClassCreator(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public void setRecursive(String recursive) {
        this.setRecursive("recursive".equals(StringUtil.lowerCase((String)recursive)));
    }

    public void setRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public void setForce(String force) {
        this.isForce = "force".equals(StringUtil.lowerCase((String)force));
    }

    public void setForce(boolean isForce) {
        this.isForce = isForce;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.addLogListner(this.getConsoleLogListner());
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                return this.proceed();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        String outDir;
        String basePackage;
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.setTenantId(Integer.parseInt(tenantId));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("EntityJavaMappingClassCreator.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        String entityPath = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.entityPathMsg", new Object[0]));
        if (StringUtil.isNotBlank((String)entityPath)) {
            this.setEntityPath(entityPath);
        }
        if (StringUtil.isNotBlank((String)(basePackage = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.basePackageMsg", new Object[0]))))) {
            this.setBasePackage(basePackage);
        }
        if (StringUtil.isNotBlank((String)(outDir = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.outDirMsg", new Object[0]))))) {
            this.setOutDir(outDir);
        }
        this.setRecursive(this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.Wizard.recursiveMsg", new Object[0]), this.isRecursive));
        this.setForce(this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.Wizard.forceMsg", new Object[0]), this.isForce));
        boolean ret = this.proceed();
        this.removeLogListner(this.getLoggingLogListner());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean proceed() {
        block6: {
            block5: {
                block4: {
                    this.setSuccess(false);
                    try {
                        tCtx = EntityJavaMappingClassCreator.tenantContextService.getTenantContext(this.tenantId);
                        if (tCtx != null) break block4;
                        this.logError(this.rs("EntityJavaMappingClassCreator.notFoundTenant", new Object[]{this.tenantId}));
                        var2_2 = this.isSuccess();
                    }
                    catch (Throwable var5_7) {
                        this.logInfo("");
                        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() != false ? "SUCCESS" : "FAILED"));
                        this.logInfo("");
                        ExecuteContext.initContext(null);
                        throw var5_7;
                    }
                    this.logInfo("");
                    this.logInfo("\u25a0Execute Result :" + (this.isSuccess() != false ? "SUCCESS" : "FAILED"));
                    this.logInfo("");
                    ExecuteContext.initContext(null);
                    return var2_2;
                }
                ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tCtx));
                ed = this.edm.get(this.entityPath);
                if (ed == null) ** GOTO lbl36
                file = new File(this.generateJavaClassFileName(ed.getName()));
                if (this.isForce || !file.exists() || this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.confirmOverwrite", new Object[]{file.getPath()}), false)) break block5;
                this.setSuccess(true);
                var4_6 = this.isSuccess();
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() != false ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                ExecuteContext.initContext(null);
                return var4_6;
            }
            EntityJavaMappingClassCreator.entityToolService.createJavaMappingClass(file, ed, this.basePackage);
            break block6;
lbl36:
            // 1 sources

            list = this.edm.definitionSummaryList(this.entityPath, this.isRecursive);
            list.forEach((Consumer<DefinitionSummary>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$proceed$0(org.iplass.mtp.definition.DefinitionSummary ), (Lorg/iplass/mtp/definition/DefinitionSummary;)V)((EntityJavaMappingClassCreator)this));
        }
        this.setSuccess(true);
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() != false ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    private String generateJavaClassFileName(String entityName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.outDir).append('/');
        if (StringUtil.isNotBlank((String)this.basePackage)) {
            sb.append(this.basePackage.replace('.', '/')).append('/');
        }
        sb.append(entityName.replace('.', '/')).append(".java");
        return sb.toString();
    }

    private /* synthetic */ void lambda$proceed$0(DefinitionSummary it) {
        if (ROOT_ENTITY.equals(it.getPath())) {
            return;
        }
        File file = new File(this.generateJavaClassFileName(it.getName()));
        if (!this.isForce && file.exists() && !this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.confirmOverwrite", file.getPath()), false)) {
            return;
        }
        entityToolService.createJavaMappingClass(file, this.edm.get(it.getName()), this.basePackage);
    }
}

