/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.core.config.ConfigImpl;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.lobstore.file.FileLobData;
import org.iplass.mtp.impl.lob.lobstore.file.FileLobStore;
import org.iplass.mtp.impl.lob.lobstore.rdb.RdbLobStore;
import org.iplass.mtp.impl.lob.sql.BlobSearchSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.transaction.Transaction;

public class LobStoreMigrator
extends MtpCuiBase {
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private int tenantId;
    private String rootDir;
    private MigrateMode migrateMode;
    private MigrateTarget migrateTarget;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 4) {
            throw new IllegalArgumentException("Argument is not specified, or the number of the argument is invalid.");
        }
        MigrateMode mode = MigrateMode.valueOf(args[0].toUpperCase());
        MigrateTarget target = MigrateTarget.valueOf(args[1].toUpperCase());
        String rootDir = args[2];
        int tenantId = Integer.parseInt(args[3]);
        if (tenantId >= 0) {
            new LobStoreMigrator(mode, target, rootDir, tenantId).execute();
        } else {
            List<TenantInfo> tenants = LobStoreMigrator.getValidTenantInfoList();
            if (tenants != null) {
                for (TenantInfo t : tenants) {
                    new LobStoreMigrator(mode, target, rootDir, t.getId()).execute();
                }
            }
        }
    }

    public LobStoreMigrator(MigrateMode mode, MigrateTarget target, String rootDir, int tenantId) {
        this.tenantId = tenantId;
        this.rootDir = rootDir;
        this.migrateMode = mode;
        this.migrateTarget = target;
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
    }

    public boolean execute() throws Exception {
        this.setSuccess(false);
        this.clearLog();
        try {
            ExecuteContext.initContext((ExecuteContext)new ExecuteContext(tenantContextService.getTenantContext(this.tenantId)));
            this.logArguments();
            Transaction.required(t -> {
                ServiceRegistry sr = ServiceRegistry.getRegistry();
                LobStoreService lobStoreService = (LobStoreService)sr.getService(LobStoreService.class);
                ConfigImpl config = new ConfigImpl("lobStoreMigrator", null);
                config.addDependentService(RdbAdapterService.class.getName(), sr.getService(RdbAdapterService.class));
                RdbLobStore rdbLobStore = new RdbLobStore();
                FileLobStore fileLobStore = new FileLobStore();
                fileLobStore.setRootDir(this.rootDir);
                rdbLobStore.inited(lobStoreService, (Config)config);
                fileLobStore.inited(lobStoreService, (Config)config);
                FileLobStore lobStore = MigrateMode.F2R.equals((Object)this.migrateMode) ? fileLobStore : rdbLobStore;
                final RdbAdapter rdb = ((RdbAdapterService)sr.getService(RdbAdapterService.class)).getRdbAdapter();
                LobDao dao = lobStoreService.getLobDao();
                SqlExecuter<Void> exec = new SqlExecuter<Void>((LobStore)lobStore, dao, lobStoreService, fileLobStore, rdbLobStore){
                    final /* synthetic */ LobStore val$lobStore;
                    final /* synthetic */ LobDao val$dao;
                    final /* synthetic */ LobStoreService val$lobStoreService;
                    final /* synthetic */ FileLobStore val$fileLobStore;
                    final /* synthetic */ RdbLobStore val$rdbLobStore;
                    {
                        this.val$lobStore = lobStore;
                        this.val$dao = lobDao;
                        this.val$lobStoreService = lobStoreService;
                        this.val$fileLobStore = fileLobStore;
                        this.val$rdbLobStore = rdbLobStore;
                    }

                    public Void logic() throws SQLException {
                        BlobSearchSql sqlCreator = (BlobSearchSql)rdb.getQuerySqlCreator(BlobSearchSql.class);
                        String sql = sqlCreator.toSqlForMigrate(rdb, LobStoreMigrator.this.tenantId);
                        try (ResultSet rs = this.getStatement().executeQuery(sql);){
                            while (rs.next()) {
                                Lob lob = sqlCreator.toBinaryData(rs, this.val$lobStore, this.val$dao, this.val$lobStoreService.isManageLobSizeOnRdb());
                                if (MigrateTarget.BINARY.equals((Object)LobStoreMigrator.this.migrateTarget) && "_LongText".equals(lob.getName()) || MigrateTarget.LONGTEXT.equals((Object)LobStoreMigrator.this.migrateTarget) && !"_LongText".equals(lob.getName())) continue;
                                switch (LobStoreMigrator.this.migrateMode) {
                                    case R2F: {
                                        LobStoreMigrator.this.migrateRdbToFile(lob, this.val$fileLobStore);
                                        break;
                                    }
                                    case F2R: {
                                        LobStoreMigrator.this.migrateFileToRdb(lob, this.val$rdbLobStore);
                                    }
                                }
                            }
                            Void void_ = null;
                            return void_;
                        }
                    }
                };
                exec.execute(rdb, true);
                return null;
            });
            this.setSuccess(true);
        }
        catch (Throwable e) {
            try {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.tenantId);
        this.logInfo("");
    }

    private void migrateRdbToFile(Lob lob, FileLobStore fileLobStore) {
        if (lob.getSize() > 0L) {
            FileLobData fileLobData = (FileLobData)fileLobStore.create(this.tenantId, lob.getLobDataId());
            Path path = Paths.get(fileLobData.getFilePath(), new String[0]);
            try (InputStream in = lob.getBinaryInputStream();){
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void migrateFileToRdb(Lob lob, RdbLobStore rdbLobStore) {
        FileLobData fileLobData = (FileLobData)lob.getLobData();
        if (Files.exists(Paths.get(fileLobData.getFilePath(), new String[0]), new LinkOption[0])) {
            rdbLobStore.remove(this.tenantId, lob.getLobDataId());
            LobData rdbLobData = rdbLobStore.create(this.tenantId, lob.getLobDataId());
            try (OutputStream out = rdbLobData.getBinaryOutputStream();){
                Files.copy(Paths.get(fileLobData.getFilePath(), new String[0]), out);
            }
            catch (IOException e) {
                this.logError("An error has occurred. : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static enum MigrateTarget {
        ALL,
        BINARY,
        LONGTEXT;

    }

    public static enum MigrateMode {
        F2R,
        R2F;

    }
}

