/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.MetaDataWriteCallback;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.metadata.MetaDataExportParameter;
import org.iplass.mtp.tools.batch.pack.PackageExport;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;

public class MetaDataExport
extends MtpCuiBase {
    public static final String KEY_CONFIG_FILE = "meta.config";
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private MetaDataPortingService mdps = (MetaDataPortingService)ServiceRegistry.getRegistry().getService(MetaDataPortingService.class);
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;

    public static void main(String[] args) {
        MetaDataExport instance = null;
        try {
            instance = new MetaDataExport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            ExecuteContext.finContext();
        }
    }

    public MetaDataExport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MetaDataExport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public MetaDataExport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public boolean exportMeta(MetaDataExportParameter param) {
        this.setSuccess(false);
        try {
            boolean isSuccess = (Boolean)Transaction.required(t -> {
                TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
                return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
                    ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
                    if (param.getExportMetaDataPathList() == null) {
                        param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                    }
                    if (CollectionUtil.isNotEmpty(param.getExportMetaDataPathList())) {
                        this.logDebug("metadata path count : " + param.getExportMetaDataPathList().size());
                        this.logInfo(this.rs("MetaDataExport.startExportMetaData", new Object[0]));
                        File metadataFile = new File(param.getExportDir(), param.getFileName() + ".xml");
                        try (PrintWriter writer = new PrintWriter(metadataFile, "UTF-8");){
                            this.mdps.write(writer, param.getExportMetaDataPathList(), new MetaDataWriteCallback(){

                                public void onWrited(String path, String version) {
                                    MetaDataExport.this.logInfo(MetaDataExport.this.rs("MetaDataExport.outputMetaData", new Object[]{path}));
                                }

                                public boolean onWarning(String path, String message, String version) {
                                    MetaDataExport.this.logWarn(MetaDataExport.this.rs("MetaDataExport.warningOutputMetaData", new Object[]{path}));
                                    MetaDataExport.this.logWarn(message);
                                    return true;
                                }

                                public void onStarted() {
                                }

                                public void onFinished() {
                                }

                                public boolean onErrored(String path, String message, String version) {
                                    MetaDataExport.this.logError(MetaDataExport.this.rs("MetaDataExport.errorOutputMetaData", new Object[]{path}));
                                    MetaDataExport.this.logError(message);
                                    return false;
                                }
                            });
                        }
                        catch (FileNotFoundException e) {
                            throw new SystemException((Throwable)e);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new SystemException((Throwable)e);
                        }
                        this.logInfo(this.rs("MetaDataExport.completedExportMetaData", new Object[0]));
                    } else {
                        this.logWarn(this.rs("MetaDataExport.nonTargetMetaData", new Object[0]));
                    }
                    return true;
                });
            });
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            this.logError(this.rs("Common.errorMsg", e.getMessage()));
        }
        return this.isSuccess();
    }

    public void logArguments(MetaDataExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\texport dir :" + param.getExportDirName());
        this.logInfo("\tfile name :" + param.getFileName());
        String metaTarget = null;
        if (param.isExportAllMetaData()) {
            metaTarget = "ALL";
            metaTarget = param.isExportTenantMetaData() ? metaTarget + "(include Tenant)" : metaTarget + "(exclude Tenant)";
        } else {
            metaTarget = param.getExportMetaDataPathStr();
        }
        metaTarget = metaTarget + "(" + param.getExportMetaDataPathList().size() + ")";
        this.logInfo("\tmetadata target :" + metaTarget);
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private List<String> getMetaDataPathList(MetaDataExportParameter param) {
        ArrayList<String> paths = new ArrayList<String>();
        if (param.isExportAllMetaData()) {
            List allMeta = MetaDataContext.getContext().definitionList("/");
            for (MetaDataEntryInfo info : allMeta) {
                if (param.isExportLocalMetaDataOnly() && info.getRepositryType() != MetaDataEntry.RepositoryType.TENANT_LOCAL || !param.isExportTenantMetaData() && this.mdps.isTenantMeta(info.getPath())) continue;
                paths.add(info.getPath());
            }
        } else {
            String[] pathStrArray;
            HashSet<String> directPathSet = new HashSet<String>();
            for (String pathStr : pathStrArray = param.getExportMetaDataPathStr().split(",")) {
                if (StringUtil.isEmpty((String)pathStr)) continue;
                if (pathStr.endsWith("*")) {
                    List allMeta = MetaDataContext.getContext().definitionList(pathStr.substring(0, pathStr.length() - 1));
                    for (MetaDataEntryInfo info : allMeta) {
                        if (param.isExportLocalMetaDataOnly() && info.getRepositryType() != MetaDataEntry.RepositoryType.TENANT_LOCAL) continue;
                        directPathSet.add(info.getPath());
                    }
                    continue;
                }
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(pathStr);
                if (entry != null) {
                    if (param.isExportLocalMetaDataOnly() && entry.getRepositryType() != MetaDataEntry.RepositoryType.TENANT_LOCAL) {
                        this.logWarn(this.rs("MetaDataExport.excludeNotLocalMetaLog", pathStr));
                        continue;
                    }
                    directPathSet.add(entry.getPath());
                    continue;
                }
                this.logWarn(this.rs("MetaDataExport.notFoundMetaLog", pathStr));
            }
            paths.addAll(directPathSet);
        }
        return paths.stream().sorted().collect(Collectors.toList());
    }

    private void showMetaDataPathList(MetaDataExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0MetaData List");
        for (String path : param.getExportMetaDataPathList()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    private boolean wizard() {
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                this.tenantId = null;
                return this.wizard();
            }
        } else {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            String url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            tenant = this.ts.getTenant(url);
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        MetaDataExportParameter param = new MetaDataExportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validFile = false;
            do {
                File dir;
                String exportDirName;
                if (StringUtil.isNotBlank((String)(exportDirName = this.readConsole(this.rs("MetaDataExport.Wizard.inputDirMsg", new Object[0]) + "(" + param.getExportDirName() + ")")))) {
                    param.setExportDirName(exportDirName);
                }
                if (!this.checkDir(dir = new File(param.getExportDirName()))) continue;
                param.setExportDir(dir);
                validFile = true;
            } while (!validFile);
            String fileName = this.readConsole(this.rs("MetaDataExport.Wizard.inputFileNameMsg", new Object[0]) + "(" + param.getFileName() + ")");
            if (StringUtil.isNotBlank((String)fileName)) {
                param.setFileName(fileName);
            }
            boolean validTarget = false;
            do {
                boolean isContinue;
                boolean isExportLocalOnly = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmTargetLocalMetaMsg", new Object[0]), param.isExportLocalMetaDataOnly());
                param.setExportLocalMetaDataOnly(isExportLocalOnly);
                boolean isExportAllMeta = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmExportAllMetaMsg", new Object[0]), param.isExportAllMetaData());
                param.setExportAllMetaData(isExportAllMeta);
                if (isExportAllMeta) {
                    boolean isExportTenantMetaData = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmIncludeTenantMetaMsg", new Object[0]), param.isExportTenantMetaData());
                    param.setExportTenantMetaData(isExportTenantMetaData);
                    validTarget = true;
                } else {
                    String exportMetaDataPathStr = this.readConsole(this.rs("MetaDataExport.Wizard.inputMetaPathMsg", new Object[0]));
                    if (StringUtil.isEmpty((String)exportMetaDataPathStr)) {
                        this.logWarn(this.rs("MetaDataExport.Wizard.requiredMetaPathMsg", new Object[0]));
                        this.logInfo("");
                    } else {
                        param.setExportMetaDataPathStr(exportMetaDataPathStr);
                        validTarget = true;
                    }
                }
                if (!validTarget) continue;
                param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                boolean isShow = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmShowMetaListMsg", param.getExportMetaDataPathList().size()), false);
                if (isShow) {
                    this.showMetaDataPathList(param);
                }
                if (isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true)) continue;
                validTarget = false;
            } while (!validTarget);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmExecuteMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("MetaDataExport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
            this.removeLogListner(consoleLogListner);
            MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
            this.addLogListner(loggingListner);
            try {
                this.exportMeta(param);
                Boolean bl = this.isSuccess();
                return bl;
            }
            finally {
                this.removeLogListner(loggingListner);
                this.addLogListner(consoleLogListner);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean silent() {
        Properties prop;
        block64: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                this.logError(this.rs("MetaDataExport.Silent.requiredConfigFileMsg", KEY_CONFIG_FILE));
                return false;
            }
            prop = new Properties();
            try {
                Throwable throwable;
                InputStream is;
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    is = new FileInputStream(path.toFile());
                    throwable = null;
                    try (InputStreamReader reader2 = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader2);
                        break block64;
                    }
                    catch (Throwable reader2) {
                        throwable = reader2;
                        throw reader2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable reader2) {
                                    throwable.addSuppressed(reader2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                is = PackageExport.class.getResourceAsStream(configFileName);
                throwable = null;
                try {
                    if (is == null) {
                        this.logError(this.rs("MetaDataExport.Silent.notExistsConfigFileMsg", configFileName));
                        boolean reader2 = false;
                        return reader2;
                    }
                    try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
        } else {
            String propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", propTenantId));
                return false;
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!propTenantUrl.startsWith("/")) {
                    propTenantUrl = "/" + propTenantUrl;
                }
                if ((tenant = this.ts.getTenant(propTenantUrl)) == null) {
                    this.logError(this.rs("Common.notExistsTenantMsg", propTenantUrl));
                    return false;
                }
            }
            if (tenant == null) {
                this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
                return false;
            }
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        MetaDataExportParameter param = new MetaDataExportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            String source;
            String localOnly;
            File exportDir;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            String exportDirName = prop.getProperty("exportDir");
            if (StringUtil.isNotEmpty((String)exportDirName)) {
                param.setExportDirName(exportDirName);
            }
            if (!this.checkDir(exportDir = new File(param.getExportDirName()))) {
                return false;
            }
            param.setExportDir(exportDir);
            String fileName = prop.getProperty("fileName");
            if (StringUtil.isNotEmpty((String)fileName)) {
                param.setFileName(fileName);
            }
            if (StringUtil.isNotEmpty((String)(localOnly = prop.getProperty("meta.localOnly")))) {
                param.setExportLocalMetaDataOnly(Boolean.valueOf(localOnly));
            }
            if (StringUtil.isEmpty((String)(source = prop.getProperty("meta.source")))) {
                param.setExportAllMetaData(true);
                String excludeTenant = prop.getProperty("meta.excludeTenant");
                if (StringUtil.isNotEmpty((String)excludeTenant)) {
                    param.setExportTenantMetaData(Boolean.valueOf(excludeTenant) == false);
                }
            } else {
                param.setExportAllMetaData(false);
                param.setExportMetaDataPathStr(source);
            }
            param.setExportMetaDataPathList(this.getMetaDataPathList(param));
            this.logArguments(param);
            return this.exportMeta(param);
        });
    }

    private boolean checkDir(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
            this.logInfo(this.rs("MetaDataExport.createdDirMsg", dir.getPath()));
        }
        if (!dir.isDirectory()) {
            this.logError(this.rs("MetaDataExport.notDirMsg", dir.getPath()));
            return false;
        }
        return true;
    }
}

