/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.tools.metaport.MetaDataNameListCsvWriter;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.XMLEntryInfo;
import org.iplass.mtp.impl.tools.pack.PackageService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.metadata.MetaDataNameListExportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;

public class MetaDataNameListExport
extends MtpCuiBase {
    private ExecMode execMode = ExecMode.WIZARD;
    private MetaDataPortingService metaService = (MetaDataPortingService)ServiceRegistry.getRegistry().getService(MetaDataPortingService.class);
    private PackageService packageService = (PackageService)ServiceRegistry.getRegistry().getService(PackageService.class);

    public static void main(String[] args) {
        MetaDataNameListExport instance = null;
        try {
            instance = new MetaDataNameListExport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public MetaDataNameListExport(String ... args) {
        if (args != null && args.length > 0) {
            this.setExecMode(ExecMode.valueOf(args[0]));
        }
    }

    public boolean execute() {
        this.clearLog();
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.addLogListner(consoleLogListner);
        this.logEnvironment();
        switch (this.getExecMode()) {
            case WIZARD: {
                this.logInfo("\u25a0Start Export Wizard");
                this.logInfo("");
                return this.startExportWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Export Silent");
                this.logInfo("");
                return false;
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.getExecMode()));
        return false;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public boolean executeExport(MetaDataNameListExportParameter param) {
        this.setSuccess(false);
        try {
            boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
                File importFile = new File(param.getMetaDataFilePath());
                File outFile = new File(param.getExportDir(), param.getExportFileName() + ".csv");
                TenantContext tContext = new TenantContext(0, "dummy", "/", true);
                ExecuteContext eContext = new ExecuteContext(tContext);
                eContext.setLanguage(this.getLanguage());
                ExecuteContext.initContext((ExecuteContext)eContext);
                InputStream metaXML = null;
                MetaDataNameListCsvWriter wrappedWriter = null;
                try {
                    metaXML = "zip".equals(this.getFileExtension(importFile)) ? this.packageService.getMetaDataInputStream(importFile) : new FileInputStream(importFile);
                    XMLEntryInfo entryInfo = this.metaService.getXMLMetaDataEntryInfo(metaXML);
                    ArrayList entries = new ArrayList(entryInfo.getPathEntryMap().values());
                    Collections.sort(entries, new Comparator<MetaDataEntry>(){

                        @Override
                        public int compare(MetaDataEntry o1, MetaDataEntry o2) {
                            return o1.getPath().toLowerCase().compareTo(o2.getPath().toLowerCase());
                        }
                    });
                    wrappedWriter = new MetaDataNameListCsvWriter((OutputStream)new FileOutputStream(outFile));
                    wrappedWriter.writeHeader();
                    for (MetaDataEntry entry : entries) {
                        wrappedWriter.writeEntry(entry);
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (metaXML != null) {
                            metaXML.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            if (wrappedWriter != null) {
                                wrappedWriter.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            this.setSuccess(isSuccess);
        }
        catch (Throwable e) {
            try {
                this.logError(this.rs("Common.errorMsg", e.getMessage()));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logInfo("");
                this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
                this.logInfo("");
                ExecuteContext.initContext(null);
                throw throwable;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
            this.logInfo("");
            ExecuteContext.initContext(null);
        }
        this.logInfo("");
        this.logInfo("\u25a0Execute Result :" + (this.isSuccess() ? "SUCCESS" : "FAILED"));
        this.logInfo("");
        ExecuteContext.initContext(null);
        return this.isSuccess();
    }

    private boolean startExportWizard() {
        MetaDataNameListExportParameter param = new MetaDataNameListExportParameter();
        boolean validFile = false;
        do {
            String importFileName;
            if (StringUtil.isNotBlank((String)(importFileName = this.readConsole(this.rs("ExportMetaDataNameList.Wizard.inputMetaDataFileMsg", new Object[0]))))) {
                param.setMetaDataFilePath(importFileName);
                File importFile = new File(param.getMetaDataFilePath());
                if (!importFile.exists()) {
                    this.logWarn(this.rs("ExportMetaDataNameList.Wizard.notExistsMetaDataFileMsg", new Object[0]));
                    continue;
                }
                if (importFile.isDirectory()) {
                    this.logWarn(this.rs("ExportMetaDataNameList.Wizard.notFileMsg", param.getMetaDataFilePath()));
                    continue;
                }
                validFile = true;
                continue;
            }
            this.logWarn(this.rs("ExportMetaDataNameList.Wizard.requiredMetaDataFilePathMsg", new Object[0]));
        } while (!validFile);
        boolean validExportDir = false;
        do {
            File exportDir;
            String exportDirName;
            if (StringUtil.isNotBlank((String)(exportDirName = this.readConsole(this.rs("ExportMetaDataNameList.Wizard.inputDirMsg", new Object[0]) + "(" + param.getExportDirName() + ")")))) {
                param.setExportDirName(exportDirName);
            }
            if (!(exportDir = new File(param.getExportDirName())).exists()) {
                exportDir.mkdir();
                this.logInfo(this.rs("ExportMetaDataNameList.Wizard.createdInputDirMsg", param.getExportDirName()));
            }
            if (!exportDir.isDirectory()) {
                this.logWarn(this.rs("ExportMetaDataNameList.Wizard.notDirMsg", param.getExportDirName()));
                continue;
            }
            param.setExportDir(exportDir);
            validExportDir = true;
        } while (!validExportDir);
        String exportFileName = this.readConsole(this.rs("ExportMetaDataNameList.Wizard.inputFileNameMsg", new Object[0]) + "(" + param.getExportFileName() + ")");
        if (StringUtil.isNotBlank((String)exportFileName)) {
            param.setExportFileName(exportFileName);
        }
        MtpCuiBase.LogListner consoleLogListner = this.getConsoleLogListner();
        this.removeLogListner(consoleLogListner);
        MtpCuiBase.LogListner loggingListner = this.getLoggingLogListner();
        this.addLogListner(loggingListner);
        boolean ret = this.executeExport(param);
        this.removeLogListner(loggingListner);
        return ret;
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") > 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }
}

