/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.storagespace;

import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.tools.storagespace.StorageSpaceService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageSpaceCleaner
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(StorageSpaceCleaner.class);
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static StorageSpaceService storageSpaceService = (StorageSpaceService)ServiceRegistry.getRegistry().getService(StorageSpaceService.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private String entityName;
    private String storageSpaceName;

    public StorageSpaceCleaner(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(Integer.parseInt(args[1]));
            }
            if (args.length > 2) {
                this.setEntityName(args[2]);
            }
            if (args.length > 3) {
                this.setStorageSpaceName(args[3]);
            }
        }
    }

    public static void main(String[] args) {
        try {
            new StorageSpaceCleaner(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setStorageSpaceName(String storageSpaceName) {
        this.storageSpaceName = storageSpaceName;
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.executeTask(null, param -> this.proceed());
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.setTenantId(Integer.parseInt(tenantId));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("StorageSpaceCleaner.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        boolean validEntityName = false;
        do {
            String entityName;
            if (!StringUtil.isNotBlank((String)(entityName = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.entityNameMsg", new Object[0]))))) continue;
            this.setEntityName(entityName);
            validEntityName = true;
        } while (!validEntityName);
        boolean validStorageSpaceName = false;
        do {
            String storageSpaceName;
            if (!StringUtil.isNotBlank((String)(storageSpaceName = this.readConsole(this.rs("StorageSpaceCleaner.Wizard.storageSpaceNameMsg", new Object[0]))))) continue;
            this.setStorageSpaceName(storageSpaceName);
            validStorageSpaceName = true;
        } while (!validStorageSpaceName);
        this.switchLog(false, true);
        return this.executeTask(null, param -> this.proceed());
    }

    private boolean proceed() {
        this.setSuccess(false);
        TenantContext tc = tenantContextService.getTenantContext(this.tenantId);
        if (tc == null) {
            this.logError(this.rs("StorageSpaceCleaner.notFoundTenant", this.tenantId));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            EntityHandler entityHandler = (EntityHandler)MetaDataContext.getContext().getMetaDataHandler(EntityHandler.class, "/entity/" + this.entityName.replace(".", "/"));
            if (entityHandler == null) {
                this.logError(this.rs("StorageSpaceCleaner.notFoundEntity", this.entityName));
                return this.isSuccess();
            }
            try {
                storageSpaceService.cleanup(this.tenantId, this.storageSpaceName, entityHandler.getMetaData());
            }
            catch (Exception e) {
                this.logError(this.rs("StorageSpaceCleaner.failedCleanup", new Object[0]), e);
                return this.isSuccess();
            }
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

