/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.partition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.rdb.postgresql.PostgreSQLRdbAdapter;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.partition.MySQLPartitionBatch;
import org.iplass.mtp.tools.batch.partition.PostgreSQLPartitionBatch;
import org.iplass.mtp.tools.batch.tenant.TenantBatch;
import org.iplass.mtp.tools.gui.MtpJDialogBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCreateDialog
extends MtpJDialogBase {
    private static final long serialVersionUID = 3059528383221001309L;
    private static Logger logger = LoggerFactory.getLogger(PartitionCreateDialog.class);
    private JTextField txtMaxTenantId;
    private JTextField txtSubPartitionSize;
    private JButton btnCreate;
    private JButton btnCancel;
    private JTextArea txtMessageArea;
    private List<ChangeListener> dataChangeListners = new ArrayList<ChangeListener>();
    private final RdbAdapter adapter = ((RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class)).getRdbAdapter();

    public PartitionCreateDialog(Frame owner) {
        super(owner);
        this.createDialog();
    }

    public void addPartitionDataChangeListner(ChangeListener listner) {
        this.dataChangeListners.add(listner);
    }

    private void createDialog() {
        this.setTitle("Create Partition");
        this.setBounds(64, 64, 300, 500);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        JPanel mainPane = new JPanel();
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.createInfoPane(), "North");
        mainPane.add((Component)this.createInputPane(), "Center");
        mainPane.add((Component)this.createFooterPane(), "South");
        this.getContentPane().add((Component)mainPane, "North");
        this.getContentPane().add((Component)this.createMessagePane(), "Center");
        this.pack();
    }

    private JPanel createInfoPane() {
        JPanel infoPane = new JPanel();
        infoPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        infoPane.setLayout(new BorderLayout(5, 5));
        JPanel messagePane = new JPanel();
        messagePane.setLayout(new BoxLayout(messagePane, 1));
        JLabel lblInfo1 = new JLabel(this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.createPartitionLabel", new Object[0]));
        messagePane.add(lblInfo1);
        JLabel lblInfo2 = new JLabel(this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.warnAlterTablePermissionLabel", new Object[0]));
        lblInfo2.setForeground(Color.RED);
        messagePane.add(lblInfo2);
        JLabel lblDummy = new JLabel();
        messagePane.add(lblDummy);
        infoPane.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), "West");
        infoPane.add((Component)messagePane, "Center");
        return infoPane;
    }

    private JPanel createInputPane() {
        JPanel inputPane = new JPanel();
        inputPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        inputPane.setLayout(gridbag);
        constraints.gridx = 1;
        constraints.gridheight = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 3;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 5;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        JLabel lblMaxTenantId = new JLabel("Max Tenant ID");
        this.txtMaxTenantId = new JTextField();
        this.txtMaxTenantId.setPreferredSize(new Dimension(200, 25));
        this.createLableText(lblMaxTenantId, this.txtMaxTenantId, null, 0, gridbag, constraints, inputPane);
        if (this.adapter instanceof PostgreSQLRdbAdapter) {
            JLabel lblSubPartitionSize = new JLabel("SubPartition Size");
            this.txtSubPartitionSize = new JTextField();
            this.txtSubPartitionSize.setPreferredSize(new Dimension(200, 25));
            this.txtSubPartitionSize.setText(String.valueOf(8));
            this.createLableText(lblSubPartitionSize, this.txtSubPartitionSize, null, 1, gridbag, constraints, inputPane);
        }
        return inputPane;
    }

    protected void createLableText(JComponent label, JComponent text, JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        gridbag.setConstraints(label, constraints);
        pane.add(label);
        constraints.gridx = 2;
        constraints.gridheight = 1;
        gridbag.setConstraints(text, constraints);
        pane.add(text);
        if (check != null) {
            constraints.gridx = 4;
            constraints.gridheight = 1;
            gridbag.setConstraints(check, constraints);
            pane.add(check);
        }
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    protected void createCheckBoxRow(JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        gridbag.setConstraints(check, constraints);
        pane.add(check);
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    private JPanel createFooterPane() {
        JPanel footerPane = new JPanel();
        footerPane.setLayout(new FlowLayout(1));
        this.btnCreate = new JButton("Create");
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Integer.parseInt(PartitionCreateDialog.this.txtMaxTenantId.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.inputMaxTenantIdMsg", new Object[0]), "ERROR", 0);
                    return;
                }
                if (PartitionCreateDialog.this.txtSubPartitionSize != null) {
                    String strSubPartitionSize = PartitionCreateDialog.this.txtSubPartitionSize.getText().trim();
                    if (strSubPartitionSize.isEmpty()) {
                        JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("PartitionManagerApp.PartitionCreateDialog.inputSubPartitionSizeMsg", new Object[0]), "ERROR", 0);
                        return;
                    }
                    try {
                        int subPartitionSize = Integer.parseInt(strSubPartitionSize);
                        if (subPartitionSize < 0) {
                            JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("PartitionManagerApp.PartitionCreateDialog.invalidValueSubPartitionSizeMsg", new Object[]{0}), "ERROR", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("PartitionManagerApp.PartitionCreateDialog.invalidSubPartitionSizeMsg", new Object[0]), "ERROR", 0);
                        return;
                    }
                }
                if (JOptionPane.showConfirmDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.confirmCreatePartitionMsg", new Object[0]), "CONFIRM", 0, 3) != 0) {
                    return;
                }
                PartitionCreateDialog.this.createPartition();
            }
        });
        footerPane.add(this.btnCreate);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setDefaultCapable(true);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCreateDialog.this.setVisible(false);
                PartitionCreateDialog.this.dispose();
            }
        });
        footerPane.add(this.btnCancel);
        return footerPane;
    }

    private JTabbedPane createMessagePane() {
        JTabbedPane tabMessagePane = new JTabbedPane(1);
        tabMessagePane.setTabLayoutPolicy(1);
        JScrollPane sclMessagePane = new JScrollPane();
        this.txtMessageArea = new JTextArea();
        this.txtMessageArea.setEditable(false);
        this.txtMessageArea.setFont(new Font(this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.messageFont", new Object[0]), 0, 10));
        this.txtMessageArea.setRows(20);
        sclMessagePane.setViewportView(this.txtMessageArea);
        tabMessagePane.addTab("Log", sclMessagePane);
        return tabMessagePane;
    }

    private void createPartition() {
        this.btnCreate.setText("create...");
        this.btnCreate.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.txtMessageArea.setText("");
        CreatePartitionWorker worker = new CreatePartitionWorker();
        worker.execute();
    }

    private PartitionCreateParameter createParameter() {
        PartitionCreateParameter param = new PartitionCreateParameter();
        param.setOnlyPartitionCreate(true);
        int tenantId = Integer.parseInt(this.txtMaxTenantId.getText());
        param.setTenantId(tenantId);
        if (this.txtSubPartitionSize != null) {
            param.setSubPartitionSize(Integer.parseInt(this.txtSubPartitionSize.getText().trim()));
        }
        return param;
    }

    private void addLog(String log) {
        this.txtMessageArea.append(log + "\n");
    }

    private void firePartitionDataChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listner : this.dataChangeListners) {
            listner.stateChanged(e);
        }
    }

    private class CreatePartitionWorker
    extends SwingWorker<Boolean, String> {
        private CreatePartitionWorker() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            MtpCuiBase.LogListener listener = null;
            try {
                MtpCuiBase manager = null;
                if (PartitionCreateDialog.this.adapter instanceof MysqlRdbAdaptor) {
                    manager = new MySQLPartitionBatch(TenantBatch.TenantBatchExecMode.CREATE.name());
                }
                if (PartitionCreateDialog.this.adapter instanceof PostgreSQLRdbAdapter) {
                    manager = new PostgreSQLPartitionBatch(TenantBatch.TenantBatchExecMode.CREATE.name());
                }
                listener = new MtpCuiBase.LogListener(){

                    @Override
                    public void info(String message) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.info(message);
                    }

                    @Override
                    public void warn(String message) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.warn(message);
                    }

                    @Override
                    public void error(String message) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.error(message);
                    }

                    @Override
                    public void info(String message, Throwable e) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.info(message, e);
                    }

                    @Override
                    public void warn(String message, Throwable e) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.warn(message, e);
                    }

                    @Override
                    public void error(String message, Throwable e) {
                        CreatePartitionWorker.this.publish(new String[]{message});
                        logger.error(message, e);
                    }
                };
                manager.addLogListner(listener);
                this.publish(PartitionCreateDialog.this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.startCreatePartitionLog", new Object[0]));
                manager.createPartition(PartitionCreateDialog.this.createParameter());
                listener.info("");
                listener.info("\u25a0Execute Result : SUCCESS");
                listener.info("");
            }
            catch (Exception e) {
                listener.error(PartitionCreateDialog.this.rs("Common.errorMsg", new Object[]{e.getMessage()}), e);
                listener.info("");
                listener.error("\u25a0Execute Result : FAILED");
                listener.info("");
                throw e;
            }
            return true;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String message : chunks) {
                PartitionCreateDialog.this.addLog(message);
            }
        }

        @Override
        protected void done() {
            try {
                Boolean isSuccess = (Boolean)this.get();
                if (isSuccess.booleanValue()) {
                    JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("MySQLPartitionManagerApp.PartitionCreateDialog.createCompleteMsg", new Object[0]), "INFO", 1);
                    PartitionCreateDialog.this.firePartitionDataChanged();
                } else {
                    JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(PartitionCreateDialog.this, PartitionCreateDialog.this.rs("Common.errorMsg", new Object[]{e.getMessage()}), "ERROR", 0);
            }
            PartitionCreateDialog.this.btnCreate.setText("Create");
            PartitionCreateDialog.this.btnCreate.setEnabled(true);
            PartitionCreateDialog.this.btnCancel.setEnabled(true);
        }
    }
}

