/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.tenant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.tools.tenant.TenantDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.tenant.TenantBatch;
import org.iplass.mtp.tools.gui.MtpJDialogBase;
import org.iplass.mtp.tools.gui.tenant.TenantDialogTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantDeleteDialog
extends MtpJDialogBase {
    private static final long serialVersionUID = 4144178376940227935L;
    private static Logger logger = LoggerFactory.getLogger(TenantDeleteDialog.class);
    private TenantDialogTableModel model;
    private JButton btnDelete;
    private JButton btnCancel;
    private JTextArea txtMessageArea;
    private List<ChangeListener> dataChangeListners = new ArrayList<ChangeListener>();

    public TenantDeleteDialog(Frame owner) {
        super(owner);
        this.createDialog();
    }

    public void addTenantDataChangeListner(ChangeListener listner) {
        this.dataChangeListners.add(listner);
    }

    public void setTenantInfo(List<TenantInfo> infos) {
        this.model.setTenantData(infos);
        this.model.fireTableDataChanged();
    }

    private void createDialog() {
        this.setTitle("Remove Tenant");
        this.setBounds(64, 64, 300, 310);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        JPanel mainPane = new JPanel();
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPane.setPreferredSize(new Dimension(500, 300));
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.createInfoPane(), "North");
        mainPane.add((Component)this.createListPane(), "Center");
        mainPane.add((Component)this.createFooterPane(), "South");
        this.getContentPane().add((Component)mainPane, "North");
        this.getContentPane().add((Component)this.createMessagePane(), "Center");
        this.pack();
    }

    private JPanel createInfoPane() {
        JPanel infoPane = new JPanel();
        infoPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        infoPane.setLayout(new BorderLayout(5, 5));
        JPanel messagePane = new JPanel();
        messagePane.setLayout(new BoxLayout(messagePane, 1));
        JLabel lblInfo1 = new JLabel(this.rs("TenantManagerApp.TenantDeleteDialog.removeTenantLabel", new Object[0]));
        messagePane.add(lblInfo1);
        JLabel lblInfo2 = new JLabel(this.rs("TenantManagerApp.TenantDeleteDialog.warnTrancateLabel", new Object[0]));
        lblInfo2.setForeground(Color.RED);
        messagePane.add(lblInfo2);
        RdbAdapterService adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
        RdbAdapter adapter = adapterService.getRdbAdapter();
        if (adapter instanceof MysqlRdbAdaptor) {
            JLabel lblInfo3 = new JLabel(this.rs("TenantManagerApp.TenantDeleteDialog.warnAlterTablePermissionLabel", new Object[0]));
            lblInfo3.setForeground(Color.RED);
            messagePane.add(lblInfo3);
        }
        JLabel lblDummy = new JLabel();
        messagePane.add(lblDummy);
        infoPane.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), "West");
        infoPane.add((Component)messagePane, "Center");
        return infoPane;
    }

    private JPanel createListPane() {
        JPanel listPane = new JPanel();
        listPane.setLayout(new BorderLayout());
        listPane.add((Component)this.createTenantTablePane(), "Center");
        listPane.add((Component)this.createInputPane(), "South");
        return listPane;
    }

    private JScrollPane createTenantTablePane() {
        JScrollPane scrlTenantList = new JScrollPane();
        this.model = new TenantDialogTableModel();
        JTable tblTenantList = new JTable(this.model){};
        tblTenantList.setAutoResizeMode(3);
        scrlTenantList.setViewportView(tblTenantList);
        return scrlTenantList;
    }

    protected JPanel createInputPane() {
        JPanel inputPane = new JPanel();
        inputPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        inputPane.setLayout(gridbag);
        constraints.gridx = 1;
        constraints.gridheight = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 3;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        constraints.gridx = 5;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        inputPane.add(dummy);
        return inputPane;
    }

    protected void createLableText(JComponent label, JComponent text, JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        gridbag.setConstraints(label, constraints);
        pane.add(label);
        constraints.gridx = 2;
        constraints.gridheight = 1;
        gridbag.setConstraints(text, constraints);
        pane.add(text);
        if (check != null) {
            constraints.gridx = 4;
            constraints.gridheight = 1;
            gridbag.setConstraints(check, constraints);
            pane.add(check);
        }
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    protected void createCheckBoxRow(JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
        constraints.gridx = 0;
        constraints.gridy = row * 2;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        gridbag.setConstraints(check, constraints);
        pane.add(check);
        constraints.gridx = 0;
        constraints.gridy = row * 2 + 1;
        constraints.gridwidth = 0;
        Box dummy = Box.createHorizontalBox();
        dummy.setPreferredSize(new Dimension(15, 15));
        gridbag.setConstraints(dummy, constraints);
        pane.add(dummy);
    }

    private JPanel createFooterPane() {
        JPanel footerPane = new JPanel();
        footerPane.setLayout(new FlowLayout(1));
        this.btnDelete = new JButton("Remove");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(TenantDeleteDialog.this, TenantDeleteDialog.this.rs("TenantManagerApp.TenantDeleteDialog.confirmRemoveTenantMsg", new Object[0]), "CONFIRM", 0, 3) != 0) {
                    return;
                }
                TenantDeleteDialog.this.deleteTenant();
            }
        });
        footerPane.add(this.btnDelete);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setDefaultCapable(true);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TenantDeleteDialog.this.setVisible(false);
                TenantDeleteDialog.this.dispose();
            }
        });
        footerPane.add(this.btnCancel);
        return footerPane;
    }

    private JTabbedPane createMessagePane() {
        JTabbedPane tabMessagePane = new JTabbedPane(1);
        tabMessagePane.setTabLayoutPolicy(1);
        JScrollPane sclMessagePane = new JScrollPane();
        this.txtMessageArea = new JTextArea();
        this.txtMessageArea.setEditable(false);
        this.txtMessageArea.setFont(new Font(this.rs("TenantManagerApp.TenantDeleteDialog.messageFont", new Object[0]), 0, 10));
        this.txtMessageArea.setRows(10);
        sclMessagePane.setViewportView(this.txtMessageArea);
        tabMessagePane.addTab("Log", sclMessagePane);
        return tabMessagePane;
    }

    private void deleteTenant() {
        this.btnDelete.setText("remove...");
        this.btnDelete.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.txtMessageArea.setText("");
        DeleteTenantWorker worker = new DeleteTenantWorker();
        worker.execute();
    }

    private TenantDeleteParameter createParameter(TenantInfo tenant) {
        TenantDeleteParameter param = new TenantDeleteParameter();
        param.setTenantId(tenant.getId());
        param.setTenantName(tenant.getName());
        return param;
    }

    private void addLog(String log) {
        this.txtMessageArea.append(log + "\n");
    }

    private void fireTenantDataChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listner : this.dataChangeListners) {
            listner.stateChanged(e);
        }
    }

    private class DeleteTenantWorker
    extends SwingWorker<Boolean, String> {
        private DeleteTenantWorker() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            TenantBatch manager = null;
            MtpCuiBase.LogListener listener = null;
            try {
                manager = new TenantBatch(TenantBatch.TenantBatchExecMode.DELETE.name());
                listener = new MtpCuiBase.LogListener(){

                    @Override
                    public void info(String message) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.info(message);
                    }

                    @Override
                    public void warn(String message) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.warn(message);
                    }

                    @Override
                    public void error(String message) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.error(message);
                    }

                    @Override
                    public void info(String message, Throwable e) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.info(message, e);
                    }

                    @Override
                    public void warn(String message, Throwable e) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.warn(message, e);
                    }

                    @Override
                    public void error(String message, Throwable e) {
                        DeleteTenantWorker.this.publish(new String[]{message});
                        logger.error(message, e);
                    }
                };
                manager.addLogListner(listener);
                List<TenantInfo> tenants = TenantDeleteDialog.this.model.getTenantInfos();
                for (TenantInfo tenant : tenants) {
                    this.publish(TenantDeleteDialog.this.rs("TenantManagerApp.TenantDeleteDialog.removeStartLog", new Object[]{tenant.getName(), tenant.getId()}));
                    boolean ret = manager.executeDelete(TenantDeleteDialog.this.createParameter(tenant));
                    if (ret) continue;
                    return ret;
                }
                listener.info("");
                listener.info("\u25a0Execute Result : SUCCESS");
                listener.info("");
            }
            catch (Exception e) {
                listener.error(TenantDeleteDialog.this.rs("Common.errorMsg", new Object[]{e.getMessage()}), e);
                listener.info("");
                listener.error("\u25a0Execute Result : FAILED");
                listener.info("");
                throw e;
            }
            return true;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String message : chunks) {
                TenantDeleteDialog.this.addLog(message);
            }
        }

        @Override
        protected void done() {
            try {
                Boolean isSuccess = (Boolean)this.get();
                if (isSuccess.booleanValue()) {
                    JOptionPane.showMessageDialog(TenantDeleteDialog.this, TenantDeleteDialog.this.rs("TenantManagerApp.TenantDeleteDialog.removeCompleteMsg", new Object[0]), "INFO", 1);
                    TenantDeleteDialog.this.fireTenantDataChanged();
                } else {
                    JOptionPane.showMessageDialog(TenantDeleteDialog.this, TenantDeleteDialog.this.rs("Common.errorMsg", new Object[0]), "ERROR", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TenantDeleteDialog.this, TenantDeleteDialog.this.rs("Common.errorMsg", new Object[]{e.getMessage()}), "ERROR", 0);
            }
            TenantDeleteDialog.this.btnDelete.setText("Remove");
            TenantDeleteDialog.this.btnDelete.setEnabled(true);
            TenantDeleteDialog.this.btnCancel.setEnabled(true);
        }
    }
}

