/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.cleaner;

import java.util.List;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpSilentBatch;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProviderCleaner
extends MtpSilentBatch {
    private static Logger logger = LoggerFactory.getLogger(AuthProviderCleaner.class);
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static AuthService authService = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
    private int tenantId;

    public static void main(String[] args) throws Exception {
        int tenantId = -1;
        if (args != null && args.length > 0 && StringUtil.isNotEmpty((String)args[0])) {
            tenantId = Integer.parseInt(args[0]);
        }
        if (tenantId >= 0) {
            new AuthProviderCleaner(tenantId).clean();
        } else {
            List<TenantInfo> tenants = AuthProviderCleaner.getValidTenantInfoList();
            if (tenants != null) {
                for (TenantInfo t : tenants) {
                    new AuthProviderCleaner(t.getId()).clean();
                }
            }
        }
    }

    public AuthProviderCleaner(int tenantId) {
        this.setTenantId(tenantId);
    }

    public boolean clean() throws Exception {
        this.setSuccess(false);
        this.clearLog();
        return this.executeTask(null, param -> (Boolean)ExecuteContext.executeAs((TenantContext)tenantContextService.getTenantContext(this.tenantId), () -> {
            this.logArguments();
            AuthenticationProvider[] aps = authService.getAuthenticationProviders();
            if (aps != null) {
                AuthenticationProvider[] authenticationProviderArray = aps;
                int n = authenticationProviderArray.length;
                for (int i = 0; i < n; ++i) {
                    AuthenticationProvider ap;
                    AuthenticationProvider apFinal = ap = authenticationProviderArray[i];
                    Transaction.required(t -> {
                        apFinal.cleanupData();
                        return null;
                    });
                }
            }
            this.setSuccess(true);
            return this.isSuccess();
        }));
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.getTenantId());
        this.logInfo("");
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

