/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.cleaner;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.tools.clean.RecycleBinCleanService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpSilentBatch;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbCleaner
extends MtpSilentBatch {
    private static Logger logger = LoggerFactory.getLogger(RbCleaner.class);
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityService entityHandlerService = (EntityService)ServiceRegistry.getRegistry().getService(EntityService.class);
    private RecycleBinCleanService recycleBinCleanService = (RecycleBinCleanService)ServiceRegistry.getRegistry().getService(RecycleBinCleanService.class);
    private int tenantId;

    public static void main(String[] args) throws Exception {
        int tenantId = -1;
        Calendar cal = Calendar.getInstance();
        cal.add(5, -entityHandlerService.getPurgeTargetDate());
        Timestamp purgeTargetDate = new Timestamp(cal.getTimeInMillis());
        if (args != null && args.length > 0 && StringUtil.isNotEmpty((String)args[0])) {
            tenantId = Integer.parseInt(args[0]);
        }
        if (tenantId >= 0) {
            new RbCleaner(tenantId).clean(purgeTargetDate);
        } else {
            List<TenantInfo> tenants = RbCleaner.getValidTenantInfoList();
            if (tenants != null) {
                for (TenantInfo t : tenants) {
                    new RbCleaner(t.getId()).clean(purgeTargetDate);
                }
            }
        }
    }

    public RbCleaner(int tenantId) {
        this.setTenantId(tenantId);
    }

    public boolean clean(Timestamp purgeTargetDate) throws Exception {
        this.setSuccess(false);
        this.clearLog();
        return this.executeTask(null, param -> (Boolean)ExecuteContext.executeAs((TenantContext)tenantContextService.getTenantContext(this.tenantId), () -> {
            this.logArguments();
            this.recycleBinCleanService.clean(purgeTargetDate, null);
            this.setSuccess(true);
            return this.isSuccess();
        }));
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.getTenantId());
        this.logInfo("");
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

