/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.config;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.core.config.ServiceDefinition;
import org.iplass.mtp.impl.core.config.ServiceDefinitionParser;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public class ServiceConfigViewer {
    private Mode mode = Mode.PARSE_ONLY;
    private String configFileName = null;
    private String outputFileName = null;

    public ServiceConfigViewer(String[] args) {
        for (int i = 0; i < args.length; i += 2) {
            if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
            if (Option.MODE.value.equals(args[i])) {
                this.mode = Mode.valueOf(args[i + 1]);
                continue;
            }
            if (!Option.OUT_FILE.value.equals(args[i])) continue;
            this.outputFileName = args[i + 1];
        }
        this.configFileName = BootstrapProps.getInstance().getProperty("mtp.config", "/mtp-service-config.xml");
    }

    public static void main(String ... args) {
        try {
            new ServiceConfigViewer(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean execute() throws Exception {
        return this.proceed();
    }

    private boolean proceed() {
        boolean isSuccess = false;
        Writer writer = null;
        boolean toFile = StringUtil.isNotBlank((String)this.outputFileName);
        try {
            ServiceDefinitionParser parser = new ServiceDefinitionParser();
            ServiceDefinition sd = parser.read(this.configFileName);
            if (this.mode.equals((Object)Mode.PARSE_LOAD)) {
                BootstrapProps.getInstance().setProperty("mtp.config", this.configFileName);
                Stream.of(sd.getService()).forEach(sc -> {
                    if (sc.getName() != null) {
                        ServiceRegistry.getRegistry().getService(sc.getName());
                    } else {
                        ServiceRegistry.getRegistry().getService(sc.getInterfaceName());
                    }
                });
            }
            writer = toFile ? Files.newBufferedWriter(Paths.get(this.outputFileName, new String[0]), new OpenOption[0]) : (System.console() != null ? System.console().writer() : new OutputStreamWriter(System.out));
            sd.setIncludes(null);
            sd.setInherits(null);
            this.writeMergedServiceConfig(sd, writer);
            isSuccess = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    if (toFile) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    private void writeMergedServiceConfig(ServiceDefinition sd, Writer writer) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)sd, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum Mode {
        PARSE_ONLY,
        PARSE_LOAD;

    }

    private static enum Option {
        MODE("-m"),
        OUT_FILE("-o");

        private final String value;

        private Option(String value) {
            this.value = value;
        }
    }
}

