/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.pack.PackageCreateCondition;
import org.iplass.mtp.impl.tools.pack.PackageCreateResult;
import org.iplass.mtp.impl.tools.pack.PackageService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.pack.PackageExportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageExport
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(PackageExport.class);
    public static final String KEY_CONFIG_FILE = "pack.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private PackageService ps = (PackageService)ServiceRegistry.getRegistry().getService(PackageService.class);
    private MetaDataPortingService mdps = (MetaDataPortingService)ServiceRegistry.getRegistry().getService(MetaDataPortingService.class);
    private EntityService ehs = (EntityService)ServiceRegistry.getRegistry().getService(EntityService.class);
    private Integer tenantId;

    public static void main(String[] args) {
        PackageExport instance = null;
        try {
            instance = new PackageExport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            ExecuteContext.finContext();
        }
    }

    public PackageExport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Export Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Export Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    public PackageExport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public PackageExport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public boolean exportPack(PackageExportParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required(t -> {
            TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
            return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
                ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
                if (param.isExportMetaData() && param.getExportMetaDataPathList() == null) {
                    param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                }
                if (param.isExportEntityData() && param.getExportEntityDataPathList() == null) {
                    param.setExportEntityDataPathList(this.getEntityDataPathList(param));
                }
                PackageCreateCondition cond = new PackageCreateCondition();
                cond.setName(param.getPackageName());
                cond.setMetaDataPaths(param.getExportMetaDataPathList());
                cond.setEntityPaths(param.getExportEntityDataPathList());
                ArrayList<String> messageSummary = new ArrayList<String>();
                PackageCreateResult result = null;
                String fileName = null;
                if (param.isSavePackage()) {
                    String oid = (String)Transaction.requiresNew(tt -> this.ps.storePackage(cond, "30"));
                    String infoMsg = this.rs("PackageExport.createdPackageInfoLog", oid);
                    this.logInfo(infoMsg);
                    messageSummary.add(infoMsg);
                    this.logInfo(this.rs("PackageExport.startExportPackageLog", new Object[0]));
                    result = (PackageCreateResult)Transaction.requiresNew(tt -> this.ps.archivePackage(oid));
                    if (!result.isError() && param.isSavePackage()) {
                        fileName = (String)Transaction.requiresNew(tt -> this.createExportFile(param, oid));
                    }
                } else {
                    this.logInfo(this.rs("PackageExport.startExportPackageLog", new Object[0]));
                    File file = new File(param.getExportDir(), param.getPackageName() + ".zip");
                    try (FileOutputStream os = new FileOutputStream(file);){
                        PackageCreateResult resultWork = result = new PackageCreateResult();
                        Transaction.requiresNew(tt -> this.ps.write(os, cond, resultWork, null));
                        fileName = file.getAbsolutePath();
                    }
                    catch (IOException e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                if (result.isError()) {
                    if (result.getMessages() != null) {
                        for (String message : result.getMessages()) {
                            this.logError(message);
                        }
                        this.logInfo("");
                    }
                    this.logError(this.rs("Common.errorMsg", ""));
                    return false;
                }
                if (result.getMessages() != null) {
                    for (String message : result.getMessages()) {
                        this.logInfo(message);
                        messageSummary.add(message);
                    }
                    this.logInfo("");
                }
                this.logInfo("-----------------------------------------------------------");
                this.logInfo("\u25a0Execute Result Summary");
                for (String message : messageSummary) {
                    this.logInfo(message);
                }
                this.logInfo("-----------------------------------------------------------");
                this.logInfo("");
                this.logInfo(this.rs("PackageExport.completedExportPackageLog", fileName));
                return true;
            });
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(PackageExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\texport dir :" + param.getExportDirName());
        this.logInfo("\tpackage name :" + param.getPackageName());
        this.logInfo("\tsave package :" + param.isSavePackage());
        this.logInfo("\texport metadata :" + param.isExportMetaData());
        if (param.isExportMetaData()) {
            String metaTarget = null;
            if (param.isExportAllMetaData()) {
                metaTarget = "ALL";
                metaTarget = param.isExportTenantMetaData() ? metaTarget + "(include Tenant)" : metaTarget + "(exclude Tenant)";
            } else {
                metaTarget = param.getExportMetaDataPathStr();
            }
            metaTarget = metaTarget + "(" + param.getExportMetaDataPathList().size() + ")";
            this.logInfo("\tmetadata target :" + metaTarget);
        }
        this.logInfo("\texport entity data :" + param.isExportEntityData());
        if (param.isExportEntityData()) {
            String entityTarget = null;
            if (param.isExportAllEntityData()) {
                entityTarget = "ALL";
                entityTarget = param.isExportUserEntityData() ? entityTarget + "(include User)" : entityTarget + "(exclude User)";
            } else {
                entityTarget = param.getExportEntityDataPathStr();
            }
            entityTarget = entityTarget + "(" + param.getExportEntityDataPathList().size() + ")";
            this.logInfo("\tentity target :" + entityTarget);
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private List<String> getMetaDataPathList(PackageExportParameter param) {
        if (!param.isExportMetaData()) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (param.isExportAllMetaData()) {
            List allMeta = MetaDataContext.getContext().definitionList("/");
            for (MetaDataEntryInfo info : allMeta) {
                if (param.isExportLocalMetaDataOnly() && info.getRepositryType() == MetaDataEntry.RepositoryType.SHARED || !param.isExportTenantMetaData() && this.mdps.isTenantMeta(info.getPath())) continue;
                paths.add(info.getPath());
            }
        } else {
            String[] pathStrArray;
            HashSet<String> directPathSet = new HashSet<String>();
            for (String pathStr : pathStrArray = param.getExportMetaDataPathStr().split(",")) {
                if (StringUtil.isEmpty((String)pathStr)) continue;
                if (pathStr.endsWith("*")) {
                    List allMeta = MetaDataContext.getContext().definitionList(pathStr.substring(0, pathStr.length() - 1));
                    for (MetaDataEntryInfo info : allMeta) {
                        if (param.isExportLocalMetaDataOnly() && info.getRepositryType() == MetaDataEntry.RepositoryType.SHARED) continue;
                        directPathSet.add(info.getPath());
                    }
                    continue;
                }
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(pathStr);
                if (entry != null) {
                    if (param.isExportLocalMetaDataOnly() && entry.getRepositryType() == MetaDataEntry.RepositoryType.SHARED) {
                        this.logWarn(this.rs("PackageExport.excludeNotLocalMetaLog", pathStr));
                        continue;
                    }
                    directPathSet.add(entry.getPath());
                    continue;
                }
                this.logWarn(this.rs("PackageExport.notFoundMetaLog", pathStr));
            }
            paths.addAll(directPathSet);
        }
        return paths.stream().sorted().collect(Collectors.toList());
    }

    private void showMetaDataPathList(PackageExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0MetaData List");
        for (String path : param.getExportMetaDataPathList()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    private List<String> getEntityDataPathList(PackageExportParameter param) {
        if (!param.isExportEntityData()) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        List entityList = this.ehs.list();
        if (param.isExportAllEntityData()) {
            for (MetaDataEntryInfo info : entityList) {
                if (!param.isExportUserEntityData() && info.getPath().equals(EntityService.getFixedPath() + "mtp.auth.User")) continue;
                paths.add(info.getPath());
            }
        } else {
            String[] pathStrArray;
            HashSet<String> directPathSet = new HashSet<String>();
            for (String pathStr : pathStrArray = param.getExportEntityDataPathStr().split(",")) {
                if (StringUtil.isEmpty((String)pathStr)) continue;
                boolean isFound = false;
                if (pathStr.endsWith("*")) {
                    String prefixPath = null;
                    prefixPath = pathStr.equals("*") ? "" : pathStr.substring(0, pathStr.length() - 1).replace(".", "/");
                    for (MetaDataEntryInfo info : entityList) {
                        if (!info.getPath().startsWith(EntityService.getFixedPath() + prefixPath)) continue;
                        isFound = true;
                        directPathSet.add(info.getPath());
                    }
                } else {
                    for (MetaDataEntryInfo info : entityList) {
                        String entityPath = EntityService.getFixedPath() + pathStr.replace(".", "/");
                        if (!info.getPath().equals(entityPath)) continue;
                        directPathSet.add(info.getPath());
                        isFound = true;
                        break;
                    }
                }
                if (isFound) continue;
                this.logWarn(this.rs("PackageExport.notFoundEntityLog", pathStr));
            }
            paths.addAll(directPathSet);
        }
        List excludePaths = this.ps.getNonSupportEntityPathList();
        return paths.stream().filter(path -> excludePaths == null || !excludePaths.contains(path)).sorted().collect(Collectors.toList());
    }

    private void showEntityDataPathList(PackageExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0EntityData List");
        for (String path : param.getExportEntityDataPathList()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createExportFile(PackageExportParameter param, String oid) {
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity entity = em.load(oid, "mtp.maintenance.Package");
        if (entity == null) {
            throw new SystemException(this.rs("PackageExport.notFoundPackageInfoLog", oid));
        }
        BinaryReference binaryReference = (BinaryReference)entity.getValue("archive");
        if (binaryReference == null) {
            throw new SystemException(this.rs("PackageExport.notFoundPackageInfoLog", oid));
        }
        InputStream is = null;
        OutputStream os = null;
        String fileName = null;
        try {
            is = em.getInputStream(binaryReference);
            if (is == null) {
                throw new SystemException(this.rs("PackageExport.notFoundPackageInfoLog", oid));
            }
            File file = new File(param.getExportDir(), param.getPackageName() + ".zip");
            os = new FileOutputStream(file);
            fileName = file.getAbsolutePath();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return fileName;
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                        os = null;
                    }
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
    }

    private boolean wizard() {
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                this.tenantId = null;
                return this.wizard();
            }
        } else {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            String url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            tenant = this.ts.getTenant(url);
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        PackageExportParameter param = new PackageExportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validFile = false;
            do {
                File dir;
                String exportDirName;
                if (StringUtil.isNotBlank((String)(exportDirName = this.readConsole(this.rs("PackageExport.Wizard.inputDirMsg", new Object[0]) + "(" + param.getExportDirName() + ")")))) {
                    param.setExportDirName(exportDirName);
                }
                if (!this.checkDir(dir = new File(param.getExportDirName()))) continue;
                param.setExportDir(dir);
                validFile = true;
            } while (!validFile);
            String packageName = this.readConsole(this.rs("PackageExport.Wizard.inputPackageNameMsg", new Object[0]) + "(" + param.getPackageName() + ")");
            if (StringUtil.isNotBlank((String)packageName)) {
                param.setPackageName(packageName);
            }
            boolean isSavePackage = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmSavePackageMsg", new Object[0]), param.isSavePackage());
            param.setSavePackage(isSavePackage);
            boolean validTarget = false;
            do {
                boolean isContinue;
                boolean validMetaData = false;
                do {
                    boolean isExportMeta = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmExportMetaMsg", new Object[0]), param.isExportMetaData());
                    param.setExportMetaData(isExportMeta);
                    if (isExportMeta) {
                        boolean isExportLocalOnly = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmTargetLocalMetaMsg", new Object[0]), param.isExportLocalMetaDataOnly());
                        param.setExportLocalMetaDataOnly(isExportLocalOnly);
                        boolean isExportAllMeta = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmExportAllMetaMsg", new Object[0]), param.isExportAllMetaData());
                        param.setExportAllMetaData(isExportAllMeta);
                        if (isExportAllMeta) {
                            boolean isExportTenantMetaData = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmIncludeTenantMetaMsg", new Object[0]), param.isExportTenantMetaData());
                            param.setExportTenantMetaData(isExportTenantMetaData);
                            validMetaData = true;
                        } else {
                            String exportMetaDataPathStr = this.readConsole(this.rs("PackageExport.Wizard.inputMetaPathMsg", new Object[0]));
                            if (StringUtil.isEmpty((String)exportMetaDataPathStr)) {
                                this.logWarn(this.rs("PackageExport.Wizard.requiredMetaPathMsg", new Object[0]));
                                this.logInfo("");
                            } else {
                                param.setExportMetaDataPathStr(exportMetaDataPathStr);
                                validMetaData = true;
                            }
                        }
                        if (!validMetaData) continue;
                        param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                        boolean isShow = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmShowMetaListMsg", param.getExportMetaDataPathList().size()), false);
                        if (isShow) {
                            this.showMetaDataPathList(param);
                        }
                        if (isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true)) continue;
                        validMetaData = false;
                        continue;
                    }
                    validMetaData = true;
                } while (!validMetaData);
                boolean validEntityData = false;
                do {
                    boolean isExportEntity = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmExportEntityMsg", new Object[0]), param.isExportEntityData());
                    param.setExportEntityData(isExportEntity);
                    if (isExportEntity) {
                        boolean isExportAllEntity = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmExportAllEntityMsg", new Object[0]), param.isExportAllEntityData());
                        param.setExportAllEntityData(isExportAllEntity);
                        if (isExportAllEntity) {
                            boolean isExportUserEntityData = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmIncludeUserEntityMsg", new Object[0]), param.isExportUserEntityData());
                            param.setExportUserEntityData(isExportUserEntityData);
                            validEntityData = true;
                        } else {
                            String exportEntityPathStr = this.readConsole(this.rs("PackageExport.Wizard.inputEntityPathMsg", new Object[0]));
                            if (StringUtil.isEmpty((String)exportEntityPathStr)) {
                                this.logWarn(this.rs("PackageExport.Wizard.requiredEntityPathMsg", new Object[0]));
                                this.logInfo("");
                            } else {
                                param.setExportEntityDataPathStr(exportEntityPathStr);
                                validEntityData = true;
                            }
                        }
                        if (!validEntityData) continue;
                        param.setExportEntityDataPathList(this.getEntityDataPathList(param));
                        boolean isShow = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmShowEntityListMsg", param.getExportEntityDataPathList().size()), false);
                        if (isShow) {
                            this.showEntityDataPathList(param);
                        }
                        if (isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true)) continue;
                        validEntityData = false;
                        continue;
                    }
                    validEntityData = true;
                } while (!validEntityData);
                if (!param.isExportMetaData() && !param.isExportEntityData()) {
                    this.logWarn(this.rs("PackageExport.Wizard.targetEmptyMsg", new Object[0]));
                    this.logInfo("");
                    continue;
                }
                validTarget = true;
            } while (!validTarget);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmExportPackageMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("PackageExport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, paramA -> this.exportPack((PackageExportParameter)paramA));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean silent() {
        Properties prop;
        block64: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                this.logError(this.rs("PackageExport.Silent.requiredConfigFileMsg", KEY_CONFIG_FILE));
                return false;
            }
            prop = new Properties();
            try {
                Throwable throwable;
                InputStream is;
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    is = new FileInputStream(path.toFile());
                    throwable = null;
                    try (InputStreamReader reader2 = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader2);
                        break block64;
                    }
                    catch (Throwable reader2) {
                        throwable = reader2;
                        throw reader2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable reader2) {
                                    throwable.addSuppressed(reader2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                is = PackageExport.class.getResourceAsStream(configFileName);
                throwable = null;
                try {
                    if (is == null) {
                        this.logError(this.rs("PackageExport.Silent.notExistsConfigFileMsg", configFileName));
                        boolean reader2 = false;
                        return reader2;
                    }
                    try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
        } else {
            String propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", propTenantId));
                return false;
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!propTenantUrl.startsWith("/")) {
                    propTenantUrl = "/" + propTenantUrl;
                }
                if ((tenant = this.ts.getTenant(propTenantUrl)) == null) {
                    this.logError(this.rs("Common.notExistsTenantMsg", propTenantUrl));
                    return false;
                }
            }
            if (tenant == null) {
                this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
                return false;
            }
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        PackageExportParameter param = new PackageExportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            String savePackage;
            String exportEntity;
            String source;
            String exportMeta;
            File exportDir;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            String exportDirName = prop.getProperty("exportDir");
            if (StringUtil.isNotEmpty((String)exportDirName)) {
                param.setExportDirName(exportDirName);
            }
            if (!this.checkDir(exportDir = new File(param.getExportDirName()))) {
                return false;
            }
            param.setExportDir(exportDir);
            String packageName = prop.getProperty("packageName");
            if (StringUtil.isNotEmpty((String)packageName)) {
                param.setPackageName(packageName);
            }
            if (StringUtil.isNotEmpty((String)(exportMeta = prop.getProperty("meta.export")))) {
                param.setExportMetaData(Boolean.valueOf(exportMeta));
            }
            if (param.isExportMetaData()) {
                String localOnly = prop.getProperty("meta.localOnly");
                if (StringUtil.isNotEmpty((String)localOnly)) {
                    param.setExportLocalMetaDataOnly(Boolean.valueOf(localOnly));
                }
                if (StringUtil.isEmpty((String)(source = prop.getProperty("meta.source")))) {
                    param.setExportAllMetaData(true);
                    String excludeTenant = prop.getProperty("meta.excludeTenant");
                    if (StringUtil.isNotEmpty((String)excludeTenant)) {
                        param.setExportTenantMetaData(Boolean.valueOf(excludeTenant) == false);
                    }
                } else {
                    param.setExportAllMetaData(false);
                    param.setExportMetaDataPathStr(source);
                }
                param.setExportMetaDataPathList(this.getMetaDataPathList(param));
            }
            if (StringUtil.isNotEmpty((String)(exportEntity = prop.getProperty("entity.export")))) {
                param.setExportEntityData(Boolean.valueOf(exportEntity));
            }
            if (param.isExportEntityData()) {
                source = prop.getProperty("entity.source");
                if (StringUtil.isEmpty((String)source)) {
                    param.setExportAllEntityData(true);
                    String excludeUser = prop.getProperty("meta.excludeUser");
                    if (StringUtil.isNotEmpty((String)excludeUser)) {
                        param.setExportUserEntityData(Boolean.valueOf(excludeUser) == false);
                    }
                } else {
                    param.setExportAllEntityData(false);
                    param.setExportEntityDataPathStr(source);
                }
                param.setExportEntityDataPathList(this.getEntityDataPathList(param));
            }
            if (StringUtil.isNotEmpty((String)(savePackage = prop.getProperty("savePackage")))) {
                param.setSavePackage(Boolean.valueOf(savePackage));
            }
            this.logArguments(param);
            return this.executeTask(param, paramA -> this.exportPack((PackageExportParameter)paramA));
        });
    }

    private boolean checkDir(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
            this.logInfo(this.rs("PackageExport.createdDirMsg", dir.getPath()));
        }
        if (!dir.isDirectory()) {
            this.logError(this.rs("PackageExport.notDirMsg", dir.getPath()));
            return false;
        }
        return true;
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

