/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.query.QueryService;
import org.iplass.mtp.impl.query.condition.predicate.PredicateSyntax;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.impl.tools.entity.EntityUpdateAllCondition;
import org.iplass.mtp.impl.tools.entity.UpdateAllValue;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.entity.EntityUpdateAllParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUpdateAll
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityUpdateAll.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String entityName;
    private Tenant tenant;
    private String updateAllValuesStr;
    private String whereClause;
    private EntityDefinition ed;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private EntityToolService ets = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);
    private QueryService qs = (QueryService)ServiceRegistry.getRegistry().getService(QueryService.class);

    public static void main(String[] args) {
        EntityUpdateAll instance = null;
        try {
            instance = new EntityUpdateAll(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public EntityUpdateAll(String ... args) {
        if (args != null) {
            if (args.length > 0 && StringUtil.isNotBlank((String)args[0])) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && StringUtil.isNotBlank((String)args[1])) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && StringUtil.isNotBlank((String)args[2])) {
                this.entityName = args[2];
            }
            if (args.length > 3 && StringUtil.isNotBlank((String)args[3])) {
                this.updateAllValuesStr = args[3];
            }
            if (args.length > 4 && StringUtil.isNotBlank((String)args[4])) {
                this.whereClause = args[4];
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        if (this.tenantId != null) {
            Tenant tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
            this.tenant = tenant;
        }
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start UpdateAll Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start UpdateAll Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    public EntityUpdateAll execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public EntityUpdateAll tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public EntityUpdateAll entity(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public boolean updateAll(final EntityUpdateAllParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){

            @Override
            public Boolean apply(Transaction t) {
                return EntityUpdateAll.this.executeTask(param, new EntityUpdateAllTask(param));
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(EntityUpdateAllParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        EntityUpdateAllCondition condition = param.getEntityUpdateAllCondition();
        this.logInfo("\tentity name :" + condition.getDefinitionName());
        this.logInfo("\tupdate values :");
        condition.getValues().stream().forEach(u -> this.logInfo("\t\t\t" + u.getPropertyName() + "=" + u.getValue()));
        this.logInfo("\twhere clause :" + condition.getWhere());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private <T> T executeTask(EntityUpdateAllParameter param, Supplier<T> task) {
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (T)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            return task.get();
        });
    }

    protected void showValidPropertyList(EntityDefinition ed) {
        try {
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Property List");
            for (PropertyDefinition propertyDefinition : ed.getPropertyList()) {
                if (!this.isShowRecord(propertyDefinition) || !this.isEnable(propertyDefinition)) continue;
                this.logInfo(propertyDefinition.getName());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private boolean isShowRecord(PropertyDefinition prop) {
        return !prop.isInherited() || !prop.getName().equals("oid") && !prop.getName().equals("version") && !prop.getName().equals("createBy") && !prop.getName().equals("createDate") && !prop.getName().equals("updateBy") && !prop.getName().equals("updateDate");
    }

    private boolean isEnable(PropertyDefinition prop) {
        if (prop.isReadOnly()) {
            return false;
        }
        return !(prop instanceof BinaryProperty) && !(prop instanceof LongTextProperty) && !(prop instanceof ReferenceProperty) && !(prop instanceof ExpressionProperty);
    }

    private List<UpdateAllValue> getUpdateAllValue(EntityDefinition ed, String updateAllValueListStr) throws ParseException {
        ArrayList<UpdateAllValue> updateAllValues = new ArrayList<UpdateAllValue>();
        ParseContext ctx = new ParseContext(updateAllValueListStr);
        while (!ctx.isEnd()) {
            Predicate predicate;
            ctx.consumeChars(ParseContext.WHITE_SPACES);
            if (ctx.startsWith(",")) {
                ctx.consumeChars(",".length());
            }
            if (!((predicate = (Predicate)this.qs.getQueryParser().parse(ctx, PredicateSyntax.class)) instanceof Equals)) {
                this.logWarn(this.rs("EntityUpdateAll.invalidUpdateAllValueMsg", ctx.toString()));
                return null;
            }
            Equals equals = (Equals)predicate;
            if (!(equals.getProperty() instanceof EntityField)) {
                this.logWarn(this.rs("EntityUpdateAll.invalidUpdateAllValueMsg", ctx.toString()));
                return null;
            }
            String propertyName = equals.getPropertyName();
            String value = equals.getValue() == null ? null : equals.getValue().toString();
            PropertyDefinition propertyDefinition = ed.getProperty(propertyName);
            if (propertyDefinition == null || !this.isShowRecord(propertyDefinition) || !this.isEnable(propertyDefinition)) {
                this.logWarn(this.rs("EntityUpdateAll.notExistsPropertyNameMsg", propertyName));
                return null;
            }
            updateAllValues.add(new UpdateAllValue(propertyName, value, UpdateAllValue.UpdateAllValueType.VALUE_EXPRESSION));
        }
        return updateAllValues;
    }

    private boolean wizard() {
        if (this.tenant == null) {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            Object url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            this.tenant = this.ts.getTenant((String)url);
            if (this.tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        EntityUpdateAllParameter param = new EntityUpdateAllParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            EntityUpdateAllCondition condition = new EntityUpdateAllCondition();
            boolean validEntity = false;
            do {
                String inputEntityName = this.entityName;
                this.entityName = null;
                if (StringUtil.isEmpty((String)inputEntityName)) {
                    inputEntityName = this.readConsole(this.rs("EntityUpdateAll.Wizard.inputEntityNameMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputEntityName)) {
                    condition.setDefinitionName(inputEntityName);
                    this.ed = this.edm.get(inputEntityName);
                    if (this.ed == null) {
                        this.logWarn(this.rs("EntityUpdateAll.notExistsEntityMsg", inputEntityName));
                        continue;
                    }
                    validEntity = true;
                    continue;
                }
                this.logWarn(this.rs("EntityUpdateAll.Wizard.requiredEntityNameMsg", new Object[0]));
            } while (!validEntity);
            boolean validUpdateValue = false;
            do {
                String inputUpdateAllValue;
                if (StringUtil.isEmpty((String)(inputUpdateAllValue = this.updateAllValuesStr))) {
                    inputUpdateAllValue = this.readConsole(this.rs("EntityUpdateAll.Wizard.inputUpdateAllValuesMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputUpdateAllValue)) {
                    List<UpdateAllValue> updateAllValues;
                    if (inputUpdateAllValue.equalsIgnoreCase("-show")) {
                        this.showValidPropertyList(this.ed);
                        continue;
                    }
                    try {
                        updateAllValues = this.getUpdateAllValue(this.ed, inputUpdateAllValue);
                    }
                    catch (ParseException e) {
                        this.logWarn(this.rs("EntityUpdateAll.invalidUpdateAllValueMsg", inputUpdateAllValue));
                        continue;
                    }
                    if (CollectionUtils.isEmpty(updateAllValues)) continue;
                    condition.addValues(updateAllValues);
                    validUpdateValue = true;
                    continue;
                }
                this.logWarn(this.rs("EntityUpdateAll.requiredUpdateAllValuesMsg", new Object[0]));
            } while (!validUpdateValue);
            String whereClause = this.readConsole(this.rs("EntityUpdateAll.Wizard.inputWhereClauseMsg", new Object[0]));
            if (StringUtil.isNotBlank((String)whereClause)) {
                condition.setWhere(whereClause);
            }
            param.setEntityUpdateAllCondition(condition);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("EntityUpdateAll.Wizard.confirmUpdateMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("EntityUpdateAll.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, (T paramA) -> this.updateAll((EntityUpdateAllParameter)paramA));
        });
    }

    private boolean silent() {
        Tenant tenant = this.ts.getTenant(this.tenantId.intValue());
        if (tenant == null) {
            this.logError(this.rs("Common.requiredMsg", "tenantId"));
            return false;
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        EntityUpdateAllParameter param = new EntityUpdateAllParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            List<UpdateAllValue> updateAllValues;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            EntityUpdateAllCondition condition = new EntityUpdateAllCondition();
            this.ed = this.edm.get(this.entityName);
            if (this.ed == null) {
                this.logError(this.rs("Common.requiredMsg", "Entity name"));
                return false;
            }
            condition.setDefinitionName(this.ed.getName());
            if (StringUtil.isBlank((String)this.updateAllValuesStr)) {
                this.logWarn(this.rs("EntityUpdateAll.requiredUpdateAllValuesMsg", new Object[0]));
                return false;
            }
            try {
                updateAllValues = this.getUpdateAllValue(this.ed, this.updateAllValuesStr);
            }
            catch (ParseException e) {
                this.logWarn(this.rs("EntityUpdateAll.invalidUpdateAllValueMsg", this.updateAllValuesStr));
                return false;
            }
            if (CollectionUtils.isEmpty(updateAllValues)) {
                return false;
            }
            condition.addValues(updateAllValues);
            condition.setWhere(this.whereClause);
            param.setEntityUpdateAllCondition(condition);
            this.logArguments(param);
            return this.executeTask(param, (T paramA) -> this.updateAll((EntityUpdateAllParameter)paramA));
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private class EntityUpdateAllTask
    implements Supplier<Boolean> {
        private final EntityUpdateAllParameter param;

        public EntityUpdateAllTask(EntityUpdateAllParameter param) {
            this.param = param;
        }

        @Override
        public Boolean get() {
            return !EntityUpdateAll.this.ets.updateAll(this.param.getEntityUpdateAllCondition()).isError();
        }
    }
}

