/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCredential;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportResult;
import org.iplass.mtp.impl.tools.pack.PackageInfo;
import org.iplass.mtp.impl.tools.pack.PackageRuntimeException;
import org.iplass.mtp.impl.tools.pack.PackageService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.pack.PackageImportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageImport
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(PackageImport.class);
    public static final String KEY_CONFIG_FILE = "pack.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String importFile;
    private String userId;
    private String password;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private PackageService ps = (PackageService)ServiceRegistry.getRegistry().getService(PackageService.class);
    private AuthService as = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);

    public static void main(String[] args) {
        PackageImport instance = null;
        try {
            instance = new PackageImport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public PackageImport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && args[2] != null && !"empty".equals(args[2].toLowerCase())) {
                this.importFile = args[2];
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Import Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Import Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    public PackageImport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public PackageImport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public PackageImport importFile(String importFile) {
        this.importFile = importFile;
        return this;
    }

    public boolean importPack(final PackageImportParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){
            String oid = null;

            @Override
            public Boolean apply(Transaction t) {
                ArrayList messageSummary = new ArrayList();
                boolean ret = (Boolean)Transaction.requiresNew(tt -> {
                    if (param.isSavePackage()) {
                        this.oid = PackageImport.this.executeTask(param, new UploadTask(param, messageSummary));
                    }
                    return PackageImport.this.executeTask(param, new MetaDataImportTask(param, messageSummary, this.oid));
                });
                if (!ret) {
                    return false;
                }
                ret = (Boolean)Transaction.requiresNew(tt -> PackageImport.this.executeTask(param, new EntityDataImportTask(param, messageSummary, this.oid)));
                PackageImport.this.logInfo("-----------------------------------------------------------");
                PackageImport.this.logInfo("\u25a0Execute Result Summary");
                for (String message : messageSummary) {
                    PackageImport.this.logInfo(message);
                }
                PackageImport.this.logInfo("-----------------------------------------------------------");
                PackageImport.this.logInfo("");
                PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.completedImportPackageLog", new Object[]{param.getImportFilePath()}));
                return true;
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(PackageImportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\timport file :" + param.getImportFilePath());
        this.logInfo("\timport file locale :" + param.getLocale());
        this.logInfo("\timport file timezone :" + param.getTimezone());
        this.logInfo("\tpackage name :" + param.getPackageName());
        this.logInfo("\tsave package :" + param.isSavePackage());
        PackageInfo packInfo = param.getPackInfo();
        if (CollectionUtil.isNotEmpty((Collection)packInfo.getMetaDataPaths())) {
            this.logInfo("\tmetadata count :" + packInfo.getMetaDataPaths().size());
        } else {
            this.logInfo("\tmetadata count :0");
        }
        if (CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths())) {
            this.logInfo("\tentity count :" + packInfo.getEntityPaths().size());
            EntityDataImportCondition condition = param.getEntityImportCondition();
            this.logInfo("\tentity data truncate :" + condition.isTruncate());
            this.logInfo("\tentity data force update :" + condition.isFourceUpdate());
            this.logInfo("\tentity data error skip :" + condition.isErrorSkip());
            this.logInfo("\tentity ignore not exists property :" + condition.isIgnoreNotExistsProperty());
            this.logInfo("\tentity execute listner :" + condition.isNotifyListeners());
            this.logInfo("\tentity update disupdatable property :" + condition.isUpdateDisupdatableProperty());
            this.logInfo("\tentity insert audit property specification :" + condition.isInsertEnableAuditPropertySpecification());
            this.logInfo("\tentity execute validation :" + condition.isWithValidation());
            this.logInfo("\tentity commit limit :" + condition.getCommitLimit());
            this.logInfo("\tentity oid prefix :" + condition.getPrefixOid());
            if (condition.isInsertEnableAuditPropertySpecification()) {
                this.logInfo("\tentity import execute user id :" + this.userId);
            }
        } else {
            this.logInfo("\tentity count :0");
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private <T> T executeTask(PackageImportParameter param, Supplier<T> task) {
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (T)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            if (StringUtil.isEmpty((String)this.userId)) {
                return task.get();
            }
            try {
                this.as.login((Credential)(StringUtil.isNotEmpty((String)this.password) ? new IdPasswordCredential(this.userId, this.password) : new InternalCredential(this.userId)));
                Object object = this.as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> PackageImport.lambda$executeTask$0((Supplier)task));
                return object;
            }
            finally {
                this.as.logout();
            }
        });
    }

    private void showMetaDataPathList(PackageInfo packInfo) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0MetaData List");
        for (String path : packInfo.getMetaDataPaths()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    private void showEntityDataPathList(PackageInfo packInfo) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0EntityData List");
        for (String path : packInfo.getEntityPaths()) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    private boolean wizard() {
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                this.tenantId = null;
                return this.wizard();
            }
        } else {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            Object url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            tenant = this.ts.getTenant((String)url);
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        PackageImportParameter param = new PackageImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            PackageInfo packInfo = null;
            boolean validFile = false;
            do {
                String importFileName = this.importFile;
                this.importFile = null;
                if (StringUtil.isEmpty((String)importFileName)) {
                    importFileName = this.readConsole(this.rs("PackageImport.Wizard.inputImportFileMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)importFileName)) {
                    param.setImportFilePath(importFileName);
                    File file = new File(param.getImportFilePath());
                    if (!file.exists()) {
                        this.logWarn(this.rs("PackageImport.notExistsImportFileMsg", new Object[0]));
                        continue;
                    }
                    try {
                        int entityCount;
                        int metaCount;
                        packInfo = this.ps.getPackageInfo(file);
                        boolean isSavePackage = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmSavePackageMsg", new Object[0]), param.isSavePackage());
                        param.setSavePackage(isSavePackage);
                        int n = metaCount = CollectionUtil.isNotEmpty((Collection)packInfo.getMetaDataPaths()) ? packInfo.getMetaDataPaths().size() : 0;
                        if (metaCount == 0) {
                            this.logInfo(this.rs("PackageImport.Wizard.notIncludeMetaMsg", new Object[0]));
                        } else {
                            if (packInfo.isWarningTenant()) {
                                this.logWarn(this.rs("PackageImport.includeWarnTenantMetaMsg", new Object[0]));
                            } else {
                                param.setImportTenant(packInfo.getTenant());
                            }
                            boolean isShow = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmShowMetaListMsg", metaCount), false);
                            if (isShow) {
                                this.showMetaDataPathList(packInfo);
                            }
                        }
                        boolean isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true);
                        if (!isContinue) continue;
                        int n2 = entityCount = CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths()) ? packInfo.getEntityPaths().size() : 0;
                        if (entityCount == 0) {
                            this.logInfo(this.rs("PackageImport.Wizard.notIncludeEntityMsg", new Object[0]));
                        } else {
                            boolean isShow = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmShowEntityListMsg", entityCount), false);
                            if (isShow) {
                                this.showEntityDataPathList(packInfo);
                            }
                        }
                        isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true);
                        if (!isContinue) continue;
                        param.setImportFile(file);
                        param.setPackInfo(packInfo);
                        validFile = true;
                    }
                    catch (PackageRuntimeException e) {
                        this.logWarn(this.rs("PackageImport.errorAnalysisFileMsg", e.getMessage()));
                    }
                    continue;
                }
                this.logWarn(this.rs("PackageImport.Wizard.requiredImportFilePathMsg", new Object[0]));
            } while (!validFile);
            if (CollectionUtil.isNotEmpty((Collection)packInfo.getEntityPaths())) {
                String timezone;
                EntityDataImportCondition condition = new EntityDataImportCondition();
                boolean isTruncate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmTrancateDataMsg", new Object[0]), condition.isTruncate());
                condition.setTruncate(isTruncate);
                boolean isBulkUpdate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmBulkUpdateMsg", new Object[0]), condition.isBulkUpdate());
                condition.setBulkUpdate(isBulkUpdate);
                if (isBulkUpdate) {
                    condition.setFourceUpdate(false);
                } else {
                    boolean isForceUpdate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmForceUpdateMsg", new Object[0]), condition.isFourceUpdate());
                    condition.setFourceUpdate(isForceUpdate);
                }
                if (isBulkUpdate) {
                    condition.setErrorSkip(false);
                } else {
                    boolean isErrorSkip = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmSkipErrorDataMsg", new Object[0]), condition.isErrorSkip());
                    condition.setErrorSkip(isErrorSkip);
                }
                boolean isIgnoreNotExistsProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmIgnoreNotExistsPropertyMsg", new Object[0]), condition.isIgnoreNotExistsProperty());
                condition.setIgnoreNotExistsProperty(isIgnoreNotExistsProperty);
                if (isBulkUpdate) {
                    condition.setNotifyListeners(false);
                } else {
                    boolean isNotifyListner = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmNotifyListenerMsg", new Object[0]), condition.isNotifyListeners());
                    condition.setNotifyListeners(isNotifyListner);
                }
                boolean isUpdateDisupdatableProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmUpdateDisupdatablePropertyMsg", new Object[0]), condition.isUpdateDisupdatableProperty());
                condition.setUpdateDisupdatableProperty(isUpdateDisupdatableProperty);
                boolean isInsertEnableAuditPropertySpecification = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmInsertEnableAuditPropertySpecification", new Object[0]), condition.isInsertEnableAuditPropertySpecification());
                condition.setInsertEnableAuditPropertySpecification(isInsertEnableAuditPropertySpecification);
                if (condition.isInsertEnableAuditPropertySpecification()) {
                    do {
                        String executeUserId;
                        if (!StringUtil.isNotEmpty((String)(executeUserId = this.readConsole(this.rs("PackageImport.Wizard.confirmExecuteUserId", new Object[0]))))) continue;
                        this.userId = executeUserId;
                        String executeUserPW = this.readConsole(this.rs("PackageImport.Wizard.confirmExecuteUserPW", new Object[0]));
                        if (!StringUtil.isNotEmpty((String)executeUserPW)) continue;
                        this.password = executeUserPW;
                    } while (this.userId == null);
                }
                if (isBulkUpdate || isUpdateDisupdatableProperty) {
                    condition.setWithValidation(false);
                } else {
                    boolean isWithValidation = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmWithValidationMsg", new Object[0]), condition.isWithValidation());
                    condition.setWithValidation(isWithValidation);
                }
                int commitLimit = this.readConsoleInteger(this.rs("PackageImport.Wizard.inputCommitUnitMsg", new Object[0]), 100);
                condition.setCommitLimit(Integer.valueOf(commitLimit));
                boolean validOidPrefix = false;
                do {
                    String oidPrefix;
                    if (StringUtil.isEmpty((String)(oidPrefix = this.readConsole(this.rs("PackageImport.Wizard.inputOIDPrefixMsg", new Object[0]) + "(" + condition.getPrefixOid() + ")")))) {
                        validOidPrefix = true;
                        continue;
                    }
                    if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                        condition.setPrefixOid(oidPrefix);
                        validOidPrefix = true;
                        continue;
                    }
                    this.logWarn(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
                } while (!validOidPrefix);
                String locale = this.readConsole(this.rs("PackageImport.Wizard.inputLocaleMsg", new Object[0]) + "(" + (condition.getLocale() != null ? condition.getLocale() : "") + ")");
                if (StringUtil.isNotBlank((String)locale)) {
                    condition.setLocale(locale);
                }
                if (StringUtil.isNotBlank((String)(timezone = this.readConsole(this.rs("PackageImport.Wizard.inputTimezoneMsg", new Object[0]) + "(" + (condition.getTimezone() != null ? condition.getTimezone() : "") + ")")))) {
                    condition.setTimezone(timezone);
                }
                param.setEntityImportCondition(condition);
            } else {
                param.setEntityImportCondition(null);
            }
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmImportPackageMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, (T paramA) -> this.importPack((PackageImportParameter)paramA));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean silent() {
        Properties prop;
        block35: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                this.logError(this.rs("PackageImport.Silent.requiredConfigFileMsg", KEY_CONFIG_FILE));
                return false;
            }
            prop = new Properties();
            try {
                InputStream is;
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    is = new FileInputStream(path.toFile());
                    try (InputStreamReader reader22 = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader22);
                        break block35;
                    }
                    finally {
                        is.close();
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                is = PackageImport.class.getResourceAsStream(configFileName);
                try {
                    if (is == null) {
                        this.logError(this.rs("PackageImport.Silent.notExistsConfigFileMsg", configFileName));
                        boolean reader22 = false;
                        return reader22;
                    }
                    try (InputStreamReader reader3 = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader3);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
        } else {
            Object propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", propTenantId));
                return false;
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!((String)propTenantUrl).startsWith("/")) {
                    propTenantUrl = "/" + (String)propTenantUrl;
                }
                if ((tenant = this.ts.getTenant((String)propTenantUrl)) == null) {
                    this.logError(this.rs("Common.notExistsTenantUrlMsg", propTenantUrl));
                    return false;
                }
            }
            if (tenant == null) {
                this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
                return false;
            }
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        PackageImportParameter param = new PackageImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            String savePackage;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            String importFilePath = this.importFile;
            if (StringUtil.isEmpty((String)importFilePath)) {
                importFilePath = prop.getProperty("importFile");
            }
            if (StringUtil.isEmpty((String)importFilePath)) {
                this.logError(this.rs("Common.requiredMsg", "importFile"));
                return false;
            }
            File file = new File(importFilePath);
            if (!file.exists()) {
                this.logError(this.rs("PackageImport.notExistsImportFileMsg", new Object[0]));
                return false;
            }
            param.setImportFilePath(importFilePath);
            try {
                PackageInfo packInfo = this.ps.getPackageInfo(file);
                if (packInfo.isWarningTenant()) {
                    this.logWarn(this.rs("PackageImport.includeWarnTenantMetaMsg", new Object[0]));
                } else {
                    param.setImportTenant(packInfo.getTenant());
                }
                param.setImportFile(file);
                param.setPackInfo(packInfo);
            }
            catch (PackageRuntimeException e) {
                this.logError(this.rs("PackageImport.errorAnalysisFileMsg", e.getMessage()));
                return false;
            }
            if (CollectionUtil.isNotEmpty((Collection)param.getPackInfo().getEntityPaths())) {
                String oidPrefix;
                String insertEnableAuditPropertySpecification;
                String bulkUpdate;
                EntityDataImportCondition condition = new EntityDataImportCondition();
                String truncate = prop.getProperty("entity.truncate");
                if (StringUtil.isNotEmpty((String)truncate)) {
                    condition.setTruncate(Boolean.valueOf(truncate).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(bulkUpdate = prop.getProperty("entity.bulkUpdate")))) {
                    condition.setBulkUpdate(Boolean.valueOf(bulkUpdate).booleanValue());
                }
                if (condition.isBulkUpdate()) {
                    condition.setFourceUpdate(false);
                } else {
                    String forceUpdate = prop.getProperty("entity.forceUpdate");
                    if (StringUtil.isNotEmpty((String)forceUpdate)) {
                        condition.setFourceUpdate(Boolean.valueOf(forceUpdate).booleanValue());
                    }
                }
                if (condition.isBulkUpdate()) {
                    condition.setErrorSkip(false);
                } else {
                    String errorSkip = prop.getProperty("entity.errorSkip");
                    if (StringUtil.isNotEmpty((String)errorSkip)) {
                        condition.setErrorSkip(Boolean.valueOf(errorSkip).booleanValue());
                    }
                }
                String ignoreInvalidProperty = prop.getProperty("entity.ignoreInvalidProperty");
                if (StringUtil.isNotEmpty((String)ignoreInvalidProperty)) {
                    condition.setIgnoreNotExistsProperty(Boolean.valueOf(ignoreInvalidProperty).booleanValue());
                }
                if (condition.isBulkUpdate()) {
                    condition.setNotifyListeners(false);
                } else {
                    String notifyListener = prop.getProperty("entity.notifyListener");
                    if (StringUtil.isNotEmpty((String)notifyListener)) {
                        condition.setNotifyListeners(Boolean.valueOf(notifyListener).booleanValue());
                    }
                }
                String updateDisupdatableProperty = prop.getProperty("entity.updateDisupdatableProperty");
                if (StringUtil.isNotEmpty((String)updateDisupdatableProperty)) {
                    condition.setUpdateDisupdatableProperty(Boolean.valueOf(updateDisupdatableProperty).booleanValue());
                }
                if (StringUtil.isNotEmpty((String)(insertEnableAuditPropertySpecification = prop.getProperty("entity.insertEnableAuditPropertySpecification")))) {
                    condition.setInsertEnableAuditPropertySpecification(Boolean.valueOf(insertEnableAuditPropertySpecification).booleanValue());
                }
                if (condition.isInsertEnableAuditPropertySpecification()) {
                    String execUserPW;
                    String execUserId = prop.getProperty("entity.insertEnableAuditPropertySpecificationUserId");
                    if (StringUtil.isNotEmpty((String)execUserId)) {
                        this.userId = execUserId;
                    }
                    if (StringUtil.isNotEmpty((String)(execUserPW = prop.getProperty("entity.insertEnableAuditPropertySpecificationUserPW")))) {
                        this.password = execUserPW;
                    }
                }
                if (condition.isBulkUpdate() || condition.isUpdateDisupdatableProperty()) {
                    condition.setWithValidation(false);
                } else {
                    String withValidation = prop.getProperty("entity.withValidation");
                    if (StringUtil.isNotEmpty((String)withValidation)) {
                        condition.setWithValidation(Boolean.valueOf(withValidation).booleanValue());
                    }
                }
                String commitLimit = prop.getProperty("entity.commitLimit");
                if (StringUtil.isNotEmpty((String)commitLimit)) {
                    condition.setCommitLimit(Integer.valueOf(commitLimit));
                }
                if (StringUtil.isNotEmpty((String)(oidPrefix = prop.getProperty("entity.prefixOid")))) {
                    if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                        condition.setPrefixOid(oidPrefix);
                    } else {
                        this.logError(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
                        return false;
                    }
                }
                param.setEntityImportCondition(condition);
            }
            if (StringUtil.isNotEmpty((String)(savePackage = prop.getProperty("savePackage")))) {
                param.setSavePackage(Boolean.valueOf(savePackage));
            }
            this.logArguments(param);
            return this.executeTask(param, (T paramA) -> this.importPack((PackageImportParameter)paramA));
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private static /* synthetic */ Object lambda$executeTask$0(Supplier task) {
        return task.get();
    }

    private class EntityDataImportTask
    implements Supplier<Boolean> {
        private final PackageImportParameter param;
        private final List<String> messageSummary;
        private final String oid;

        public EntityDataImportTask(PackageImportParameter param, List<String> messageSummary, String oid) {
            this.param = param;
            this.messageSummary = messageSummary;
            this.oid = oid;
        }

        @Override
        public Boolean get() {
            String logMessage = null;
            if (CollectionUtil.isNotEmpty((Collection)this.param.getPackInfo().getEntityPaths())) {
                PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportEntityLog", new Object[0]));
                for (String path : this.param.getPackInfo().getEntityPaths()) {
                    String entityPath = "/entity/" + path.substring(0, path.length() - 4).replace(".", "/");
                    PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportEntityDataLog", new Object[]{entityPath}));
                    EntityDataImportResult entityResult = null;
                    entityResult = this.param.isSavePackage() && this.oid != null ? PackageImport.this.ps.importPackageEntityData(this.oid, entityPath, this.param.getEntityImportCondition()) : PackageImport.this.ps.importPackageEntityData(this.param.getImportFile(), this.param.getPackageName(), entityPath, this.param.getEntityImportCondition());
                    if (entityResult.isError()) {
                        if (entityResult.getMessages() != null) {
                            for (String message : entityResult.getMessages()) {
                                PackageImport.this.logError(message);
                            }
                            PackageImport.this.logInfo("");
                        }
                        logMessage = PackageImport.this.rs("PackageImport.errorImportEntityDataLog", new Object[]{entityPath});
                        PackageImport.this.logError(logMessage);
                        this.messageSummary.add("[ERROR]" + logMessage);
                        if (!this.param.getEntityImportCondition().isErrorSkip()) {
                            PackageImport.this.logError(PackageImport.this.rs("Common.errorMsg", new Object[]{""}));
                            return false;
                        }
                        PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.continueLog", new Object[0]));
                        continue;
                    }
                    if (entityResult.getMessages() != null) {
                        for (String message : entityResult.getMessages()) {
                            PackageImport.this.logInfo(message);
                        }
                        PackageImport.this.logInfo("");
                    }
                    logMessage = PackageImport.this.rs("PackageImport.completedImportEntityDataLog", new Object[]{entityPath, entityResult.getInsertCount(), entityResult.getUpdateCount(), entityResult.getErrorCount()});
                    PackageImport.this.logInfo(logMessage);
                    PackageImport.this.logInfo("");
                    this.messageSummary.add(logMessage);
                }
                logMessage = PackageImport.this.rs("PackageImport.completedImportEntityLog", new Object[0]);
                PackageImport.this.logInfo(logMessage);
                PackageImport.this.logInfo("");
                this.messageSummary.add(logMessage);
            } else {
                logMessage = PackageImport.this.rs("PackageImport.notIncludeEntityLog", new Object[0]);
                PackageImport.this.logInfo(logMessage);
                PackageImport.this.logInfo("");
                this.messageSummary.add(logMessage);
            }
            return true;
        }
    }

    private class MetaDataImportTask
    implements Supplier<Boolean> {
        private final PackageImportParameter param;
        private final List<String> messageSummary;
        private final String oid;

        public MetaDataImportTask(PackageImportParameter param, List<String> messageSummary, String oid) {
            this.param = param;
            this.messageSummary = messageSummary;
            this.oid = oid;
        }

        @Override
        public Boolean get() {
            if (CollectionUtil.isNotEmpty((Collection)this.param.getPackInfo().getMetaDataPaths())) {
                PackageImport.this.logInfo(PackageImport.this.rs("PackageImport.startImportMetaLog", new Object[0]));
                MetaDataImportResult metaResult = null;
                metaResult = this.param.isSavePackage() && this.oid != null ? PackageImport.this.ps.importPackageMetaData(this.oid, this.param.getImportTenant()) : PackageImport.this.ps.importPackageMetaData(this.param.getImportFile(), this.param.getPackageName(), this.param.getImportTenant());
                if (metaResult.isError()) {
                    if (metaResult.getMessages() != null) {
                        for (String message : metaResult.getMessages()) {
                            PackageImport.this.logError(message);
                        }
                        PackageImport.this.logInfo("");
                    }
                    PackageImport.this.logError(PackageImport.this.rs("Common.errorMsg", new Object[]{""}));
                    return false;
                }
                if (metaResult.getMessages() != null) {
                    for (String message : metaResult.getMessages()) {
                        PackageImport.this.logInfo(message);
                        this.messageSummary.add(message);
                    }
                    PackageImport.this.logInfo("");
                }
                String logMessage = PackageImport.this.rs("PackageImport.completedImportMetaLog", new Object[0]);
                PackageImport.this.logInfo(logMessage);
                PackageImport.this.logInfo("");
                this.messageSummary.add(logMessage);
            } else {
                String logMessage = PackageImport.this.rs("PackageImport.notIncludeMetaLog", new Object[0]);
                PackageImport.this.logInfo(logMessage);
                PackageImport.this.logInfo("");
                this.messageSummary.add(logMessage);
            }
            return true;
        }
    }

    private class UploadTask
    implements Supplier<String> {
        private final PackageImportParameter param;
        private final List<String> messageSummary;

        public UploadTask(PackageImportParameter param, List<String> messageSummary) {
            this.param = param;
            this.messageSummary = messageSummary;
        }

        @Override
        public String get() {
            String oid = PackageImport.this.ps.uploadPackage(this.param.getPackageName(), null, this.param.getImportFile(), "30");
            String logMessage = PackageImport.this.rs("PackageImport.createdPackageInfoLog", new Object[]{oid});
            PackageImport.this.logInfo(logMessage);
            PackageImport.this.logInfo("");
            this.messageSummary.add(logMessage);
            return oid;
        }
    }
}

