/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.widget.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.sql.DataSource;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.DataSourceConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.DriverManagerConnectionFactory;
import org.iplass.mtp.spi.ServiceRegistry;

public class DBConfigMenu
extends JMenu {
    private static final long serialVersionUID = 493704852361376167L;

    public DBConfigMenu(final Frame owner) {
        super("Config");
        JMenuItem item = new JMenuItem("DB Config Settings");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigSettingDialog dialog = new ConfigSettingDialog(owner);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        });
        this.add(item);
    }

    public static class ConfigSettingDialog
    extends JDialog {
        private static final long serialVersionUID = 8378724754491492214L;
        private JTextField txtConfigFileName;
        private JTextField txtRdbAdapter;
        private JTextField txtConnectionFactory;
        private JTextField txtConnectionUrl;
        private JTextField txtConnectionUser;
        private JTextField txtConnectionDriver;
        private JTextField txtDataSourceClass;

        public ConfigSettingDialog(Frame owner) {
            super(owner);
            this.setTitle("Config Settings");
            this.setBounds(64, 64, 300, 590);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(null);
            JPanel headerPane = new JPanel();
            headerPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            headerPane.setLayout(gridbag);
            constraints.gridx = 1;
            constraints.gridheight = 0;
            Box dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            constraints.gridx = 3;
            constraints.gridheight = 0;
            dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            constraints.gridx = 5;
            constraints.gridwidth = 0;
            constraints.gridheight = 0;
            dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            headerPane.add(dummy);
            int row = 0;
            JLabel lblConfigFileName = new JLabel("Service Config File");
            this.txtConfigFileName = new JTextField();
            this.txtConfigFileName.setPreferredSize(new Dimension(300, 25));
            this.txtConfigFileName.setEditable(false);
            this.createLableText(lblConfigFileName, this.txtConfigFileName, null, ++row, gridbag, constraints, headerPane);
            JLabel lblRdbAdapter = new JLabel("Rdb Adapter");
            this.txtRdbAdapter = new JTextField();
            this.txtRdbAdapter.setPreferredSize(new Dimension(300, 25));
            this.txtRdbAdapter.setEditable(false);
            this.createLableText(lblRdbAdapter, this.txtRdbAdapter, null, ++row, gridbag, constraints, headerPane);
            JLabel lblConnectionFactory = new JLabel("Connection Factory");
            this.txtConnectionFactory = new JTextField();
            this.txtConnectionFactory.setPreferredSize(new Dimension(300, 25));
            this.txtConnectionFactory.setEditable(false);
            this.createLableText(lblConnectionFactory, this.txtConnectionFactory, null, ++row, gridbag, constraints, headerPane);
            JLabel lblConnectionUrl = new JLabel("Connection Url");
            this.txtConnectionUrl = new JTextField();
            this.txtConnectionUrl.setPreferredSize(new Dimension(300, 25));
            this.txtConnectionUrl.setEditable(false);
            this.createLableText(lblConnectionUrl, this.txtConnectionUrl, null, ++row, gridbag, constraints, headerPane);
            JLabel lblConnectionUser = new JLabel("Connection User");
            this.txtConnectionUser = new JTextField();
            this.txtConnectionUser.setPreferredSize(new Dimension(300, 25));
            this.txtConnectionUser.setEditable(false);
            this.createLableText(lblConnectionUser, this.txtConnectionUser, null, ++row, gridbag, constraints, headerPane);
            JLabel lblConnectionDriver = new JLabel("Connection Driver");
            this.txtConnectionDriver = new JTextField();
            this.txtConnectionDriver.setPreferredSize(new Dimension(300, 25));
            this.txtConnectionDriver.setEditable(false);
            this.createLableText(lblConnectionDriver, this.txtConnectionDriver, null, ++row, gridbag, constraints, headerPane);
            JLabel lblDataSourceClass = new JLabel("DataSource Class");
            this.txtDataSourceClass = new JTextField();
            this.txtDataSourceClass.setPreferredSize(new Dimension(300, 25));
            this.txtDataSourceClass.setEditable(false);
            this.createLableText(lblDataSourceClass, this.txtDataSourceClass, null, ++row, gridbag, constraints, headerPane);
            JPanel mainPane = new JPanel();
            mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            mainPane.setLayout(new BorderLayout());
            mainPane.add((Component)headerPane, "Center");
            mainPane.add((Component)this.createFooterPane(), "South");
            this.getContentPane().add((Component)mainPane, "North");
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    super.windowActivated(e);
                    try {
                        this.searchConfig();
                    }
                    catch (Throwable err) {
                        JOptionPane.showMessageDialog(this, err.toString(), "\u30a8\u30e9\u30fc", 2);
                    }
                }
            });
        }

        private void createLableText(JComponent label, JComponent text, JComponent check, int row, GridBagLayout gridbag, GridBagConstraints constraints, JPanel pane) {
            constraints.gridx = 0;
            constraints.gridy = row * 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            gridbag.setConstraints(label, constraints);
            pane.add(label);
            constraints.gridx = 2;
            constraints.gridheight = 1;
            gridbag.setConstraints(text, constraints);
            pane.add(text);
            if (check != null) {
                constraints.gridx = 4;
                constraints.gridheight = 1;
                gridbag.setConstraints(check, constraints);
                pane.add(check);
            }
            constraints.gridx = 0;
            constraints.gridy = row * 2 + 1;
            constraints.gridwidth = 0;
            Box dummy = Box.createHorizontalBox();
            dummy.setPreferredSize(new Dimension(15, 15));
            gridbag.setConstraints(dummy, constraints);
            pane.add(dummy);
        }

        private JPanel createFooterPane() {
            JPanel footerPane = new JPanel();
            footerPane.setLayout(new FlowLayout(1));
            JButton btnCancel = new JButton("Cancel");
            btnCancel.setDefaultCapable(true);
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
            footerPane.add(btnCancel);
            return footerPane;
        }

        private void searchConfig() throws Exception {
            ConfigSetting initConfig = new ConfigSetting();
            initConfig.configFileName = BootstrapProps.getInstance().getProperty("mtp.config", "/mtp-service-config.xml");
            this.txtConfigFileName.setText(initConfig.configFileName);
            RdbAdapter adapter = ((RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class)).getRdbAdapter();
            initConfig.rdbAdapterName = adapter.getClass().getSimpleName();
            ConnectionFactory factory = (ConnectionFactory)ServiceRegistry.getRegistry().getService(ConnectionFactory.class);
            initConfig.connectionFactory = factory.getClass().getSimpleName();
            if (factory instanceof DriverManagerConnectionFactory) {
                DriverManagerConnectionFactory dmFactory = (DriverManagerConnectionFactory)factory;
                initConfig.connectionUrl = this.getDriverUrl(dmFactory);
                Properties properties = this.getDriverInfo(dmFactory);
                initConfig.connectionUser = properties.keySet().contains("user") ? properties.getProperty("user") : "not found";
                initConfig.connectionDriver = properties.keySet().contains("driver") ? properties.getProperty("driver") : "not found";
            } else if (factory instanceof DataSourceConnectionFactory) {
                DataSourceConnectionFactory dsFactory = (DataSourceConnectionFactory)factory;
                initConfig.dataSourceClass = this.getDataSourceClass(dsFactory);
            }
            this.setConfigSetting(initConfig);
        }

        private void setConfigSetting(ConfigSetting config) {
            this.txtRdbAdapter.setText(config.rdbAdapterName);
            this.txtConnectionFactory.setText(config.connectionFactory);
            this.txtConnectionUrl.setText(config.connectionUrl);
            this.txtConnectionUser.setText(config.connectionUser);
            this.txtConnectionDriver.setText(config.connectionDriver);
            this.txtDataSourceClass.setText(config.dataSourceClass);
        }

        private String getDriverUrl(DriverManagerConnectionFactory dmFactory) throws Exception {
            Field urlField = dmFactory.getClass().getDeclaredField("url");
            urlField.setAccessible(true);
            return (String)urlField.get(dmFactory);
        }

        private Properties getDriverInfo(DriverManagerConnectionFactory dmFactory) throws Exception {
            Field infoField = dmFactory.getClass().getDeclaredField("info");
            infoField.setAccessible(true);
            return (Properties)infoField.get(dmFactory);
        }

        private String getDataSourceClass(DataSourceConnectionFactory dsFactory) throws Exception {
            Field dataSourceField = dsFactory.getClass().getDeclaredField("dataSource");
            dataSourceField.setAccessible(true);
            return ((DataSource)dataSourceField.get(dsFactory)).getClass().getName();
        }

        private static class ConfigSetting {
            String configFileName;
            String rdbAdapterName;
            String connectionFactory;
            String connectionUrl;
            String connectionUser;
            String connectionDriver;
            String dataSourceClass;

            private ConfigSetting() {
            }
        }
    }
}

