/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.crypt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.core.config.DefaultPropertyValueCoder;
import org.iplass.mtp.impl.core.config.PropertyValueCoder;
import org.iplass.mtp.tools.batch.crypt.EncoderConsolePassphraseSupplier;

public class Encoder {
    private static Properties getProperties() throws IOException {
        String fileName = BootstrapProps.getInstance().getProperty("mtp.config.crypt");
        if (fileName != null) {
            Properties prop;
            block19: {
                prop = new Properties();
                Path path = Paths.get(fileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    System.out.println("load CryptConfigFile from file path:" + fileName);
                    try (FileInputStream fis = new FileInputStream(path.toFile());
                         InputStreamReader is = new InputStreamReader((InputStream)fis, "utf-8");){
                        prop.load(is);
                        break block19;
                    }
                }
                System.out.println("load CryptConfigFile from classpath:" + fileName);
                try (InputStream is = PropertyValueCoder.class.getResourceAsStream(fileName);){
                    if (is == null) {
                        System.err.println("CryptConfigFile:" + fileName + " not found.");
                    }
                    InputStreamReader isr = new InputStreamReader(is, "utf-8");
                    prop.load(isr);
                }
            }
            return prop;
        }
        return System.getProperties();
    }

    public static void main(String[] args) throws Exception {
        Properties prop = Encoder.getProperties();
        String propertyValueCoderName = prop.getProperty("propertyValueCoder", DefaultPropertyValueCoder.class.getName());
        if (DefaultPropertyValueCoder.class.getName().equals(propertyValueCoderName)) {
            prop.setProperty("passphraseSupplier", EncoderConsolePassphraseSupplier.class.getName());
        }
        PropertyValueCoder coder = (PropertyValueCoder)Class.forName(propertyValueCoderName).newInstance();
        coder.open(prop);
        do {
            String plain;
            if (args.length > 0) {
                if (args[0].equals("-file")) {
                    String filePath;
                    if (args.length > 1) {
                        filePath = args[1];
                    } else {
                        System.out.println("enter file path of plain text:");
                        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                        filePath = console.readLine();
                    }
                    plain = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), "utf-8");
                } else {
                    plain = args[0];
                }
            } else {
                System.out.println("enter plain text:");
                BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                plain = console.readLine();
            }
            if (plain.equals("")) {
                return;
            }
            System.out.println("encrypted text:");
            System.out.println(coder.encode(plain));
            System.out.println();
        } while (args.length <= 1 || !args[0].equals("-file"));
    }
}

