/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataStore;
import org.iplass.mtp.impl.metadata.composite.CompositeMetaDataStore;
import org.iplass.mtp.impl.metadata.composite.MetaDataStorePathMapping;
import org.iplass.mtp.impl.metadata.rdb.RdbMetaDataStore;
import org.iplass.mtp.impl.metadata.xmlfile.VersioningXmlFileMetaDataStore;
import org.iplass.mtp.impl.metadata.xmlfile.XmlFileMetaDataStore;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.metadata.MetaDataExportRdbToFileParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataExportRdbToFile
extends MtpCuiBase {
    private static Logger LOGGER = LoggerFactory.getLogger(MetaDataExportRdbToFile.class);
    private AbstractRepositoryHandler handler = this.getMetaDataRepositoryHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean isSuccess = false;
        try {
            ExecMode argMode;
            ExecMode mode = ExecMode.WIZARD;
            if (1 <= args.length && null != (argMode = ExecMode.valueOf(args[0].toUpperCase()))) {
                mode = argMode;
            }
            MetaDataExportRdbToFile instance = new MetaDataExportRdbToFile();
            isSuccess = instance.execute(mode);
        }
        finally {
            ExecuteContext.finContext();
            MtpBatchResourceDisposer.disposeResource();
        }
        System.exit(isSuccess ? 0 : -1);
    }

    public boolean execute(ExecMode execMode) {
        return this.executeTask(null, unused -> (Boolean)Transaction.required(t -> {
            this.switchLog(false, true);
            if (null == execMode) {
                throw new NullPointerException(this.rs("MetaDataExportRdbToFile.incorrectArg.execMode", new Object[0]));
            }
            MetaDataExportRdbToFileParameter parameter = null;
            if (execMode == ExecMode.WIZARD) {
                this.switchLog(true, false);
                parameter = new WizardParameterFactory(this).create(this.handler);
                this.switchLog(false, true);
            } else if (execMode == ExecMode.SILENT) {
                parameter = new SilentParameterFactory(this).create(this.handler);
            }
            TenantContext context = ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).getTenantContext(parameter.getTenantId());
            MetaDataExportRdbToFileParameter finalParameter = parameter;
            return (Boolean)ExecuteContext.executeAs((TenantContext)context, () -> {
                this.exportRdbToFile(finalParameter);
                this.logInfo(this.rs("MetaDataExportRdbToFile.finishLog", this.handler.getFileStoreAbsolutePath()));
                return true;
            });
        }));
    }

    public void exportRdbToFile(MetaDataExportRdbToFileParameter parameter) {
        for (String path : parameter.getExportMetaDataPathList()) {
            MetaDataEntry entry = this.handler.getRdbMetaDataStore().load(parameter.getTenantId(), path);
            if (null == entry) {
                this.logWarn(this.rs("MetaDataExportRdbToFile.notFoundMetaLog", path));
                continue;
            }
            this.logDebug("store metadata: " + path + ".");
            this.handler.store(parameter.getTenantId(), entry);
        }
    }

    @Override
    protected Logger loggingLogger() {
        return LOGGER;
    }

    private AbstractRepositoryHandler getMetaDataRepositoryHandler() {
        MetaDataRepository metadataRepository = (MetaDataRepository)ServiceRegistry.getRegistry().getService(MetaDataRepository.class);
        MetaDataStore tenantLocalStore = metadataRepository.getTenantLocalStore();
        if (!(tenantLocalStore instanceof CompositeMetaDataStore)) {
            throw new RuntimeException(this.rs("MetaDataExportRdbToFile.incorrectServiceConfig.tenantLocalStoreProperty", new Object[0]));
        }
        CompositeMetaDataStore casted = (CompositeMetaDataStore)tenantLocalStore;
        XmlFileMetaDataStore xmlStore = (XmlFileMetaDataStore)casted.getStore(XmlFileMetaDataStore.class);
        if (null != xmlStore) {
            return new XmlFileMetaDataStoreHandler(this, casted, xmlStore);
        }
        VersioningXmlFileMetaDataStore versioningXmlStore = (VersioningXmlFileMetaDataStore)casted.getStore(VersioningXmlFileMetaDataStore.class);
        if (null != versioningXmlStore) {
            return new VersioningXmlFileMetaDataStoreHandler(this, casted, versioningXmlStore);
        }
        throw new RuntimeException(this.rs("MetaDataExportRdbToFile.incorrectServiceConfig.storeProperty", new Object[0]));
    }

    private static abstract class AbstractRepositoryHandler {
        private RdbMetaDataStore rdbMetaDataStore;
        private MetaDataExportRdbToFile instance;
        private Map<String, Boolean> pathMappingIsRdbMetaDataStore;
        private boolean isDefaultRdbMetaDataStore;

        public AbstractRepositoryHandler(MetaDataExportRdbToFile instance, CompositeMetaDataStore tenantLocalStore) {
            this.instance = instance;
            this.rdbMetaDataStore = (RdbMetaDataStore)tenantLocalStore.getStore(RdbMetaDataStore.class);
            this.pathMappingIsRdbMetaDataStore = new HashMap<String, Boolean>();
            for (MetaDataStorePathMapping mapping : tenantLocalStore.getPathMapping()) {
                this.pathMappingIsRdbMetaDataStore.put(mapping.getPathPrefix(), RdbMetaDataStore.class.getName().equals(mapping.getStore()));
            }
            this.isDefaultRdbMetaDataStore = RdbMetaDataStore.class.getName().equals(tenantLocalStore.getDefaultStoreClass());
        }

        public RdbMetaDataStore getRdbMetaDataStore() {
            return this.rdbMetaDataStore;
        }

        public boolean isRdbMetaDataStore(String path) {
            for (Map.Entry<String, Boolean> entry : this.pathMappingIsRdbMetaDataStore.entrySet()) {
                if (!path.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return this.isDefaultRdbMetaDataStore;
        }

        public abstract boolean validate(int var1);

        public abstract void validateIfErrorThrow(int var1);

        public abstract void store(int var1, MetaDataEntry var2);

        public abstract String getFileStorePath();

        public String getFileStoreAbsolutePath() {
            return new File(this.getFileStorePath()).getAbsolutePath();
        }

        protected MetaDataExportRdbToFile getInstance() {
            return this.instance;
        }
    }

    private static class XmlFileMetaDataStoreHandler
    extends AbstractRepositoryHandler {
        private XmlFileMetaDataStore store;

        public XmlFileMetaDataStoreHandler(MetaDataExportRdbToFile instance, CompositeMetaDataStore tenantLocalStore, XmlFileMetaDataStore store) {
            super(instance, tenantLocalStore);
            this.store = store;
        }

        @Override
        public boolean validate(int tenantId) {
            String errorMessage = this.validateInner(tenantId);
            if (null != errorMessage) {
                this.getInstance().logError(errorMessage);
                return false;
            }
            return true;
        }

        @Override
        public void validateIfErrorThrow(int tenantId) {
            String errorMessage = this.validateInner(tenantId);
            if (null != errorMessage) {
                throw new RuntimeException(errorMessage);
            }
        }

        private String validateInner(int tenantId) {
            if (this.store.getLocalTenantId() != tenantId) {
                return this.getInstance().rs("MetaDataExportRdbToFile.incorrectConfig.tenantId", new Object[]{this.store.getLocalTenantId(), tenantId});
            }
            return null;
        }

        @Override
        public void store(int tenantId, MetaDataEntry metaDataEntry) {
            this.store.store(tenantId, metaDataEntry, metaDataEntry.getVersion());
        }

        @Override
        public String getFileStorePath() {
            return this.store.getFileStorePath();
        }
    }

    private static class VersioningXmlFileMetaDataStoreHandler
    extends AbstractRepositoryHandler {
        private VersioningXmlFileMetaDataStore store;

        public VersioningXmlFileMetaDataStoreHandler(MetaDataExportRdbToFile instance, CompositeMetaDataStore tenantLocalStore, VersioningXmlFileMetaDataStore store) {
            super(instance, tenantLocalStore);
            this.store = store;
        }

        @Override
        public boolean validate(int tenantId) {
            return true;
        }

        @Override
        public void validateIfErrorThrow(int tenantId) {
        }

        @Override
        public void store(int tenantId, MetaDataEntry metaDataEntry) {
            this.store.store(tenantId, metaDataEntry);
        }

        @Override
        public String getFileStorePath() {
            return this.store.getFileStorePath();
        }
    }

    private static class WizardParameterFactory
    extends AbstractParameterFactory {
        public WizardParameterFactory(MetaDataExportRdbToFile instance) {
            super(instance);
        }

        @Override
        public MetaDataExportRdbToFileParameter create(AbstractRepositoryHandler handler) {
            Tenant tenant = this.readTenantRequire(handler);
            MetaDataExportRdbToFileParameter param = new MetaDataExportRdbToFileParameter();
            param.setTenantId(tenant.getId());
            param.setTenantName(tenant.getName());
            TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
            return (MetaDataExportRdbToFileParameter)ExecuteContext.executeAs((TenantContext)tc, () -> {
                block5: {
                    ExecuteContext.getCurrentContext().setLanguage(this.instance.getLanguage());
                    boolean isInitialConvert = this.instance.readConsoleBoolean(this.instance.rs("MetaDataExportRdbToFile.Wizard.confirmInitialConvertMsg", new Object[0]), param.isInitaialConvert());
                    param.setInitaialConvert(isInitialConvert);
                    if (isInitialConvert) {
                        param.setExportMetaDataPathList(this.getRdbManagedMetaDataPathList(param));
                    } else {
                        boolean isExportAllMeta = this.instance.readConsoleBoolean(this.instance.rs("MetaDataExportRdbToFile.Wizard.confirmExportAllMetaMsg", new Object[0]), param.isExportAllMetaData());
                        param.setExportAllMetaData(isExportAllMeta);
                        if (isExportAllMeta) {
                            param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                        } else {
                            String exportMetaDataPath = this.readSpecifiedMetaDataPathRequire();
                            param.setExportMetaDataPath(exportMetaDataPath);
                            param.setExportMetaDataPathList(this.getMetaDataPathListByPath(param));
                        }
                    }
                    this.showMetaDataPathList(param);
                    do {
                        this.logArguments(param, handler);
                        if (this.instance.readConsoleBoolean(this.instance.rs("MetaDataExportRdbToFile.Wizard.confirmExecuteMsg", new Object[0]), false)) break block5;
                    } while (!this.instance.readConsoleBoolean(this.instance.rs("MetaDataExportRdbToFile.Wizard.confirmRetryMsg", new Object[0]), true));
                    return this.create(handler);
                }
                return param;
            });
        }

        private Tenant readTenantRequire(AbstractRepositoryHandler handler) {
            return this.readRequire(() -> {
                String tenantUrl = this.instance.readConsole(this.instance.rs("Common.inputTenantUrlMsg", new Object[0]));
                if (StringUtil.isEmpty((String)tenantUrl)) {
                    this.instance.logWarn(this.instance.rs("Common.requiredTenantUrlMsg", new Object[0]));
                    return null;
                }
                if (tenantUrl.equalsIgnoreCase("-show")) {
                    this.instance.showValidTenantList();
                    return null;
                }
                if (tenantUrl.equalsIgnoreCase("-env")) {
                    this.instance.logEnvironment();
                    return null;
                }
                Object url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
                Tenant tenant = this.ts.getTenant((String)url);
                if (tenant == null) {
                    this.instance.logWarn(this.instance.rs("Common.notExistsTenantMsg", new Object[]{tenantUrl}));
                    return null;
                }
                if (!handler.validate(tenant.getId())) {
                    return null;
                }
                return tenant;
            });
        }

        private String readSpecifiedMetaDataPathRequire() {
            return this.readRequire(() -> {
                String value = this.instance.readConsole(this.instance.rs("MetaDataExportRdbToFile.Wizard.inputMetaPathMsg", new Object[0]));
                if (StringUtil.isEmpty((String)value)) {
                    this.instance.logWarn(this.instance.rs("MetaDataExportRdbToFile.Wizard.requiredMetaPathMsg", new Object[0]));
                    this.instance.logInfo("");
                    return null;
                }
                return value;
            });
        }

        private <T> T readRequire(Supplier<T> supplier) {
            T value;
            while (null == (value = supplier.get())) {
            }
            return value;
        }
    }

    private static class SilentParameterFactory
    extends AbstractParameterFactory {
        public SilentParameterFactory(MetaDataExportRdbToFile instance) {
            super(instance);
        }

        @Override
        public MetaDataExportRdbToFileParameter create(AbstractRepositoryHandler handler) {
            Object propTenantUrl;
            String configFileName = System.getProperty("meta.config");
            if (StringUtil.isEmpty((String)configFileName)) {
                throw new RuntimeException(this.instance.rs("MetaDataExportRdbToFile.Silent.requiredConfigFileMsg", new Object[]{"meta.config"}));
            }
            Properties prop = new Properties();
            try (InputStream input = this.getInputStreamFromFileOrResource(configFileName);
                 InputStreamReader reader = new InputStreamReader(input, "UTF-8");){
                prop.load(reader);
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            Tenant tenant = null;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                throw new RuntimeException(this.instance.rs("Common.notExistsTenantIdMsg", new Object[]{propTenantId}));
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!((String)propTenantUrl).startsWith("/")) {
                    propTenantUrl = "/" + (String)propTenantUrl;
                }
                if ((tenant = this.ts.getTenant((String)propTenantUrl)) == null) {
                    throw new RuntimeException(this.instance.rs("Common.notExistsTenantMsg", new Object[]{propTenantUrl}));
                }
            }
            if (tenant == null) {
                throw new RuntimeException(this.instance.rs("Common.requiredMsg", new Object[]{"tenantId or tenantUrl"}));
            }
            this.instance.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
            handler.validateIfErrorThrow(tenant.getId());
            MetaDataExportRdbToFileParameter param = new MetaDataExportRdbToFileParameter();
            param.setTenantId(tenant.getId());
            param.setTenantName(tenant.getName());
            TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
            return (MetaDataExportRdbToFileParameter)ExecuteContext.executeAs((TenantContext)tc, () -> {
                ExecuteContext.getCurrentContext().setLanguage(this.instance.getLanguage());
                String initialConvert = prop.getProperty("initialConvert");
                if (StringUtil.isNotEmpty((String)initialConvert)) {
                    param.setInitaialConvert(Boolean.valueOf(initialConvert));
                }
                String source = prop.getProperty("meta.source");
                if (param.isInitaialConvert()) {
                    param.setExportMetaDataPathList(this.getRdbManagedMetaDataPathList(param));
                } else if (StringUtil.isEmpty((String)source)) {
                    param.setExportAllMetaData(true);
                    param.setExportMetaDataPathList(this.getMetaDataPathList(param));
                } else {
                    param.setExportAllMetaData(false);
                    param.setExportMetaDataPath(source);
                    param.setExportMetaDataPathList(this.getMetaDataPathListByPath(param));
                }
                this.logArguments(param, handler);
                return param;
            });
        }

        private InputStream getInputStreamFromFileOrResource(String file) throws IOException {
            if (Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                this.instance.logDebug("load file from file path: " + file);
                return new BufferedInputStream(new FileInputStream(file));
            }
            this.instance.logDebug("load file from classpath: " + file);
            InputStream input = this.getClass().getResourceAsStream(file);
            if (null != input) {
                return input;
            }
            throw new FileNotFoundException(this.instance.rs("MetaDataExportRdbToFile.fileResourceNotFound", new Object[]{file}));
        }
    }

    private static abstract class AbstractParameterFactory {
        protected MetaDataExportRdbToFile instance;
        protected TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
        protected TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);

        public AbstractParameterFactory(MetaDataExportRdbToFile instance) {
            this.instance = instance;
        }

        public abstract MetaDataExportRdbToFileParameter create(AbstractRepositoryHandler var1);

        protected void logArguments(MetaDataExportRdbToFileParameter param, AbstractRepositoryHandler handler) {
            this.instance.logInfo("-----------------------------------------------------------");
            this.instance.logInfo("+ Execute Argument");
            this.instance.logInfo("  tenant name :" + param.getTenantName());
            Object metaTarget = param.isInitaialConvert() ? "Initial (include Tenant)" : (param.isExportAllMetaData() ? "RDB ALL" : param.getExportMetaDataPath());
            metaTarget = (String)metaTarget + "(" + param.getExportMetaDataPathList().size() + ")";
            this.instance.logInfo("  metadata target :" + (String)metaTarget);
            this.instance.logInfo("  xml metadata output to : " + handler.getFileStorePath());
            this.instance.logInfo("  output absolute path : " + new File(handler.getFileStorePath()).getAbsolutePath());
            this.instance.logInfo("-----------------------------------------------------------");
            this.instance.logInfo("");
        }

        protected List<String> getRdbManagedMetaDataPathList(MetaDataExportRdbToFileParameter param) {
            RdbMetaDataStore rdbStore = this.instance.handler.getRdbMetaDataStore();
            List rdbAllMeta = rdbStore.definitionList(param.getTenantId(), "/");
            return rdbAllMeta.stream().filter(m -> MetaDataEntry.RepositoryType.SHARED != m.getRepositryType()).map(m -> m.getPath()).sorted().collect(Collectors.toList());
        }

        protected List<String> getMetaDataPathList(MetaDataExportRdbToFileParameter param) {
            List allMeta = MetaDataContext.getContext().definitionList("/");
            return allMeta.stream().filter(m -> MetaDataEntry.RepositoryType.SHARED != m.getRepositryType()).filter(m -> this.instance.handler.isRdbMetaDataStore(m.getPath())).map(m -> m.getPath()).sorted().collect(Collectors.toList());
        }

        protected List<String> getMetaDataPathListByPath(MetaDataExportRdbToFileParameter param) {
            String[] pathStrArray;
            HashSet<String> directPathSet = new HashSet<String>();
            for (String pathStr : pathStrArray = param.getExportMetaDataPath().split(",")) {
                if (StringUtil.isEmpty((String)pathStr)) continue;
                if (pathStr.endsWith("*")) {
                    List allMeta = MetaDataContext.getContext().definitionList(pathStr.substring(0, pathStr.length() - 1));
                    allMeta.stream().filter(m -> MetaDataEntry.RepositoryType.SHARED != m.getRepositryType()).filter(m -> this.instance.handler.isRdbMetaDataStore(m.getPath())).forEach(m -> directPathSet.add(m.getPath()));
                    continue;
                }
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(pathStr);
                if (entry == null) {
                    this.instance.logWarn(this.instance.rs("MetaDataExportRdbToFile.notFoundMetaLog", new Object[]{pathStr}));
                    continue;
                }
                if (entry.getRepositryType() == MetaDataEntry.RepositoryType.SHARED && this.instance.handler.isRdbMetaDataStore(entry.getPath())) {
                    this.instance.logWarn(this.instance.rs("MetaDataExportRdbToFile.notCoveredLog", new Object[]{pathStr}));
                    continue;
                }
                directPathSet.add(entry.getPath());
            }
            return directPathSet.stream().sorted().collect(Collectors.toList());
        }

        protected void showMetaDataPathList(MetaDataExportRdbToFileParameter param) {
            this.instance.logInfo("-----------------------------------------------------------");
            this.instance.logInfo("+ MetaData List");
            param.getExportMetaDataPathList().stream().forEach(path -> this.instance.logInfo(path));
            this.instance.logInfo("-----------------------------------------------------------");
        }
    }

    private static final class PropertyKeys {
        public static final String TENANT_URL = "tenantUrl";
        public static final String TENANT_ID = "tenantId";
        public static final String INITIAL_CONVERT = "initialConvert";
        public static final String META_SOURCE = "meta.source";

        private PropertyKeys() {
        }
    }
}

