/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportResult;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.XMLEntryInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.metadata.MetaDataImportParameter;
import org.iplass.mtp.tools.batch.pack.PackageExport;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataImport
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(MetaDataImport.class);
    public static final String KEY_CONFIG_FILE = "meta.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String importFile;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private MetaDataPortingService mdps = (MetaDataPortingService)ServiceRegistry.getRegistry().getService(MetaDataPortingService.class);

    public static void main(String[] args) {
        MetaDataImport instance = null;
        try {
            instance = new MetaDataImport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public MetaDataImport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && args[2] != null && !"empty".equals(args[2].toLowerCase())) {
                this.importFile = args[2];
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Import Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Import Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    public MetaDataImport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public MetaDataImport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public MetaDataImport importFile(String importFile) {
        this.importFile = importFile;
        return this;
    }

    public boolean importMeta(final MetaDataImportParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){

            @Override
            public Boolean apply(Transaction t) {
                TenantContext tc = MetaDataImport.this.tcs.getTenantContext(param.getTenantId());
                return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
                    ExecuteContext.getCurrentContext().setLanguage(MetaDataImport.this.getLanguage());
                    MetaDataImport.this.logInfo(MetaDataImport.this.rs("MetaDataImport.startImportMetaLog", new Object[0]));
                    try (FileInputStream is = new FileInputStream(param.getImportFile());){
                        XMLEntryInfo entryInfo = MetaDataImport.this.mdps.getXMLMetaDataEntryInfo((InputStream)is);
                        MetaDataImportResult result = MetaDataImport.this.mdps.importMetaData(param.getImportFile().getName(), entryInfo, param.getImportTenant());
                        if (result.isError()) {
                            if (result.getMessages() != null) {
                                for (String message : result.getMessages()) {
                                    MetaDataImport.this.logError(message);
                                }
                                MetaDataImport.this.logInfo("");
                            }
                            MetaDataImport.this.logError(MetaDataImport.this.rs("Common.errorMsg", new Object[]{""}));
                            Boolean bl = false;
                            return bl;
                        }
                        if (result.getMessages() != null) {
                            for (String message : result.getMessages()) {
                                MetaDataImport.this.logInfo(message);
                            }
                        }
                        MetaDataImport.this.logInfo(MetaDataImport.this.rs("MetaDataImport.completedImportMetaLog", new Object[0]));
                        return true;
                    }
                    catch (IOException e) {
                        throw new SystemException("failed to read metadata configure. file=" + param.getImportFile().getName(), (Throwable)e);
                    }
                });
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(MetaDataImportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\timport file :" + param.getImportFilePath());
        if (CollectionUtil.isNotEmpty(param.getMetaDataPaths())) {
            this.logInfo("\tmetadata count :" + param.getMetaDataPaths().size());
        } else {
            this.logInfo("\tmetadata count :0");
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean wizard() {
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                this.tenantId = null;
                return this.wizard();
            }
        } else {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            Object url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            tenant = this.ts.getTenant((String)url);
            if (tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        MetaDataImportParameter param = new MetaDataImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validFile = false;
            do {
                String importFileName = this.importFile;
                this.importFile = null;
                if (StringUtil.isEmpty((String)importFileName)) {
                    importFileName = this.readConsole(this.rs("MetaDataImport.Wizard.inputImportFileMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)importFileName)) {
                    int metaCount;
                    param.setImportFilePath(importFileName);
                    File file = new File(param.getImportFilePath());
                    if (!file.exists()) {
                        this.logWarn(this.rs("MetaDataImport.notExistsImportFileMsg", new Object[0]));
                        continue;
                    }
                    try {
                        this.analyse(file, param);
                    }
                    catch (IOException e) {
                        this.logWarn(this.rs("MetaDataImport.errorAnalysisFileMsg", e.getMessage()));
                        continue;
                    }
                    int n = metaCount = CollectionUtil.isNotEmpty(param.getMetaDataPaths()) ? param.getMetaDataPaths().size() : 0;
                    if (metaCount == 0) {
                        this.logInfo(this.rs("MetaDataImport.Wizard.notIncludeMetaMsg", new Object[0]));
                    } else {
                        boolean isShow;
                        if (param.isWarningTenant()) {
                            this.logWarn(this.rs("MetaDataImport.includeWarnTenantMetaMsg", new Object[0]));
                        }
                        if (isShow = this.readConsoleBoolean(this.rs("MetaDataImport.Wizard.confirmShowMetaListMsg", metaCount), false)) {
                            this.showMetaDataPathList(param.getMetaDataPaths());
                        }
                    }
                    boolean isContinue = this.readConsoleBoolean(this.rs("Common.continueMsg", new Object[0]), true);
                    if (!isContinue) continue;
                    param.setImportFile(file);
                    validFile = true;
                    continue;
                }
                this.logWarn(this.rs("MetaDataImport.Wizard.requiredImportFilePathMsg", new Object[0]));
            } while (!validFile);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("MetaDataImport.Wizard.confirmExecuteMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("MetaDataImport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, paramA -> this.importMeta((MetaDataImportParameter)paramA));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean silent() {
        Properties prop;
        block35: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            prop = new Properties();
            if (StringUtil.isNotEmpty((String)configFileName)) {
                try {
                    InputStream is;
                    Path path = Paths.get(configFileName, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        this.logDebug("load config file from file path:" + configFileName);
                        is = new FileInputStream(path.toFile());
                        try (InputStreamReader reader22 = new InputStreamReader(is, "UTF-8");){
                            prop.load(reader22);
                            break block35;
                        }
                        finally {
                            is.close();
                        }
                    }
                    this.logDebug("load config file from classpath:" + configFileName);
                    is = PackageExport.class.getResourceAsStream(configFileName);
                    try {
                        if (is == null) {
                            this.logError(this.rs("MetaDataImport.Silent.notExistsConfigFileMsg", configFileName));
                            boolean reader22 = false;
                            return reader22;
                        }
                        try (InputStreamReader reader3 = new InputStreamReader(is, "UTF-8");){
                            prop.load(reader3);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
        }
        Tenant tenant = null;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
        } else {
            Object propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId) && (tenant = this.ts.getTenant(Integer.parseInt(propTenantId))) == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", propTenantId));
                return false;
            }
            if (tenant == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!((String)propTenantUrl).startsWith("/")) {
                    propTenantUrl = "/" + (String)propTenantUrl;
                }
                if ((tenant = this.ts.getTenant((String)propTenantUrl)) == null) {
                    this.logError(this.rs("Common.notExistsTenantUrlMsg", propTenantUrl));
                    return false;
                }
            }
            if (tenant == null) {
                this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
                return false;
            }
        }
        this.logInfo("target tenant:[" + tenant.getId() + "]" + tenant.getName());
        MetaDataImportParameter param = new MetaDataImportParameter(tenant.getId(), tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            String importFilePath = this.importFile;
            if (StringUtil.isEmpty((String)importFilePath)) {
                importFilePath = prop.getProperty("importFile");
            }
            if (StringUtil.isEmpty((String)importFilePath)) {
                this.logError(this.rs("Common.requiredMsg", "importFile"));
                return false;
            }
            File file = new File(importFilePath);
            if (!file.exists()) {
                this.logError(this.rs("MetaDataImport.notExistsImportFileMsg", new Object[0]));
                return false;
            }
            param.setImportFilePath(importFilePath);
            try {
                this.analyse(file, param);
            }
            catch (IOException e) {
                this.logError(this.rs("MetaDataImport.errorAnalysisFileMsg", e.getMessage()));
                return false;
            }
            if (param.isWarningTenant()) {
                this.logWarn(this.rs("MetaDataImport.includeWarnTenantMetaMsg", new Object[0]));
            }
            param.setImportFile(file);
            this.logArguments(param);
            return this.executeTask(param, paramA -> this.importMeta((MetaDataImportParameter)paramA));
        });
    }

    private void analyse(File file, MetaDataImportParameter param) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            XMLEntryInfo entryInfo = this.mdps.getXMLMetaDataEntryInfo((InputStream)is);
            List<String> pathList = entryInfo.getPathEntryMap().keySet().stream().sorted((path1, path2) -> path1.compareToIgnoreCase((String)path2)).collect(Collectors.toList());
            param.setMetaDataPaths(pathList);
            Optional<MetaTenant> importMetaTenant = entryInfo.getPathEntryMap().entrySet().stream().filter(entry -> this.mdps.isTenantMeta((String)entry.getKey())).map(entry -> (MetaTenant)((MetaDataEntry)entry.getValue()).getMetaData()).findFirst();
            if (importMetaTenant.isPresent()) {
                MetaTenant metaTenant = importMetaTenant.get();
                Tenant importTenant = new Tenant();
                metaTenant.applyToTenant(importTenant);
                importTenant.setId(-1);
                importTenant.setName(metaTenant.getName());
                importTenant.setDescription(metaTenant.getDescription());
                Tenant currentTenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                if (!currentTenant.getName().equals(metaTenant.getName())) {
                    param.setWarningTenant(true);
                    param.setImportTenant(null);
                } else {
                    param.setWarningTenant(false);
                    param.setImportTenant(importTenant);
                }
            }
        }
    }

    private void showMetaDataPathList(List<String> pathList) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0MetaData List");
        for (String path : pathList) {
            this.logInfo(path);
        }
        this.logInfo("-----------------------------------------------------------");
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

