/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Scanner;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EQLExecutor
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EQLExecutor.class);
    private static final String SET_EQL_EXEC_MODE = "EQL_EXEC_MODE=";
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityToolService entityToolService = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private int tenantId = -1;
    private String eql;
    private boolean isSearchAllVersion = false;
    private ExecMode execMode = ExecMode.BATCH;
    private EQLExecMode eqlExecMode = EQLExecMode.ONLY_EXEC;
    private String userId;
    private String password;
    private String exportFile;

    public EQLExecutor(String ... args) {
        if (args == null || args.length < 2) {
            return;
        }
        if (args.length > 0) {
            this.eql = args[0];
        }
        if (args.length > 1) {
            this.tenantId = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            this.isSearchAllVersion = Boolean.parseBoolean(args[2]);
        }
        if (args.length > 3) {
            this.execMode = ExecMode.valueOf(args[3]);
        }
        if (args.length > 4) {
            this.eqlExecMode = EQLExecMode.valueOf(args[4]);
        }
        if (args.length > 5) {
            this.userId = args[5];
        }
        if (args.length > 6) {
            this.password = args[6];
        }
        if (args.length > 7) {
            this.exportFile = args[7];
        }
    }

    public static void main(String ... args) {
        try {
            new EQLExecutor(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    private boolean execute() {
        this.clearLog();
        this.switchLog(false, true);
        this.logEnvironment();
        return this.executeTask(null, param -> this.proceed(), false, true);
    }

    private boolean proceed() {
        this.setSuccess(false);
        if (this.tenantId < 0) {
            this.logError(this.rs("EQLExecutor.invalidTenantId", this.tenantId));
            return this.isSuccess();
        }
        TenantContext tc = tenantContextService.getTenantContext(this.tenantId);
        if (tc == null) {
            this.logError(this.rs("EQLExecutor.notFoundTenant", this.tenantId));
            return this.isSuccess();
        }
        if (EQLExecMode.CSV_EXPORT.equals((Object)this.eqlExecMode) && StringUtil.isBlank((String)this.exportFile)) {
            this.logError(this.rs("EQLExecutor.notSpecifiedExportFile", new Object[0]));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            switch (this.execMode.ordinal()) {
                case 0: {
                    if (StringUtil.isBlank((String)this.eql)) {
                        this.logError(this.rs("EQLExecutor.notSpecifiedEQL", new Object[0]));
                        return this.isSuccess();
                    }
                    this.proceedBatch(this.eql);
                    break;
                }
                case 1: {
                    this.proceedInteract();
                }
            }
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    private void proceedBatch(String eql) {
        int count = -1;
        switch (this.eqlExecMode.ordinal()) {
            case 0: {
                if (StringUtil.isBlank((String)this.userId)) {
                    entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, false);
                    break;
                }
                entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, false, this.userId, this.password);
                break;
            }
            case 1: {
                if (StringUtil.isBlank((String)this.userId)) {
                    count = entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, true);
                    break;
                }
                count = entityToolService.executeEQLWithAuth(eql, this.isSearchAllVersion, true, this.userId, this.password);
                break;
            }
            case 2: {
                CloseShieldOutputStream out = CloseShieldOutputStream.wrap((OutputStream)System.out);
                if (StringUtil.isBlank((String)this.userId)) {
                    count = entityToolService.executeEQLWithAuth((OutputStream)out, System.getProperty("file.encoding"), eql, this.isSearchAllVersion);
                    break;
                }
                count = entityToolService.executeEQLWithAuth((OutputStream)out, System.getProperty("file.encoding"), eql, this.isSearchAllVersion, this.userId, this.password);
                break;
            }
            case 3: {
                File outFile = new File(this.exportFile);
                try {
                    if (StringUtil.isBlank((String)this.userId)) {
                        count = entityToolService.executeEQLWithAuth((OutputStream)new FileOutputStream(outFile), System.getProperty("file.encoding"), eql, this.isSearchAllVersion);
                        break;
                    }
                    count = entityToolService.executeEQLWithAuth((OutputStream)new FileOutputStream(outFile), System.getProperty("file.encoding"), eql, this.isSearchAllVersion, this.userId, this.password);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (count < 0) {
            System.out.println("\nexecuted.");
        } else {
            String format = count > 1 ? "\n%d rows selected." : "\n%d row selected.";
            System.out.println(String.format(format, count));
        }
    }

    private void proceedInteract() {
        try (Scanner sc = new Scanner(System.in);){
            boolean isMultiLine = false;
            StringBuilder sb = new StringBuilder();
            while (true) {
                System.out.print(isMultiLine ? "  -> " : "EQL> ");
                String cmd = sc.nextLine().trim();
                if (StringUtil.isBlank((String)cmd)) continue;
                if (!isMultiLine) {
                    if ("exit".equals(cmd.toLowerCase()) || "quit".equals(cmd.toLowerCase())) {
                        System.out.println("Bye");
                        break;
                    }
                    if (cmd.startsWith(SET_EQL_EXEC_MODE)) {
                        if (cmd.length() > SET_EQL_EXEC_MODE.length()) {
                            String mode = cmd.substring(SET_EQL_EXEC_MODE.length());
                            try {
                                this.eqlExecMode = EQLExecMode.valueOf(mode);
                            }
                            catch (Exception e) {
                                StringBuilder sbMode = new StringBuilder();
                                for (EQLExecMode eqlExecMode : EQLExecMode.values()) {
                                    if (sbMode.length() > 0) {
                                        sbMode.append("|");
                                    }
                                    sbMode.append(eqlExecMode.toString());
                                }
                                System.out.println("Usage: EQL_EXEC_MODE=[" + sbMode.toString() + "]");
                            }
                            continue;
                        }
                        System.out.println(this.eqlExecMode.toString());
                        continue;
                    }
                }
                if (cmd.endsWith(";")) {
                    sb.append(cmd.substring(0, cmd.length() - 1));
                    if (sb.length() > 0) {
                        try {
                            this.proceedBatch(sb.toString());
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                        sb.setLength(0);
                    } else {
                        System.out.println("No query specified");
                    }
                    isMultiLine = false;
                    continue;
                }
                sb.append(cmd).append(' ');
                isMultiLine = true;
            }
        }
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private static enum ExecMode {
        BATCH,
        INTERACT;

    }

    private static enum EQLExecMode {
        ONLY_EXEC,
        ONLY_COUNT,
        SHOW_SEARCH_RESULT,
        CSV_EXPORT;

    }
}

