/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entityport.EntityDataExportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityPortingService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.entity.EntityExportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityExport
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityExport.class);
    public static final String KEY_CONFIG_FILE = "entity.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String tenantUrl;
    private String entityName;
    private Properties properties;
    private Tenant tenant;
    private EntityDefinition ed;
    private String exportDirName;
    private boolean isExportBinaryData;
    public static final String ENTITY_LOB_DIR = "/lobs/";
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private EntityPortingService eps = (EntityPortingService)ServiceRegistry.getRegistry().getService(EntityPortingService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);

    public static void main(String[] args) {
        EntityExport instance = null;
        try {
            instance = new EntityExport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public EntityExport(String ... args) {
        if (args != null) {
            if (args.length > 0 && StringUtil.isNotBlank((String)args[0])) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && StringUtil.isNotBlank((String)args[1])) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && StringUtil.isNotBlank((String)args[2])) {
                this.entityName = args[2];
            }
            if (args.length > 3 && StringUtil.isNotBlank((String)args[3])) {
                this.exportDirName = args[3];
            }
            if (args.length > 4) {
                this.isExportBinaryData = Boolean.parseBoolean(args[4]);
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        this.loadConfigBaseInfo();
        if (!this.validateArguments()) {
            this.logInfo("");
            this.logError("\u25a0Execute Result : FAILED");
            return false;
        }
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Export Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Export Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    public EntityExport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public EntityExport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public EntityExport entity(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public EntityExport file(String exportDir) {
        this.exportDirName = exportDir;
        return this;
    }

    public EntityExport exportBinaryData(boolean isExportBinaryData) {
        this.isExportBinaryData = isExportBinaryData;
        return this;
    }

    public boolean exportEntity(final EntityExportParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){

            @Override
            public Boolean apply(Transaction t) {
                return EntityExport.this.executeTask(param, new EntityDataExportTask(param));
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(EntityExportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\tentity name :" + param.getEntityName());
        this.logInfo("\texport directory :" + param.getExportDirName());
        this.logInfo("\texport binary data :" + param.isExportBinaryData());
        EntityDataExportCondition condition = param.getEntityExportCondition();
        this.logInfo("\twhere clause :" + condition.getWhereClause());
        this.logInfo("\torder by clause :" + condition.getOrderByClause());
        this.logInfo("\tsearch all version :" + condition.isVersioned());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private <T> T executeTask(EntityExportParameter param, Supplier<T> task) {
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (T)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            return task.get();
        });
    }

    private boolean wizard() {
        if (this.tenant == null) {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            Object url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            this.tenant = this.ts.getTenant((String)url);
            if (this.tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        EntityExportParameter param = new EntityExportParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            String orderByClause;
            String whereClause;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validEntity = false;
            do {
                String inputEntityName = this.entityName;
                this.entityName = null;
                if (StringUtil.isEmpty((String)inputEntityName)) {
                    inputEntityName = this.readConsole(this.rs("EntityExport.Wizard.inputEntityNameMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputEntityName)) {
                    param.setEntityName(inputEntityName);
                    EntityDefinition ed = this.edm.get(inputEntityName);
                    if (ed == null) {
                        this.logWarn(this.rs("EntityExport.notExistsEntityMsg", inputEntityName));
                        continue;
                    }
                    validEntity = true;
                    continue;
                }
                this.logWarn(this.rs("EntityExport.Wizard.requiredEntityNameMsg", new Object[0]));
            } while (!validEntity);
            boolean validExportFile = false;
            do {
                File exportDir;
                String inputExportDirName = this.exportDirName;
                this.exportDirName = null;
                if (StringUtil.isEmpty((String)inputExportDirName)) {
                    inputExportDirName = this.readConsole(this.rs("EntityExport.Wizard.inputExportDirMsg", new Object[0]) + "(" + param.getExportDirName() + ")");
                }
                if (StringUtil.isNotBlank((String)inputExportDirName)) {
                    param.setExportDirName(inputExportDirName);
                }
                if (!this.checkDir(exportDir = new File(param.getExportDirName()))) continue;
                param.setExportDir(exportDir);
                validExportFile = true;
            } while (!validExportFile);
            boolean isExportBinaryData = this.readConsoleBoolean(this.rs("EntityExport.Wizard.confirmExportBinaryDataMsg", new Object[0]), param.isExportBinaryData());
            param.setExportBinaryData(isExportBinaryData);
            EntityDataExportCondition condition = this.loadConfigCondition();
            if (condition == null) {
                condition = new EntityDataExportCondition();
            }
            if (StringUtil.isNotBlank((String)(whereClause = this.readConsole(this.rs("EntityExport.Wizard.inputWhereClauseMsg", new Object[0]))))) {
                condition.setWhereClause(whereClause);
            }
            if (StringUtil.isNotBlank((String)(orderByClause = this.readConsole(this.rs("EntityExport.Wizard.inputOrderByClauseMsg", new Object[0]))))) {
                condition.setOrderByClause(orderByClause);
            }
            boolean isSearchAllVersion = this.readConsoleBoolean(this.rs("EntityExport.Wizard.confirmSearchAllVersionMsg", new Object[0]), condition.isVersioned());
            condition.setVersioned(isSearchAllVersion);
            param.setEntityExportCondition(condition);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("EntityExport.Wizard.confirmExportEntityMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("EntityExport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, (T paramA) -> this.exportEntity((EntityExportParameter)paramA));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadConfig() {
        Properties prop;
        block28: {
            if (this.properties != null) {
                return this.properties;
            }
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                return null;
            }
            prop = new Properties();
            try {
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    try (FileInputStream is2 = new FileInputStream(path.toFile());
                         InputStreamReader reader22 = new InputStreamReader((InputStream)is2, "UTF-8");){
                        prop.load(reader22);
                        break block28;
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                try (InputStream is = EntityExport.class.getResourceAsStream(configFileName);){
                    if (is == null) {
                        this.logWarn(this.rs("EntityExport.notExistsConfigFileMsg", configFileName));
                        Properties reader22 = null;
                        return reader22;
                    }
                    try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader);
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        this.properties = prop;
        return this.properties;
    }

    private void loadConfigBaseInfo() {
        String propExportBinaryData;
        String propExportDirName;
        String propEntityName;
        Properties prop = this.loadConfig();
        if (prop == null) {
            return;
        }
        if (this.tenantId == null) {
            Object propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId)) {
                this.tenantId = Integer.parseInt(propTenantId);
            }
            if (this.tenantId == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!((String)propTenantUrl).startsWith("/")) {
                    propTenantUrl = "/" + (String)propTenantUrl;
                }
                this.tenantUrl = propTenantUrl;
            }
        }
        if (this.entityName == null && StringUtil.isNotEmpty((String)(propEntityName = prop.getProperty("entityName")))) {
            this.entityName = propEntityName;
        }
        if (this.exportDirName == null && StringUtil.isNotEmpty((String)(propExportDirName = prop.getProperty("exportDir")))) {
            this.exportDirName = propExportDirName;
        }
        if (StringUtil.isNotEmpty((String)(propExportBinaryData = prop.getProperty("exportBinaryData")))) {
            this.isExportBinaryData = Boolean.valueOf(propExportBinaryData);
        }
    }

    private EntityDataExportCondition loadConfigCondition() {
        String propSearchAllVersion;
        String propOrderClause;
        Properties prop = this.loadConfig();
        if (prop == null) {
            return null;
        }
        EntityDataExportCondition condition = new EntityDataExportCondition();
        String propWhereClause = prop.getProperty("entity.whereClause");
        if (StringUtil.isNotEmpty((String)propWhereClause)) {
            condition.setWhereClause(propWhereClause);
        }
        if (StringUtil.isNotEmpty((String)(propOrderClause = prop.getProperty("entity.orderByClause")))) {
            condition.setOrderByClause(propOrderClause);
        }
        if (StringUtil.isNotEmpty((String)(propSearchAllVersion = prop.getProperty("entity.versioned")))) {
            condition.setVersioned(Boolean.valueOf(propSearchAllVersion).booleanValue());
        }
        return condition;
    }

    private boolean validateArguments() {
        File exportDir;
        TenantContext tc;
        boolean entityValid;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
            this.tenant = tenant;
        } else if (this.tenantUrl != null) {
            tenant = this.ts.getTenant(this.tenantUrl);
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantUrlMsg", this.tenantUrl));
                return false;
            }
            this.tenant = tenant;
        }
        if (StringUtil.isNotEmpty((String)this.entityName) && this.tenant != null && !(entityValid = ((Boolean)ExecuteContext.executeAs((TenantContext)(tc = this.tcs.getTenantContext(this.tenant.getId())), () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            EntityDefinition ed = this.edm.get(this.entityName);
            if (ed == null) {
                this.logError(this.rs("EntityExport.notExistsEntityMsg", this.entityName));
                return false;
            }
            this.ed = ed;
            return true;
        })).booleanValue())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.exportDirName) || this.checkDir(exportDir = new File(this.exportDirName));
    }

    private boolean silent() {
        if (this.tenant == null) {
            this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
            return false;
        }
        this.logInfo("target tenant:[" + this.tenant.getId() + "]" + this.tenant.getName());
        EntityExportParameter param = new EntityExportParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            File exportDir;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            if (this.ed == null) {
                this.logError(this.rs("Common.requiredMsg", "Entity name"));
                return false;
            }
            param.setEntityName(this.ed.getName());
            if (StringUtil.isNotEmpty((String)this.exportDirName)) {
                param.setExportDirName(this.exportDirName);
            }
            if (!this.checkDir(exportDir = new File(param.getExportDirName()))) {
                return false;
            }
            param.setExportDir(exportDir);
            param.setExportBinaryData(this.isExportBinaryData);
            EntityDataExportCondition condition = this.loadConfigCondition();
            if (condition == null) {
                condition = new EntityDataExportCondition();
            }
            param.setEntityExportCondition(condition);
            this.logArguments(param);
            return this.executeTask(param, (T paramA) -> this.exportEntity((EntityExportParameter)paramA));
        });
    }

    private boolean checkDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
            this.logInfo(this.rs("EntityExport.createdDirMsg", dir.getPath()));
        }
        if (!dir.isDirectory()) {
            this.logError(this.rs("EntityExport.notDirMsg", dir.getPath()));
            return false;
        }
        return true;
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private class EntityDataExportTask
    implements Supplier<Boolean> {
        private final EntityExportParameter param;

        public EntityDataExportTask(EntityExportParameter param) {
            this.param = param;
        }

        @Override
        public Boolean get() {
            Boolean bl;
            String entityPath = "/entity/" + this.param.getEntityName().replace(".", "/");
            MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(entityPath);
            if (entry == null) {
                throw new SystemException(EntityExport.this.rs("EntityExport.notExistsEntityMsg", new Object[]{this.param.getEntityName()}));
            }
            String exportBinaryDataDir = this.param.isExportBinaryData() ? this.param.getExportDirName() + EntityExport.ENTITY_LOB_DIR : null;
            FileOutputStream fos = new FileOutputStream(new File(this.param.getExportDir(), this.param.getEntityName() + ".csv"));
            try {
                EntityExport.this.eps.writeWithBinary((OutputStream)fos, entry, this.param.getEntityExportCondition(), null, exportBinaryDataDir);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            fos.close();
            return bl;
        }
    }
}

