/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.partition;

import java.util.List;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.partition.PartitionBatch;
import org.iplass.mtp.tools.gui.partition.MySQLPartitionManagerApp;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLPartitionBatch
extends MtpCuiBase
implements PartitionBatch {
    private static Logger logger = LoggerFactory.getLogger(MySQLPartitionBatch.class);
    private MySQLPartitionBatchExecMode execMode = MySQLPartitionBatchExecMode.GUI;
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);

    public static void main(String[] args) {
        MySQLPartitionBatch instance = null;
        try {
            instance = new MySQLPartitionBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (instance.getExecMode() == MySQLPartitionBatchExecMode.GUI) {
                MtpBatchResourceDisposer.addShutdownHookForDisposeResource(() -> {});
            } else {
                MtpBatchResourceDisposer.disposeResource();
            }
        }
    }

    public MySQLPartitionBatch(String ... args) {
        if (args != null && args.length > 0) {
            this.setExecMode(MySQLPartitionBatchExecMode.valueOf(args[0]));
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.getExecMode().ordinal()) {
            case 0: {
                this.logInfo("\u25a0Start App");
                this.logInfo("");
                this.switchLog(false, true);
                MySQLPartitionManagerApp.main(new String[]{this.getLanguage()});
                return true;
            }
            case 1: {
                this.logInfo("\u25a0Start Create Wizard");
                this.logInfo("");
                return this.startCreateWizard();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.getExecMode()));
        return false;
    }

    public MySQLPartitionBatchExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(MySQLPartitionBatchExecMode execMode) {
        this.execMode = execMode;
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return this.toolService.getPartitionInfo();
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        boolean isSuccess = this.toolService.createPartition(param, new LogHandler(){

            public void info(String message) {
                MySQLPartitionBatch.this.logInfo(message);
            }

            public void info(String message, Throwable e) {
                MySQLPartitionBatch.this.logInfo(message, e);
            }

            public void warn(String message) {
                MySQLPartitionBatch.this.logWarn(message);
            }

            public void warn(String message, Throwable e) {
                MySQLPartitionBatch.this.logWarn(message, e);
            }

            public void error(String message) {
                MySQLPartitionBatch.this.logError(message);
            }

            public void error(String message, Throwable e) {
                MySQLPartitionBatch.this.logError(message, e);
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    private boolean startCreateWizard() {
        String strMaxTenantId = this.readConsole(this.rs("MySQLPartitionManager.Create.inputMaxTenantIdMsg", new Object[0]));
        if (StringUtil.isEmpty((String)strMaxTenantId)) {
            this.logWarn(this.rs("MySQLPartitionManager.Create.requiredMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-show")) {
            this.showAllPartitionList();
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startCreateWizard();
        }
        PartitionCreateParameter param = new PartitionCreateParameter();
        try {
            int maxTenantId = Integer.parseInt(strMaxTenantId);
            param.setTenantId(maxTenantId);
        }
        catch (Exception e) {
            this.logWarn(this.rs("MySQLPartitionManager.Create.warnMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        this.logArguments(param);
        boolean isExecute = this.readConsoleBoolean(this.rs("MySQLPartitionManager.Create.confirmCreatePartitionMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startCreateWizard();
        }
        this.switchLog(false, true);
        return this.executeTask(param, paramA -> this.createPartition((PartitionCreateParameter)paramA));
    }

    private void showAllPartitionList() {
        try {
            List<PartitionInfo> partitionList = this.getPartitionInfo();
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Partition List(Max Tenant ID)");
            for (PartitionInfo partition : partitionList) {
                this.logInfo("[" + partition.getTableName() + "] " + partition.getMaxTenantId());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private void logArguments(PartitionCreateParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\tmax tenant id :" + param.getTenantId());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    public static enum MySQLPartitionBatchExecMode {
        GUI,
        CREATE;

    }
}

