/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.storagespace;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.stores.SchemalessRdbStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.datastore.DataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.TableAllocator;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.tools.storagespace.StorageSpaceService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.storagespace.tableallocators.LocationSpecificationTableAllocator;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageSpaceMigration
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(StorageSpaceMigration.class);
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static StorageSpaceService storageSpaceService = (StorageSpaceService)ServiceRegistry.getRegistry().getService(StorageSpaceService.class);
    private static final String CONSOLE_INPUT_PSEUDO_PARTITION_LOCATION_AUTO = "auto";
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private String entityName;
    private String storageSpaceName;
    private boolean withCleanup = true;
    private int pseudoPartitionLocation = -1;

    public StorageSpaceMigration(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(Integer.parseInt(args[1]));
            }
            if (args.length > 2) {
                this.setEntityName(args[2]);
            }
            if (args.length > 3) {
                this.setStorageSpaceName(args[3]);
            }
            if (args.length > 4) {
                this.setWithCleanup(Boolean.valueOf(args[4]));
            }
            if (args.length > 5) {
                this.setPseudoPartitionLocation(Integer.valueOf(args[5]));
            }
        }
    }

    public static void main(String[] args) {
        try {
            new StorageSpaceMigration(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setStorageSpaceName(String storageSpaceName) {
        this.storageSpaceName = storageSpaceName;
    }

    public void setWithCleanup(boolean withCleanup) {
        this.withCleanup = withCleanup;
    }

    public void setPseudoPartitionLocation(int pseudoPartitionLocation) {
        this.pseudoPartitionLocation = pseudoPartitionLocation;
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.executeTask(null, param -> this.proceed());
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("StorageSpaceMigration.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.setTenantId(Integer.parseInt(tenantId));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("StorageSpaceMigration.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        boolean validEntityName = false;
        do {
            String entityName;
            if (!StringUtil.isNotBlank((String)(entityName = this.readConsole(this.rs("StorageSpaceMigration.Wizard.entityNameMsg", new Object[0]))))) continue;
            this.setEntityName(entityName);
            validEntityName = true;
        } while (!validEntityName);
        boolean validStorageSpaceName = false;
        do {
            String storageSpaceName;
            if (!StringUtil.isNotBlank((String)(storageSpaceName = this.readConsole(this.rs("StorageSpaceMigration.Wizard.storageSpaceNameMsg", new Object[0]))))) continue;
            this.setStorageSpaceName(storageSpaceName);
            validStorageSpaceName = true;
        } while (!validStorageSpaceName);
        int tableCount = this.getStorageSpaceMap(this.storageSpaceName).getTableCount();
        if (1 < tableCount) {
            boolean validPseudoPartitionLocation = false;
            do {
                String readPseudoPartitionLocation;
                if (!StringUtil.isNotBlank((String)(readPseudoPartitionLocation = this.readConsole(this.rs("StorageSpaceMigration.Wizard.pseudoPartitionLocationMsg", tableCount - 1, CONSOLE_INPUT_PSEUDO_PARTITION_LOCATION_AUTO))))) continue;
                if (StringUtil.equalsIgnoreCase((String)CONSOLE_INPUT_PSEUDO_PARTITION_LOCATION_AUTO, (String)readPseudoPartitionLocation)) {
                    validPseudoPartitionLocation = true;
                    continue;
                }
                try {
                    int pseudoPartitionLocation = Integer.parseInt(readPseudoPartitionLocation);
                    if (0 > pseudoPartitionLocation || pseudoPartitionLocation >= tableCount) {
                        throw new IllegalArgumentException();
                    }
                    this.setPseudoPartitionLocation(pseudoPartitionLocation);
                    validPseudoPartitionLocation = true;
                }
                catch (IllegalArgumentException e) {
                    this.logWarn(this.rs("StorageSpaceMigration.Wizard.invalidPseudoPartitionLocationMsg", CONSOLE_INPUT_PSEUDO_PARTITION_LOCATION_AUTO));
                }
            } while (!validPseudoPartitionLocation);
        }
        this.setWithCleanup(this.readConsoleBoolean(this.rs("StorageSpaceMigration.Wizard.confirmCleanupMsg", new Object[0]), this.withCleanup));
        this.switchLog(false, true);
        return this.executeTask(null, param -> this.proceed());
    }

    private boolean proceed() {
        this.setSuccess(false);
        TenantContext tc = tenantContextService.getTenantContext(this.tenantId);
        if (tc == null) {
            this.logError(this.rs("StorageSpaceMigration.notFoundTenant", this.tenantId));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
            EntityDefinition ed = edm.get(this.entityName);
            if (ed == null) {
                this.logError(this.rs("StorageSpaceMigration.notFoundEntity", this.entityName));
                return this.isSuccess();
            }
            if (0 <= this.pseudoPartitionLocation) {
                int tableCount;
                StorageSpaceMap storageSpaceMap = this.getStorageSpaceMap(this.storageSpaceName);
                int n = tableCount = 0 < storageSpaceMap.getTableCount() ? storageSpaceMap.getTableCount() : 1;
                if (tableCount <= this.pseudoPartitionLocation) {
                    throw new IllegalArgumentException(this.rs("StorageSpaceMigration.overPseudoPartitionPosition", tableCount - 1, this.pseudoPartitionLocation));
                }
                storageSpaceMap.setTableAllocator((TableAllocator)new LocationSpecificationTableAllocator(this.pseudoPartitionLocation));
                StoreService storeService = (StoreService)ServiceRegistry.getRegistry().getService(StoreService.class);
                DataStore dataStore = storeService.getDataStore();
                ((GRdbDataStore)dataStore).setForceRegenerateTableNamePostfix(true);
            }
            String currentStorageSpaceName = ((SchemalessRdbStore)ed.getStoreDefinition()).getStorageSpace();
            String currentTableNamePostfix = storageSpaceService.getTableNamePostfix(this.entityName);
            try {
                storageSpaceService.migrate(this.storageSpaceName, ed);
            }
            catch (Exception e) {
                this.logError(this.rs("StorageSpaceMigration.failedMigrate", new Object[0]), e);
                return this.isSuccess();
            }
            if (this.withCleanup) {
                try {
                    MetaEntity metaEntity = ((EntityHandler)MetaDataContext.getContext().getMetaDataHandler(EntityHandler.class, "/entity/" + this.entityName.replace(".", "/"))).getMetaData();
                    storageSpaceService.cleanup(this.tenantId, currentStorageSpaceName, metaEntity, currentTableNamePostfix);
                }
                catch (Exception e) {
                    this.logError(this.rs("StorageSpaceMigration.failedCleanup", new Object[0]), e);
                    return this.isSuccess();
                }
            }
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private StorageSpaceMap getStorageSpaceMap(String storageSpaceName) {
        StoreService storeService = (StoreService)ServiceRegistry.getRegistry().getService(StoreService.class);
        DataStore dataStore = storeService.getDataStore();
        if (null != dataStore && dataStore instanceof GRdbDataStore) {
            StorageSpaceMap storageSpaceMap = (StorageSpaceMap)((GRdbDataStore)dataStore).getStorageSpaceMap().get(storageSpaceName);
            if (null == storageSpaceMap) {
                throw new IllegalArgumentException(this.rs("StorageSpaceMigration.notFoundStorageSpace", storageSpaceName));
            }
            return storageSpaceMap;
        }
        throw new RuntimeException("DataStore is null or the class is of an unexpected type. type = " + (null == dataStore ? "null" : dataStore.getClass().getName()));
    }
}

