/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.tenant;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.TenantDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.gui.tenant.TenantManagerApp;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantBatch
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(TenantBatch.class);
    public static final String KEY_CONFIG_FILE = "tenant.config";
    private TenantBatchExecMode execMode = TenantBatchExecMode.GUI;
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);

    public static void main(String[] args) {
        TenantBatch instance = null;
        try {
            instance = new TenantBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (instance.getExecMode() == TenantBatchExecMode.GUI) {
                MtpBatchResourceDisposer.addShutdownHookForDisposeResource(() -> {});
            } else {
                MtpBatchResourceDisposer.disposeResource();
            }
        }
    }

    public TenantBatch(String ... args) {
        if (args != null && args.length > 0 && args[0] != null) {
            this.setExecMode(TenantBatchExecMode.valueOf(args[0].toUpperCase()));
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.getExecMode().ordinal()) {
            case 0: {
                this.logInfo("\u25a0Start App");
                this.logInfo("");
                this.switchLog(false, true);
                TenantManagerApp.main(new String[]{this.getLanguage()});
                return true;
            }
            case 1: {
                this.logInfo("\u25a0Start Create Wizard");
                this.logInfo("");
                return this.startCreateWizard();
            }
            case 2: {
                this.logInfo("\u25a0Start Delete Wizard");
                this.logInfo("");
                return this.startDeleteWizard();
            }
            case 3: {
                this.showAllTenantList();
                this.logInfo("");
                return true;
            }
            case 4: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.startSilent();
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.getExecMode()));
        return false;
    }

    public TenantBatchExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(TenantBatchExecMode execMode) {
        this.execMode = execMode;
    }

    public boolean executeCreate(TenantCreateParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        try {
            boolean isSuccess = this.toolService.create(param, (LogHandler)new TenantBatchLogListener());
            this.setSuccess(isSuccess);
        }
        finally {
            ExecuteContext.initContext(null);
        }
        return this.isSuccess();
    }

    public void logArguments(TenantCreateParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant url :" + param.getTenantUrl());
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\ttenant display name :" + param.getTenantDisplayName());
        this.logInfo("\tadmin accunt id :" + param.getAdminUserId());
        this.logInfo("\ttopUrl :" + param.getTopUrl());
        this.logInfo("\tuseLanguages :" + param.getUseLanguages());
        this.logInfo("\tcreateBlankTenant :" + param.isCreateBlankTenant());
        if (this.getConfigSetting().isPostgreSQL()) {
            this.logInfo("\tsubpartition size :" + param.getSubPartitionSize());
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean startCreateWizard() {
        String tenantName = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantNameMsg", new Object[0]));
        if (StringUtil.isEmpty((String)tenantName)) {
            this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredTenantNameMsg", new Object[0]));
            return this.startCreateWizard();
        }
        if (tenantName.equalsIgnoreCase("-show")) {
            this.showAllTenantList();
            return this.startCreateWizard();
        }
        if (tenantName.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startCreateWizard();
        }
        Object tenantUrl = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantUrlMsg", new Object[0]) + "(/" + tenantName + ")");
        if (StringUtil.isEmpty((String)tenantUrl)) {
            tenantUrl = "/" + tenantName;
        }
        if (this.toolService.existsURL((String)tenantUrl)) {
            this.logWarn(this.rs("TenantBatch.Create.Wizard.existsTenantMsg", tenantUrl));
            return this.startCreateWizard();
        }
        String adminUserId = null;
        do {
            if (!StringUtil.isEmpty((String)(adminUserId = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputAdminIdMsg", new Object[0]))))) continue;
            this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminIdMsg", new Object[0]));
            adminUserId = null;
        } while (adminUserId == null);
        String adminPW = null;
        boolean invalidateAdminPW = true;
        while (true) {
            if (StringUtil.isEmpty((String)(adminPW = this.readConsolePassword(this.rs("TenantBatch.Create.Wizard.inputAdminPWMsg", new Object[0]))))) {
                this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminPWMsg", new Object[0]));
                adminPW = null;
            }
            if (adminPW == null) continue;
            String confirmAdminPW = null;
            do {
                if (!StringUtil.isEmpty((String)(confirmAdminPW = this.readConsolePassword(this.rs("TenantBatch.Create.Wizard.inputReTypeAdminPWMsg", new Object[0]))))) continue;
                this.logWarn(this.rs("TenantBatch.Create.Wizard.requiredAdminPWMsg", new Object[0]));
                confirmAdminPW = null;
            } while (confirmAdminPW == null);
            if (!adminPW.equals(confirmAdminPW)) {
                this.logWarn(this.rs("TenantBatch.Create.Wizard.unmatchAdminPWMsg", new Object[0]));
                adminPW = null;
                confirmAdminPW = null;
            } else {
                invalidateAdminPW = false;
            }
            if (!invalidateAdminPW) break;
        }
        TenantCreateParameter createParam = new TenantCreateParameter(tenantName, adminUserId, adminPW);
        createParam.setTenantUrl((String)tenantUrl);
        createParam.setUseLanguages(this.toolService.getDefaultEnableLanguages());
        boolean isDefault = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.confirmDefaultMsg", new Object[0]), false);
        if (!isDefault) {
            String topURL;
            String tenantDisplayName = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTenantDispNameMsg", new Object[0]));
            if (StringUtil.isNotBlank((String)tenantDisplayName)) {
                createParam.setTenantDisplayName(tenantDisplayName);
            }
            if (StringUtil.isNotBlank((String)(topURL = this.readConsole(this.rs("TenantBatch.Create.Wizard.inputTopUrlMsg", new Object[0]))))) {
                createParam.setTopUrl(topURL);
            }
            String lang = this.readConsole(this.rs("TenantBatch.Create.Wizard.useMultiLangMsg", new Object[0]));
            createParam.setUseLanguages(lang);
            boolean isBlank = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.createBlankTenantMsg", new Object[0]), false);
            createParam.setCreateBlankTenant(isBlank);
            if (this.getConfigSetting().isPostgreSQL()) {
                boolean invalidateSubPartitionSize = true;
                do {
                    int subPartitionSize;
                    if ((subPartitionSize = this.readConsoleInteger(this.rs("TenantBatch.Create.Wizard.inputSubPartitionSizeMsg", new Object[0]), 8)) < 0) {
                        this.logWarn(this.rs("TenantBatch.Create.Wizard.invalidValueSubPartitionSizeMsg", 0));
                        continue;
                    }
                    createParam.setSubPartitionSize(subPartitionSize);
                    invalidateSubPartitionSize = false;
                } while (invalidateSubPartitionSize);
            }
        }
        this.logArguments(createParam);
        boolean isExecute = this.readConsoleBoolean(this.rs("TenantBatch.Create.Wizard.confirmCreateTenantMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startCreateWizard();
        }
        this.switchLog(false, true);
        return this.executeTask(createParam, param -> this.executeCreate((TenantCreateParameter)param));
    }

    public boolean executeDelete(TenantDeleteParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        try {
            boolean isSuccess = this.toolService.remove(param, (LogHandler)new TenantBatchLogListener());
            this.setSuccess(isSuccess);
        }
        finally {
            ExecuteContext.initContext(null);
        }
        return this.isSuccess();
    }

    public void logArguments(TenantDeleteParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\ttenant id :" + param.getTenantId());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean startDeleteWizard() {
        String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
        if (StringUtil.isEmpty((String)tenantUrl) || tenantUrl.equalsIgnoreCase("-show")) {
            this.showAllTenantList();
            return this.startDeleteWizard();
        }
        if (tenantUrl.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startDeleteWizard();
        }
        TenantInfo tenant = this.toolService.getTenantInfo(tenantUrl);
        if (tenant == null) {
            this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
            return this.startDeleteWizard();
        }
        TenantDeleteParameter deleteParam = new TenantDeleteParameter();
        deleteParam.setTenantId(tenant.getId());
        deleteParam.setTenantName(tenant.getName());
        this.logArguments(deleteParam);
        boolean isExecute = this.readConsoleBoolean(this.rs("TenantBatch.Delete.Wizard.confirmRemoveTenantMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startDeleteWizard();
        }
        this.switchLog(false, true);
        return this.executeTask(deleteParam, param -> this.executeDelete((TenantDeleteParameter)param));
    }

    private boolean startCreateSilent(Properties prop) {
        String registId;
        String strSubPartitionSize;
        String useLanguages;
        String topUrl;
        String tenantName = prop.getProperty("tenantName");
        if (StringUtil.isBlank((String)tenantName)) {
            this.logError(this.rs("TenantBatch.Silent.requiredTenantNameMsg", new Object[0]));
            return false;
        }
        String adminUserId = prop.getProperty("adminUserId");
        if (StringUtil.isBlank((String)adminUserId)) {
            this.logError(this.rs("TenantBatch.Silent.requiredAdminUserIdMsg", new Object[0]));
            return false;
        }
        String adminPassword = prop.getProperty("adminPassword");
        if (StringUtil.isBlank((String)adminPassword)) {
            this.logError(this.rs("TenantBatch.Silent.requiredAdminPasswordMsg", new Object[0]));
            return false;
        }
        TenantCreateParameter createParam = new TenantCreateParameter(tenantName, adminUserId, adminPassword);
        String tenantUrl = prop.getProperty("tenantUrl");
        if (StringUtil.isNotBlank((String)tenantUrl)) {
            createParam.setTenantUrl(tenantUrl);
        }
        if (this.toolService.existsURL(createParam.getTenantUrl())) {
            this.logError(this.rs("TenantBatch.Silent.existsTenantMsg", createParam.getTenantUrl()));
            return false;
        }
        String tenantDisplayName = prop.getProperty("tenantDisplayName");
        if (tenantDisplayName != null) {
            createParam.setTenantDisplayName(tenantDisplayName);
        }
        if ((topUrl = prop.getProperty("topUrl")) != null) {
            createParam.setTopUrl(topUrl);
        }
        if ((useLanguages = prop.getProperty("useLanguages")) != null) {
            createParam.setUseLanguages(useLanguages);
        } else {
            createParam.setUseLanguages(this.toolService.getDefaultEnableLanguages());
        }
        String createBlankTenant = prop.getProperty("createBlankTenant");
        if (createBlankTenant != null) {
            createParam.setCreateBlankTenant(Boolean.parseBoolean(createBlankTenant));
        }
        if ((strSubPartitionSize = prop.getProperty("subPartitionSize")) != null && StringUtil.isNotBlank((String)strSubPartitionSize)) {
            try {
                int subPartitionSize = Integer.parseInt(strSubPartitionSize);
                if (subPartitionSize < 0) {
                    this.logError(this.rs("TenantBatch.Silent.invalidValueSubPartitionSizeMsg", 0));
                    return false;
                }
                createParam.setSubPartitionSize(subPartitionSize);
            }
            catch (NumberFormatException e) {
                this.logError(this.rs("TenantBatch.Silent.invalidSubPartitionSizeMsg", new Object[0]));
                return false;
            }
        }
        if ((registId = prop.getProperty("registId")) != null) {
            createParam.setRegistId(registId);
        }
        this.logArguments(createParam);
        boolean ret = this.executeTask(createParam, param -> this.executeCreate((TenantCreateParameter)param));
        return ret;
    }

    private boolean startSilent() {
        Properties prop;
        block17: {
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isBlank((String)configFileName)) {
                this.logError(this.rs("TenantBatch.Silent.requiredConfigFileMsg", KEY_CONFIG_FILE));
                return false;
            }
            prop = new Properties();
            try {
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    try (BufferedReader reader = Files.newBufferedReader(path);){
                        prop.load(reader);
                        break block17;
                    }
                }
                URL url = TenantBatch.class.getResource(configFileName);
                if (url != null) {
                    this.logDebug("load config file from classpath:" + configFileName);
                    try (BufferedReader reader = Files.newBufferedReader(Paths.get(url.toURI()));){
                        prop.load(reader);
                        break block17;
                    }
                }
                this.logError(this.rs("TenantBatch.Silent.notExistsConfigFileMsg", configFileName));
                return false;
            }
            catch (IOException | URISyntaxException e) {
                throw new SystemException((Throwable)e);
            }
        }
        return this.startCreateSilent(prop);
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    public static enum TenantBatchExecMode {
        GUI,
        CREATE,
        DELETE,
        SHOW,
        SILENT;

    }

    private class TenantBatchLogListener
    implements LogHandler {
        private TenantBatchLogListener() {
        }

        public void info(String message) {
            TenantBatch.this.logInfo(message);
        }

        public void info(String message, Throwable e) {
            TenantBatch.this.logInfo(message, e);
        }

        public void warn(String message) {
            TenantBatch.this.logWarn(message);
        }

        public void warn(String message, Throwable e) {
            TenantBatch.this.logWarn(message, e);
        }

        public void error(String message) {
            TenantBatch.this.logError(message);
        }

        public void error(String message, Throwable e) {
            TenantBatch.this.logError(message, e);
        }
    }
}

