/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.batch;

import java.util.concurrent.Callable;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.spi.ServiceRegistry;

public class BatchTask<V>
implements Callable<V> {
    private final Callable<V> actualTask;
    private final String tenantName;
    private final String userId;
    private final String password;

    public BatchTask(Callable<V> actualTask, String tenantName) {
        this(actualTask, tenantName, null, null);
    }

    public BatchTask(Callable<V> actualTask, String tenantName, String userId, String password) {
        this.tenantName = tenantName;
        this.userId = userId;
        this.password = password;
        InitRHInterceptor task = actualTask;
        this.actualTask = task = new InitRHInterceptor(this, new TenantInterceptor(new AuthInterceptor(task)));
    }

    @Override
    public V call() throws Exception {
        return this.actualTask.call();
    }

    private class InitRHInterceptor
    implements Callable<V> {
        private final Callable<V> actualTask;

        private InitRHInterceptor(BatchTask batchTask, Callable<V> actualTask) {
            this.actualTask = actualTask;
        }

        @Override
        public V call() throws Exception {
            boolean isInit = false;
            try {
                isInit = ResourceHolder.init();
                Object v = this.actualTask.call();
                return v;
            }
            finally {
                if (isInit) {
                    ResourceHolder.fin();
                }
            }
        }
    }

    private class TenantInterceptor
    implements Callable<V> {
        private final Callable<V> actualTask;

        private TenantInterceptor(Callable<V> actualTask) {
            this.actualTask = actualTask;
        }

        @Override
        public V call() throws Exception {
            boolean needInit = false;
            if (!ExecuteContext.isInited()) {
                needInit = true;
            } else if (!BatchTask.this.tenantName.equals(ExecuteContext.getCurrentContext().getCurrentTenant().getName())) {
                needInit = true;
            }
            if (needInit) {
                TenantContext tc = ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).getTenantContext("/" + BatchTask.this.tenantName);
                if (tc == null) {
                    throw new IllegalArgumentException("tenantName:" + BatchTask.this.tenantName + " not found");
                }
                try {
                    return ExecuteContext.executeAs((TenantContext)tc, (Executable)new Executable<V>(){

                        public V execute() {
                            try {
                                return TenantInterceptor.this.actualTask.call();
                            }
                            catch (Exception e) {
                                throw new WrapException(e);
                            }
                        }
                    });
                }
                catch (WrapException e) {
                    throw (Exception)e.getCause();
                }
            }
            return this.actualTask.call();
        }
    }

    private class AuthInterceptor
    implements Callable<V> {
        private final Callable<V> actualTask;

        private AuthInterceptor(Callable<V> actualTask) {
            this.actualTask = actualTask;
        }

        @Override
        public V call() throws Exception {
            if (BatchTask.this.userId != null) {
                AuthService as = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
                as.login((Credential)new IdPasswordCredential(BatchTask.this.userId, BatchTask.this.password));
                try {
                    return as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> {
                        try {
                            return this.actualTask.call();
                        }
                        catch (Exception e) {
                            throw new WrapException(e);
                        }
                    });
                }
                catch (WrapException e) {
                    throw (Exception)e.getCause();
                }
            }
            ExecuteContext.getCurrentContext().setClientId("batchTask");
            return this.actualTask.call();
        }
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = 5933671029711171148L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }
}

