/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.fulltextsearch;

import java.util.Date;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchManager;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpSilentBatch;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDataCrawler
extends MtpSilentBatch {
    private static final Logger logger = LoggerFactory.getLogger(EntityDataCrawler.class);
    private TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private FulltextSearchManager fsm = (FulltextSearchManager)ManagerLocator.getInstance().getManager(FulltextSearchManager.class);
    private Mode mode;
    private int tenantId;
    private String entityName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Date sysDate = new Date();
        logger.debug("### Started Crawling [" + String.valueOf(sysDate) + "] ###");
        if (args != null && args.length > 0) {
            Mode mode = null;
            if (Mode.CRAWL.name().equalsIgnoreCase(args[0])) {
                mode = Mode.CRAWL;
            } else if (Mode.RECRAWL.name().equalsIgnoreCase(args[0])) {
                mode = Mode.RECRAWL;
            }
            if (mode != null) {
                int tenantId = -1;
                String ename = null;
                if (args.length > 1) {
                    tenantId = Integer.parseInt(args[1]);
                }
                if (args.length > 2 && args[2] != null && !args[2].trim().isEmpty()) {
                    ename = args[2];
                }
                try {
                    if (tenantId >= 0) {
                        new EntityDataCrawler(mode, tenantId, ename).execute();
                    } else {
                        List<TenantInfo> tenants = EntityDataCrawler.getValidTenantInfoList();
                        if (tenants != null) {
                            for (TenantInfo t : tenants) {
                                new EntityDataCrawler(mode, t.getId(), ename).execute();
                            }
                        }
                    }
                }
                finally {
                    MtpBatchResourceDisposer.disposeResource();
                }
            }
        }
        sysDate = new Date();
        logger.debug("### Finished Crawling [" + String.valueOf(sysDate) + "] ###");
    }

    public EntityDataCrawler(Mode mode, int tenantId, String entityName) {
        this.mode = mode;
        this.tenantId = tenantId;
        this.entityName = entityName;
    }

    public boolean execute() throws Exception {
        this.setSuccess(false);
        this.clearLog();
        return this.executeTask(null, param -> {
            ExecuteContext.executeAs((TenantContext)this.tenantContextService.getTenantContext(this.tenantId), (Executable)new Executable<Void>(){

                public Void execute() {
                    EntityDataCrawler.this.logArguments();
                    Transaction.required(t -> {
                        switch (EntityDataCrawler.this.mode.ordinal()) {
                            case 1: {
                                EntityDataCrawler.this.crawl();
                                break;
                            }
                            case 0: {
                                EntityDataCrawler.this.recrawl();
                                break;
                            }
                        }
                    });
                    return null;
                }
            });
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    private void logArguments() {
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant id :" + this.tenantId);
        this.logInfo("\tmode :" + this.mode.name());
        this.logInfo("\tentity name :" + this.entityName);
        this.logInfo("");
    }

    private void crawl() {
        if (this.entityName != null) {
            logger.debug("### CRAWL Target TenantId :" + this.tenantId + " EntityName :" + this.entityName + " ###");
            this.fsm.crawlEntity(this.entityName);
        } else {
            logger.debug("### CRAWL Target TenantId :" + this.tenantId + " ###");
            this.fsm.crawlAllEntity();
        }
    }

    private void recrawl() {
        if (this.entityName != null) {
            throw new IllegalArgumentException("EntityName can only be specified in CRAWL mode.");
        }
        logger.debug("### RECRAWL Target TenantId :" + this.tenantId + " ###");
        this.fsm.recrawlAllEntity();
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    static enum Mode {
        RECRAWL,
        CRAWL;

    }
}

