/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.storagespace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.RawColIndexType;
import org.iplass.mtp.impl.datastore.grdb.RawColType;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptService;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.storagespace.ObjStoreDDLParameter;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjStoreDDLGenerateBatch
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(ObjStoreDDLGenerateBatch.class);
    private static String[] templates = new String[]{"obj_store_rb.gtl", "obj_store.gtl", "obj_ref_rb.gtl", "obj_ref.gtl", "obj_index_date.gtl", "obj_index_dbl.gtl", "obj_index_num.gtl", "obj_index_str.gtl", "obj_index_ts.gtl", "obj_unique_date.gtl", "obj_unique_dbl.gtl", "obj_unique_num.gtl", "obj_unique_str.gtl", "obj_unique_ts.gtl"};
    private static String[] compressedFormats = new String[]{"zlib", "lz4", "none"};
    private ExecMode execMode = ExecMode.WIZARD;
    private ObjStoreDDLParameter parameter;
    private GRdbDataStore store = (GRdbDataStore)((StoreService)ServiceRegistry.getRegistry().getService(StoreService.class)).getDataStore();
    private boolean columnNameLowerCase = false;

    public static void main(String[] args) throws Exception {
        ObjStoreDDLGenerateBatch instance = null;
        try {
            instance = new ObjStoreDDLGenerateBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public ObjStoreDDLGenerateBatch(String ... args) throws Exception {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            this.parameter = new ObjStoreDDLParameter();
            if (args.length > 1) {
                this.parameter.setTemplateRootPath(args[1]);
            }
            if (args.length > 2) {
                this.parameter.setOutputPath(args[2]);
            }
            if (args.length > 3 && !args[3].equalsIgnoreCase("all")) {
                String[] spaceNames = args[3].split(",");
                for (int i = 0; i < spaceNames.length; ++i) {
                    spaceNames[i] = spaceNames[i].trim();
                }
                this.parameter.setStorageSpaceName(spaceNames);
            }
            if (args.length > 4) {
                this.parameter.setUsePartition("TRUE".equalsIgnoreCase(args[4]));
            } else if (this.getConfigSetting().isSQLServer()) {
                this.parameter.setUsePartition(false);
            } else if (this.getConfigSetting().isPostgreSQL()) {
                this.parameter.setUsePartition(false);
            }
            if (args.length > 5) {
                if (this.getConfigSetting().isMySQL()) {
                    if (Arrays.asList(compressedFormats).contains(args[5])) {
                        this.parameter.setUseCompression(true);
                        this.parameter.setCompressedFormat(args[5]);
                    } else {
                        this.parameter.setUseCompression(false);
                    }
                } else {
                    this.parameter.setUseCompression(false);
                }
            }
        }
        if (this.getConfigSetting().isPostgreSQL()) {
            this.columnNameLowerCase = true;
        }
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.executeTask(null, param -> this.generate());
            }
        }
        this.logError("unsupport execute mode : " + String.valueOf((Object)this.execMode));
        return false;
    }

    private boolean generate() {
        GroovyScriptEngine gse = (GroovyScriptEngine)((ScriptService)ServiceRegistry.getRegistry().getService(ScriptService.class)).createScriptEngine();
        this.setSuccess(false);
        try {
            for (String tmplName : templates) {
                GroovyTemplate tmpl = this.getTemplate(tmplName, gse);
                try (Writer w = this.getWriter(tmplName.replace(".gtl", ".sql"));){
                    for (StorageSpaceMap e : this.store.getStorageSpaceMap().values()) {
                        if (this.parameter.getStorageSpaceName() != null && !this.contains(this.parameter.getStorageSpaceName(), e.getStorageSpaceName())) continue;
                        List allPostFix = e.allTableNamePostfix();
                        List<Col> cols = this.toCol(e);
                        for (String pf : allPostFix) {
                            HashMap<String, Object> bindings = new HashMap<String, Object>();
                            if (pf != null) {
                                bindings.put("tableNamePostfix", "__" + pf);
                            } else {
                                bindings.put("tableNamePostfix", "");
                            }
                            bindings.put("columns", cols);
                            bindings.put("partition", this.parameter.isUsePartition() && !e.isCustomPartition());
                            bindings.put("compression", this.parameter.isUseCompression());
                            bindings.put("compressedFormat", this.parameter.getCompressedFormat());
                            GroovyTemplateBinding gtb = new GroovyTemplateBinding(w, bindings);
                            tmpl.doTemplate(gtb);
                            w.append(System.lineSeparator());
                        }
                    }
                    w.flush();
                }
            }
            this.setSuccess(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            ExecuteContext.initContext(null);
        }
        return this.isSuccess();
    }

    private GroovyTemplate getTemplate(String name, GroovyScriptEngine gse) throws Exception {
        try (FileInputStream is = new FileInputStream(new File(this.parameter.getTemplateRootPath(), name));){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            GroovyTemplate groovyTemplate = GroovyTemplateCompiler.compile((String)str, (String)name, (GroovyScriptEngine)gse);
            return groovyTemplate;
        }
    }

    private Writer getWriter(String name) throws Exception {
        if (this.parameter.getOutputPath() != null) {
            File f;
            File root = new File(this.parameter.getOutputPath());
            if (!root.exists()) {
                root.mkdirs();
            }
            if ((f = new File(this.parameter.getOutputPath(), name)).exists()) {
                f.delete();
            }
            f.createNewFile();
            return new FileWriter(f);
        }
        return new PrintWriter(this, System.out){

            @Override
            public void close() {
                this.flush();
            }
        };
    }

    private boolean contains(String[] list, String target) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    private void setVector(Col[] cols, RawColType type, RawColIndexType indexType, double distance, int targetMaxCol) {
        for (int i = 1; i <= targetMaxCol; ++i) {
            cols[(int)Math.round((double)((double)i * distance)) - 1] = new Col(type, indexType, this.columnNameLowerCase ? type.getColNamePrefix(indexType).toLowerCase() : type.getColNamePrefix(indexType), i);
        }
    }

    private List<Col> toCol(StorageSpaceMap e) {
        ArrayList<Col> res = new ArrayList<Col>();
        int maxCol = e.maxColumns();
        RawColType[] types = RawColType.values();
        RawColIndexType[] indexTypes = new RawColIndexType[]{RawColIndexType.UNIQUE_INDEX, RawColIndexType.INDEX, RawColIndexType.NONE};
        Col[][][] matrix = new Col[types.length][indexTypes.length][maxCol];
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < indexTypes.length; ++j) {
                int targetMaxCol = types[i].getMaxCol(e, indexTypes[j]);
                double distance = 0.0;
                if (targetMaxCol != 0) {
                    distance = maxCol / targetMaxCol;
                }
                this.setVector(matrix[i][j], types[i], indexTypes[j], distance, targetMaxCol);
            }
        }
        for (int j = 0; j < indexTypes.length; ++j) {
            for (int i = 0; i < maxCol; ++i) {
                for (int k = 0; k < types.length; ++k) {
                    if (matrix[k][j][i] == null) continue;
                    res.add(matrix[k][j][i]);
                }
            }
        }
        return res;
    }

    private boolean startWizard() throws Exception {
        ObjStoreDDLParameter param = new ObjStoreDDLParameter();
        boolean validTemplateFile = false;
        do {
            String defaultPath = "./../template/" + (this.getConfigSetting().isOracle() ? "oracle" : (this.getConfigSetting().isSQLServer() ? "sqlserver" : (this.getConfigSetting().isPostgreSQL() ? "postgresql" : "mysql")));
            String templatePath = this.readConsole(this.rs("ObjStoreDDLGenerator.Wizard.templateDirMsg", new Object[0]) + "(" + defaultPath + ")");
            if (StringUtil.isNotBlank((String)templatePath)) {
                param.setTemplateRootPath(templatePath);
            } else {
                param.setTemplateRootPath(defaultPath);
            }
            File templateDir = new File(param.getTemplateRootPath());
            if (!templateDir.exists()) {
                this.logWarn(this.rs("ObjStoreDDLGenerator.Wizard.notExistsDirMsg", templateDir.getAbsolutePath()));
                continue;
            }
            if (!templateDir.isDirectory()) {
                this.logWarn(this.rs("ObjStoreDDLGenerator.Wizard.notDirMsg", templateDir.getAbsolutePath()));
                continue;
            }
            param.setTemplateRootDir(templateDir);
            validTemplateFile = true;
        } while (!validTemplateFile);
        boolean validOutputFile = false;
        do {
            File outputDir;
            String outputPath;
            if (StringUtil.isNotBlank((String)(outputPath = this.readConsole(this.rs("ObjStoreDDLGenerator.Wizard.outputDirMsg", new Object[0]) + "(" + param.getOutputPath() + ")")))) {
                param.setOutputPath(outputPath);
            }
            if (!(outputDir = new File(param.getOutputPath())).exists()) {
                outputDir.mkdir();
                this.logInfo(this.rs("ObjStoreDDLGenerator.Wizard.createdOutputDirMsg", param.getOutputPath()));
            }
            if (!outputDir.isDirectory()) {
                this.logWarn(this.rs("ObjStoreDDLGenerator.Wizard.notDirMsg", param.getOutputPath()));
                continue;
            }
            param.setOutputDir(outputDir);
            validOutputFile = true;
        } while (!validOutputFile);
        boolean validStorageSpaceName = false;
        ArrayList<StorageSpaceMap> ssList = new ArrayList<StorageSpaceMap>();
        do {
            String storageSpaceName;
            if (StringUtil.isNotBlank((String)(storageSpaceName = this.readConsole(this.rs("ObjStoreDDLGenerator.Wizard.storageSpaceNameMsg", new Object[0]) + "()")))) {
                param.setStorageSpaceName(storageSpaceName.split(","));
                if (param.getStorageSpaceName() == null) continue;
                boolean existsName = false;
                for (String target : param.getStorageSpaceName()) {
                    existsName = false;
                    for (StorageSpaceMap e : this.store.getStorageSpaceMap().values()) {
                        if (!target.equals(e.getStorageSpaceName())) continue;
                        existsName = true;
                        ssList.add(e);
                        break;
                    }
                    if (existsName) continue;
                    this.logWarn(this.rs("ObjStoreDDLGenerator.Wizard.notStorageSpaceMsg", target));
                    break;
                }
                validStorageSpaceName = existsName;
                continue;
            }
            param.setStorageSpaceName(null);
            validStorageSpaceName = true;
        } while (!validStorageSpaceName);
        boolean checkPartition = false;
        if (ssList.isEmpty()) {
            checkPartition = true;
        } else {
            for (StorageSpaceMap e : ssList) {
                if (e.isCustomPartition()) continue;
                checkPartition = true;
                break;
            }
        }
        if (checkPartition) {
            if (this.getConfigSetting().isPostgreSQL()) {
                param.setUsePartition(false);
            }
            if (this.getConfigSetting().isSQLServer()) {
                param.setUsePartition(false);
            }
            boolean usePartition = this.readConsoleBoolean(this.rs("ObjStoreDDLGenerator.Wizard.confirmPartitionMsg", new Object[0]), param.isUsePartition());
            param.setUsePartition(usePartition);
        } else {
            param.setUsePartition(false);
        }
        if (this.getConfigSetting().isMySQL()) {
            String compressedFormat = this.readConsole(this.rs("ObjStoreDDLGenerator.Wizard.confirmCompressionMsg", new Object[0]));
            if (StringUtil.isNotBlank((String)compressedFormat)) {
                param.setCompressedFormat(compressedFormat);
            }
            if (Arrays.asList(compressedFormats).contains(compressedFormat)) {
                param.setUseCompression(true);
            } else {
                param.setUseCompression(false);
            }
        } else {
            param.setUseCompression(false);
        }
        this.parameter = param;
        this.switchLog(false, true);
        return this.executeTask(null, paramA -> this.generate());
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    public static class Col {
        String type;
        String indexType;
        String prefix;
        int no;

        public Col(RawColType type, RawColIndexType indexType, String prefix, int no) {
            this.type = type.toString();
            this.indexType = indexType.toString();
            this.prefix = prefix;
            this.no = no;
        }
    }
}

